package com.biz.crm.tpm.business.material.purchasing.order.local.service.internal;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.CallbackArgumentsDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.service.ElectronicCallbackService;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderDetailRepository;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.ThirdReconciliationStatusEnum;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

/**
 * @describe: 电子签章回调
 * @author: xiaoyoujun
 * @date: 2022.11.30
 */
@Service("TpmMaterialPurchasingOrderElectronicCallbackService")
@Slf4j
public class TpmMaterialPurchasingOrderElectronicCallbackServiceImpl implements ElectronicCallbackService {


    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TpmMaterialPurchasingOrderDetailRepository detailRepository;


    @Override
    public void electronicCallback(CallbackArgumentsDto dto) {
        log.info("物料签收单，电子签章回调!!!!!! {}", JSONUtil.toJsonPrettyStr(dto));
        if (Objects.isNull(dto) || StringUtils.isEmpty(dto.getContractId()) || StringUtils.isEmpty(dto.getReconciliationResult())) {
            return;
        }
        TpmMaterialPurchasingOrderDetail detail = this.detailRepository.findByContractId(dto.getContractId());
        if (detail == null) {
            return;
        }
        String code = ThirdReconciliationStatusEnum.findByThirdCode(dto.getReconciliationResult());
        if (StrUtil.isNotEmpty(code)){
            // 签署完成
            if (ThirdReconciliationStatusEnum.COMPLETE.getThirdCode().equals(code)) {
                if (detail.getDeliveryQuantity().compareTo(detail.getPurchasingQuantity()) >= 0) {
                    detail.setReceivingStatus(TpmMaterialPurchasingOrderEnums.ReceiveStatus.DELIVERIED.getValue());
                }
                if (detail.getDeliveryQuantity().compareTo(detail.getPurchasingQuantity()) < 0) {
                    detail.setReceivingStatus(TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_DELIVERIED.getValue());
                }
                detail.setReceivingQuantity(detail.getAlreadyDeliveryQuantity());
                detail.setReceivingAmount(Optional.ofNullable(detail.getReceivingQuantity()).orElse(BigDecimal.ZERO)
                        .multiply(Optional.ofNullable(detail.getContractPrice()).orElse(BigDecimal.ZERO)));
                detail.setReceivingDate(DateUtil.formatDate());
            }
            //
            this.detailRepository.updateById(detail);
        }

    }
}
