package com.biz.crm.tpm.business.material.purchasing.order.local.service.internal;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderFile;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderPdfService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.utils.PdfUtil;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import lombok.extern.slf4j.Slf4j;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.*;
import java.math.BigDecimal;
import java.util.*;

/**
 * @Author: zhouyang
 * @Date: 2023/9/15
 */
@Service
@Slf4j
public class TpmMaterialPurchasingOrderPdfServiceImpl implements TpmMaterialPurchasingOrderPdfService {
    @Autowired
    private TpmMaterialPurchasingBaseElectronicSignature baseElectronicSignature;

    @Autowired
    private FileHandleService fileHandleService;

    @Override
    public TpmMaterialPurchasingOrderFile outConfirmPdf(TpmMaterialPurchasingOrderDetail detail){

        TpmMaterialPurchasingOrderFile detailFile = null;
        log.info("pdf创建开始");
        String path = baseElectronicSignature.fileRoot;
        //String path = "D:\\bozhi\\蒙牛一期\\需求\\1029707-物料采购单遗留事项开发";
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }

        File file = new File(path + "/" + detail.getDetailCode() + ".pdf");
        OutputStream outputStream = null;
        InputStream inputStream = null;
        Document document = null;
        try {
            // 流
            outputStream = new FileOutputStream(file);
            document = PdfUtil.createDocument();
            PdfWriter pdfWriter = PdfWriter.getInstance(document, outputStream);
            document.open();

            // 设置头样式
            Font font = PdfUtil.createFont(23, Font.NORMAL, BaseColor.BLACK);
            Font colFont = PdfUtil.createFont(7, Font.NORMAL, BaseColor.BLACK);
            Paragraph paragraph = PdfUtil.createParagraph("蒙牛促销物料到货签收单", font);
            paragraph.setAlignment(Element.ALIGN_CENTER);
            document.add(paragraph);

            // 普通字体
            font = PdfUtil.createFont(13, Font.NORMAL, BaseColor.BLACK);
            // 加粗字体
            Font fontBold = PdfUtil.createFont(13, Font.BOLD, BaseColor.BLACK);
            // 详情列表字体
            final Font detailFont = PdfUtil.createFont(11, Font.NORMAL, BaseColor.BLACK);

            // 基础信息
            PdfPTable table = new PdfPTable(1);
            float[] columnWidths = {1};
            table.setWidthPercentage(100);
            table.setPaddingTop(200f);
            table.setWidths(columnWidths);
            table.addCell(getPdfPCell1("一、基础信息", font, Element.ALIGN_LEFT));
            document.add(table);

            PdfPTable table2 = new PdfPTable(3);
            float[] columnWidths2 = {1, 1, 1};
            table2.setWidthPercentage(100);
            table2.setWidths(columnWidths2);
            table2.addCell(getPdfPCell1("单据编号",font,Element.ALIGN_CENTER));
            table2.addCell(getPdfPCell1("送货市场",font,Element.ALIGN_CENTER));
            table2.addCell(getPdfPCell1("物料使用品类",font,Element.ALIGN_CENTER));
            document.add(table2);

            PdfPTable table3 = new PdfPTable(3);
            table3.setWidthPercentage(100);
            table3.setWidths(columnWidths2);
            table3.addCell(getPdfPCell1(detail.getDetailCode(),detailFont,Element.ALIGN_CENTER));
            table3.addCell(getPdfPCell1(detail.getDeliveryDealer(),detailFont,Element.ALIGN_CENTER));
            table3.addCell(getPdfPCell1(detail.getMaterialCategory(),detailFont,Element.ALIGN_CENTER));
            document.add(table3);

            // 物料到货信息
            PdfPTable table4 = new PdfPTable(1);
            table4.setWidthPercentage(100);
            table4.setWidths(columnWidths);
            table4.addCell(getPdfPCell1("二、物料到货信息", font, Element.ALIGN_LEFT));
            document.add(table4);

            PdfPTable table5 = new PdfPTable(4);
            float[] columnWidths5 = {1, 1, 1, 1};
            table5.setWidthPercentage(100);
            table5.setWidths(columnWidths5);
            table5.addCell(getPdfPCell1("物料名称",font, Element.ALIGN_CENTER));
            table5.addCell(getPdfPCell1("装箱数",font, Element.ALIGN_CENTER));
            table5.addCell(getPdfPCell1("单位",font, Element.ALIGN_CENTER));
            table5.addCell(getPdfPCell1("数量",font, Element.ALIGN_CENTER));
            document.add(table5);

            PdfPTable table6 = new PdfPTable(4);
            float[] columnWidths6 = {1, 1, 1, 1};
            table6.setWidthPercentage(100);
            table6.setWidths(columnWidths6);
            table6.addCell(getPdfPCell1(detail.getMaterialName(),detailFont, Element.ALIGN_LEFT));
            table6.addCell(getPdfPCell1(Optional.ofNullable(detail.getPackingBoxNumber()).orElse(BigDecimal.ZERO).toString() + "个/箱",detailFont, Element.ALIGN_LEFT));
            table6.addCell(getPdfPCell1(detail.getUnit(),detailFont, Element.ALIGN_LEFT));
            table6.addCell(getPdfPCell1(Optional.ofNullable(detail.getDeliveryQuantity()).orElse(BigDecimal.ZERO).setScale(0,BigDecimal.ROUND_HALF_UP).toString(),detailFont, Element.ALIGN_LEFT));
            document.add(table6);

            // 物料基本工艺标准
            PdfPTable table7 = new PdfPTable(1);
            float[] columnWidths7 = {1};
            table7.setWidthPercentage(100);
            table7.setWidths(columnWidths7);
            table7.addCell(getPdfPCell1("三、物料基本工艺标准", font, Element.ALIGN_LEFT));
            document.add(table7);

            PdfPTable table8 = new PdfPTable(1);
            float[] columnWidths8 = {1};
            table8.setWidthPercentage(100);
            table8.setWidths(columnWidths8);
            table8.addCell(getPdfPCell(detail.getMaterialBaseStandard(),detailFont, Element.ALIGN_CENTER));
            document.add(table8);

            // 发货方信息
            PdfPTable table9 = new PdfPTable(1);
            float[] columnWidths9 = {1};
            table9.setWidthPercentage(100);
            table9.setWidths(columnWidths9);
            table9.addCell(getPdfPCell1("四、发货方信息", font, Element.ALIGN_LEFT));
            document.add(table9);

            PdfPTable table10 = new PdfPTable(4);
            float[] columnWidths10 = {1,2,1,2};
            table10.setWidthPercentage(100);
            table10.setWidths(columnWidths10);
            table10.addCell(getPdfPCell1("发货单位：",font,Element.ALIGN_LEFT));
            table10.addCell(getPdfPCell1(detail.getSupplierName(),detailFont,Element.ALIGN_LEFT));
            table10.addCell(getPdfPCell1("微信号：",font,Element.ALIGN_LEFT));
            table10.addCell(getPdfPCell1(detail.getWeixinNo(),detailFont,Element.ALIGN_LEFT));
            document.add(table10);

            PdfPTable table11 = new PdfPTable(4);
            float[] columnWidths11 = {1,1,1,1};
            table11.setWidthPercentage(100);
            table11.setWidths(columnWidths11);
            table11.addCell(getPdfPCell1("发货方联系人：",font,Element.ALIGN_LEFT));
            table11.addCell(getPdfPCell1(detail.getDeliveryContacts(),detailFont,Element.ALIGN_LEFT));
            table11.addCell(getPdfPCell1("联系电话：",font,Element.ALIGN_LEFT));
            table11.addCell(getPdfPCell1(detail.getDeliveryPhone(),detailFont,Element.ALIGN_LEFT));
            document.add(table11);

            // 收货方信息
            PdfPTable table12 = new PdfPTable(1);
            float[] columnWidths12 = {1};
            table12.setWidthPercentage(100);
            table12.setWidths(columnWidths12);
            table12.addCell(getPdfPCell1("五、收货方信息", font, Element.ALIGN_LEFT));
            document.add(table12);

            float[] columnWidths13 = {1,3};
            PdfPTable table13 = new PdfPTable(2);
            table13.setWidthPercentage(100);
            table13.setWidths(columnWidths13);
            table13.addCell(getPdfPCell1("客户名称：",font,Element.ALIGN_LEFT));
            table13.addCell(getPdfPCell1(detail.getCustomerName(),detailFont,Element.ALIGN_LEFT));
            document.add(table13);

            PdfPTable table14 = new PdfPTable(2);
            table14.setWidthPercentage(100);
            table14.setWidths(columnWidths13);
            table14.addCell(getPdfPCell1("收货地址：",font,Element.ALIGN_LEFT));
            table14.addCell(getPdfPCell1(detail.getRecipientAddress(),detailFont,Element.ALIGN_LEFT));
            document.add(table14);

            PdfPTable table15 = new PdfPTable(2);
            table15.setWidthPercentage(100);
            table15.setWidths(columnWidths13);
            table15.addCell(getPdfPCell1("收货联系人：",font,Element.ALIGN_LEFT));
            table15.addCell(getPdfPCell1(detail.getRecipientContacts(),detailFont,Element.ALIGN_LEFT));
            document.add(table15);

            PdfPTable table16 = new PdfPTable(2);
            table16.setWidthPercentage(100);
            table16.setWidths(columnWidths13);
            table16.addCell(getPdfPCell1("收货人电话：",font,Element.ALIGN_LEFT));
            table16.addCell(getPdfPCell1(detail.getRecipientPhone(),detailFont,Element.ALIGN_LEFT));
            document.add(table16);

            // 收货方签收确认
            PdfPTable table17 = new PdfPTable(1);
            float[] columnWidths17 = {1};
            table17.setWidthPercentage(100);
            table17.setWidths(columnWidths17);
            table17.addCell(getPdfPCell1("六、收货方签收确认", font, Element.ALIGN_LEFT));
            document.add(table17);

            PdfPTable table18 = new PdfPTable(1);
            float[] columnWidths18 = {1};
            table18.setWidthPercentage(100);
            table18.setWidths(columnWidths18);
            table18.addCell(getPdfPCell1("反馈渠道：若有异议请联系蒙牛公司反馈；", font, Element.ALIGN_LEFT));
            document.add(table18);

            PdfPTable table19 = new PdfPTable(1);
            float[] columnWidths19 = {1};
            table19.setWidthPercentage(100);
            table19.setWidths(columnWidths19);
            table19.addCell(getPdfPCell1("收货经办人确认：", font, Element.ALIGN_LEFT));
            document.add(table19);

            PdfPTable table20 = new PdfPTable(1);
            float[] columnWidths20 = {1};
            table20.setWidthPercentage(100);
            table20.setWidths(columnWidths20);
            table20.addCell(getPdfPCell1("联系电话：", font, Element.ALIGN_LEFT));
            document.add(table20);

            document.close();
            log.info("生成对账单：pdf写入结束");
        } catch (DocumentException | IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (Objects.nonNull(outputStream)) {
                    outputStream.close();
                }
                if (Objects.nonNull(inputStream)) {
                    inputStream.close();
                }
                if (Objects.nonNull(outputStream)) {
                    outputStream.close();
                }
//                if (Objects.nonNull(document)) {
//                    document.close();
//                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("pdf上传");
        // 上传到文件服务器
        byte[] fileByte = new byte[(int) file.length()];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int read = fileInputStream.read(fileByte);
            OrdinaryFileVo ordinaryFileVo = fileHandleService.fileUpload("default", TenantUtils.getTenantCode(), null,
                    detail.getDetailCode() + ".pdf", fileByte);
            Validate.notNull(ordinaryFileVo, "促销物料到货单文件生成失败!!! 编码：[%s]", detail.getId());
            detailFile = new TpmMaterialPurchasingOrderFile();
            detailFile.setFileType(TpmMaterialPurchasingOrderEnums.FileType.RECEIVE.getValue());
            detailFile.setFileCode(ordinaryFileVo.getId());
            detailFile.setOriginalFileName(ordinaryFileVo.getOriginalFileName());
            detailFile.setBusinessCode(detail.getDetailCode());
            detailFile.setTenantCode(TenantUtils.getTenantCode());
            //detailFileRepository.save(detailFile);
        } catch (IOException e) {
            log.info("生成物料：pdf上传异常：" + e.getMessage());
            throw new RuntimeException(e);
        } finally {
            if (Objects.nonNull(fileInputStream)) {
                try {
                    fileInputStream.close();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        // 删除文件
        boolean delete = file.delete();
        if (delete) {
            log.info("文件删除成功,{}", file.getName());
        } else {
            // todo
            log.error("文件删除失败,{}", file.getName());
        }
        return detailFile;

    }

    @Override
    public TpmMaterialPurchasingOrderFile orderConfirmPdf(TpmMaterialPurchasingOrderVo orderVo) {
        TpmMaterialPurchasingOrderFile detailFile = null;
        log.info("生成订单确认表：pdf写入开始");
        String path = baseElectronicSignature.fileRoot;
        //String path = "D:\\bozhi\\蒙牛一期\\需求\\1029707-物料采购单遗留事项开发";
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }

        File file = new File(path + "/" + orderVo.getCode() + ".pdf");
        OutputStream outputStream = null;
        InputStream inputStream = null;
        Document document = null;
        try {
            // 流
            outputStream = new FileOutputStream(file);
            document = PdfUtil.createDocument();
            PdfWriter pdfWriter = PdfWriter.getInstance(document, outputStream);
            document.open();

            // 设置头样式
            Font font = PdfUtil.createFont(23, Font.NORMAL, BaseColor.BLACK);
            Font colFont = PdfUtil.createFont(7, Font.NORMAL, BaseColor.BLACK);
            Paragraph paragraph = PdfUtil.createParagraph("订单确认表", font);
            paragraph.setAlignment(Element.ALIGN_CENTER);
            document.add(paragraph);

            // 普通字体
            font = PdfUtil.createFont(13, Font.NORMAL, BaseColor.BLACK);
            // 加粗字体
            Font fontBold = PdfUtil.createFont(13, Font.BOLD, BaseColor.BLACK);
            // 详情列表字体
            final Font detailFont = PdfUtil.createFont(21, Font.NORMAL, BaseColor.BLACK);

            PdfPTable table = new PdfPTable(4);

            float[] columnWidths = {1f, 2f, 1f, 2f};
            table.setWidthPercentage(100);
            table.setPaddingTop(205f);
            table.setWidths(columnWidths);
            table.addCell(getPdfPCell("供应商名称", font));
            table.addCell(getPdfPCell(orderVo.getSupplierName(), font, 3, 1));
            document.add(table);

            table = new PdfPTable(4);
            table.setWidthPercentage(100);
            table.setWidths(columnWidths);
            table.addCell(getPdfPCell("签发订单时间",font));
            table.addCell(getPdfPCell(DateUtil.format(orderVo.getCreateTime(),"yyyy-MM-dd HH:mm:ss"),font));
            table.addCell(getPdfPCell("联系电话",font));
            table.addCell(getPdfPCell(orderVo.getPhone(),font));
            document.add(table);

            // 物料到货信息
            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100);
            table.addCell(getPdfPCell("物料名称",font));
            table.addCell(getPdfPCell(orderVo.getMaterialName(), font, 3, 1));
            document.add(table);

            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100);
            table.addCell(getPdfPCell("基本物料工艺标准",font));
            table.addCell(getPdfPCell(orderVo.getMaterialBaseStandard(), font, 3, 1));
            document.add(table);

            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100);
            table.addCell(getPdfPCell("合同单价",font));
            table.addCell(getPdfPCell(Optional.ofNullable(orderVo.getContractPrice()).orElse(BigDecimal.ZERO).setScale(2,BigDecimal.ROUND_HALF_UP).toPlainString(), font, 3, 1));
            document.add(table);

            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100);
            table.addCell(getPdfPCell("订单数量",font));
            table.addCell(getPdfPCell(Optional.ofNullable(orderVo.getQuantity()).orElse(BigDecimal.ZERO).setScale(0,BigDecimal.ROUND_HALF_UP).toPlainString(), font, 3, 1));
            document.add(table);

            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100);
            table.addCell(getPdfPCell("金额",font));
            table.addCell(getPdfPCell(Optional.ofNullable(orderVo.getAmount()).orElse(BigDecimal.ZERO).setScale(2,BigDecimal.ROUND_HALF_UP).toPlainString(), font, 3, 1));
            document.add(table);

            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100);
            table.addCell(getPdfPCell("到货时间要求",font));
            table.addCell(getPdfPCell(orderVo.getDeliveryDateAsk(), font, 3, 1));
            document.add(table);

            table = new PdfPTable(8);
            float[] columnWidths2 = {1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f};
            table.setWidths(columnWidths2);
            table.setWidthPercentage(100);
            table.addCell(getPdfPCell("关键节点排期确认",font,0,1));
            table.addCell(getPdfPCell("节点",font));
            table.addCell(getPdfPCell("追样/签样",font));
            table.addCell(getPdfPCell("模具完成",font));
            table.addCell(getPdfPCell("大货样送达",font));
            table.addCell(getPdfPCell("日产能",font));
            table.addCell(getPdfPCell("开始发货",font));
            table.addCell(getPdfPCell("结案材料提交",font));
            document.add(table);

            table = new PdfPTable(8);
            table.setWidths(columnWidths2);
            table.setWidthPercentage(100);
            table.addCell(getPdfPCell("",font));
            table.addCell(getPdfPCell("时间",font));
            table.addCell(getPdfPCell(orderVo.getNodeReceiveDate(),font));
            table.addCell(getPdfPCell(orderVo.getNodeMoldDate(),font));
            table.addCell(getPdfPCell(orderVo.getNodeSendedDate(),font));
            table.addCell(getPdfPCell(orderVo.getNodeCapacityDate(),font));
            table.addCell(getPdfPCell(orderVo.getNodeStartDeliveryDate(),font));
            table.addCell(getPdfPCell(orderVo.getNodeEndCaseDate(),font));
            document.add(table);

            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100);
            table.addCell(getPdfPCell("备注",font));
            table.addCell(getPdfPCell(orderVo.getRemark(), font, 3, 1));
            document.add(table);

            table = new PdfPTable(2);
            int[] width3 = {80, 55};
            table.setWidths(width3);
            PdfPCell cell = getPdfPCell("发单人签字/日期：", font);
            PdfPCell cell1 = getPdfPCell("供应商接单人签字/日期：", font);
            cell.setBorder(0);
            cell1.setBorder(0);
            table.addCell(cell);
            table.addCell(cell1);
            document.add(table);

            table = new PdfPTable(2);
            table.setWidths(width3);
            PdfPCell cell2 = getPdfPCell("", font);
            PdfPCell cell3 = getPdfPCell("供应商签章（公章）", font);
            cell2.setBorder(0);
            cell3.setBorder(0);
            table.addCell(cell2);
            table.addCell(cell3);
            document.add(table);

            document.close();
            log.info("生成订单确认表：pdf写入结束");
        } catch (DocumentException | IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (Objects.nonNull(outputStream)) {
                    outputStream.close();
                }
                if (Objects.nonNull(inputStream)) {
                    inputStream.close();
                }
                if (Objects.nonNull(outputStream)) {
                    outputStream.close();
                }
//                if (Objects.nonNull(document)) {
//                    document.close();
//                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("pdf上传");
        // 上传到文件服务器
        byte[] fileByte = new byte[(int) file.length()];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int read = fileInputStream.read(fileByte);
            OrdinaryFileVo ordinaryFileVo = fileHandleService.fileUpload("default", TenantUtils.getTenantCode(), null,
                    orderVo.getCode() + ".pdf", fileByte);
            Validate.notNull(ordinaryFileVo, "促销物料到货单文件生成失败!!! 编码：[%s]", orderVo.getCode());
            detailFile = new TpmMaterialPurchasingOrderFile();
            detailFile.setFileType(TpmMaterialPurchasingOrderEnums.FileType.CONFIRM.getValue());
            detailFile.setFileCode(ordinaryFileVo.getId());
            detailFile.setOriginalFileName(ordinaryFileVo.getOriginalFileName());
            detailFile.setBusinessCode(orderVo.getCode());
            detailFile.setTenantCode(TenantUtils.getTenantCode());
            //detailFileRepository.save(detailFile);
        } catch (IOException e) {
            log.info("生成物料：pdf上传异常：" + e.getMessage());
            throw new RuntimeException(e);
        } finally {
            if (Objects.nonNull(fileInputStream)) {
                try {
                    fileInputStream.close();
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        // 删除文件
        boolean delete = file.delete();
        if (delete) {
            log.info("文件删除成功,{}", file.getName());
        } else {
            // todo
            log.error("文件删除失败,{}", file.getName());
        }
        return detailFile;

    }

    public PdfPCell getPdfPCell (String value,Font font,Integer alignElement) {
        return getPdfPCell(value,font,0,0,alignElement);
    }
    public PdfPCell getPdfPCell (String value,Font font) {
        return getPdfPCell(value,font,0,0,null);
    }
    public PdfPCell getPdfPCell (String value,Font font,int colspan,int rowspan) {
        return getPdfPCell(value,font,colspan,rowspan,null);
    }
    public PdfPCell getPdfPCell (String value,Font font,int colspan,int rowspan,Integer alignElement) {
        PdfPCell cell = new PdfPCell(new Phrase(value, font));
        cell.setUseBorderPadding(true);
        cell.setBorderColor(BaseColor.LIGHT_GRAY);
        cell.setFixedHeight(40);
        if (Objects.nonNull(alignElement)) {
            cell.setHorizontalAlignment(alignElement);
        } else {
            cell.setHorizontalAlignment(Element.ALIGN_CENTER);
        }
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setColspan(colspan);
        cell.setRowspan(rowspan);
        return cell;
    }

    public PdfPCell getPdfPCell1 (String value,Font font,Integer alignElement) {
        return getPdfPCell1(value,font,0,0,alignElement);
    }

    public PdfPCell getPdfPCell1 (String value,Font font,int colspan,int rowspan,Integer alignElement) {
        PdfPCell cell = new PdfPCell(new Phrase(value, font));
        cell.setUseBorderPadding(true);
        cell.setBorderColor(BaseColor.LIGHT_GRAY);
        cell.setFixedHeight(20);
        if (Objects.nonNull(alignElement)) {
            cell.setHorizontalAlignment(alignElement);
        } else {
            cell.setHorizontalAlignment(Element.ALIGN_CENTER);
        }
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setColspan(colspan);
        cell.setRowspan(rowspan);
        return cell;
    }
}
