package com.biz.crm.tpm.business.material.purchasing.order.local.service.notifier.log;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.log.TpmMaterialPurchasingOrderLogEventDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.event.log.TpmMaterialPurchasingOrderLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 业务单元日志通知
 *
 * @author: duyiran
 * @version: v1.0.0
 * @date: 2022.11.11 11:11
 */
@Component
public class TpmMaterialPurchasingOrderLogEventListenerImpl implements TpmMaterialPurchasingOrderLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;


    /**
     * 创建
     *
     * @param dto
     * @return void
     * @author: duyiran
     * @version: v1.0.0
     * @date: 2022.11.11 11:11
     */
    @Override
    public void onCreate(TpmMaterialPurchasingOrderLogEventDto dto) {
        // 新对象
        TpmMaterialPurchasingOrderDto newest = dto.getNewest();
        // 旧对象
        TpmMaterialPurchasingOrderDto original = dto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


    /**
     * 删除
     *
     * @param dto
     * @return void
     * @author: duyiran
     * @version: v1.0.0
     * @date: 2022.11.11 11:11
     */
    @Override
    public void onDelete(TpmMaterialPurchasingOrderLogEventDto dto) {
        // 新对象
        TpmMaterialPurchasingOrderDto newest = dto.getNewest();
        // 旧对象
        TpmMaterialPurchasingOrderDto original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


    /**
     * 更新
     *
     * @param dto
     * @return void
     * @author: duyiran
     * @version: v1.0.0
     * @date: 2022.11.11 11:11
     */
    @Override
    public void onUpdate(TpmMaterialPurchasingOrderLogEventDto dto) {
        // 新对象
        TpmMaterialPurchasingOrderDto newest = dto.getNewest();
        // 旧对象
        TpmMaterialPurchasingOrderDto original = dto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 禁用
     *
     * @param dto
     * @return void
     * @author: duyiran
     * @version: v1.0.0
     * @date: 2022.11.11 11:11
     */
    @Override
    public void onDisable(TpmMaterialPurchasingOrderLogEventDto dto) {
        //新对象
        TpmMaterialPurchasingOrderDto original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只需要传启禁用字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", EnableStatusEnum.DISABLE.getCode());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 启用
     *
     * @param dto
     * @return void
     * @author: duyiran
     * @version: v1.0.0
     * @date: 2022.11.11 11:11
     */
    @Override
    public void onEnable(TpmMaterialPurchasingOrderLogEventDto dto) {
        //新对象
        TpmMaterialPurchasingOrderDto original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只需要传启禁用字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", EnableStatusEnum.ENABLE.getCode());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
