/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.promotion.material.feign.feign.PromotionMaterialFeign;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanListDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_ACTIVITY_DETAIL_PLAN_PASS_MATERIAL_PURCHASING_ORDER", consumerGroup="TPM_ACTIVITY_DETAIL_PLAN_PASS_MATERIAL_PURCHASING_ORDER${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class ActivityDetailPlanPassMaterialPurchasingOrderConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanPassMaterialPurchasingOrderConsumer.class);
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired
    private PromotionMaterialFeign promotionMaterialFeign;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7269\u6599\u91c7\u8d2d\u5355 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            List detailPlanCodeList = JSON.parseArray((String)message.getMsgBody(), String.class);
            List dtoList = this.activityDetailPlanSdkService.buildActivityDetailPlanParams(detailPlanCodeList);
            ActivityDetailPlanListDto dto = new ActivityDetailPlanListDto();
            dto.setList(dtoList);
            List<TpmMaterialPurchasingOrderDto> tpmMaterialPurchasingOrderDtoList = this.buildData(dto);
            if (CollectionUtils.isEmpty(tpmMaterialPurchasingOrderDtoList)) {
                return "\u6d88\u8d39\u6210\u529f.";
            }
            this.tpmMaterialPurchasingOrderService.saveBatch(tpmMaterialPurchasingOrderDtoList);
        }
        catch (Exception e) {
            log.error(ActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    public Object handleMessageOnce(MqMessageVo message) {
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            List detailPlanCodeList = JSON.parseArray((String)message.getMsgBody(), String.class);
            List dtoList = this.activityDetailPlanSdkService.buildActivityDetailPlanParams(detailPlanCodeList);
            ActivityDetailPlanListDto dto = new ActivityDetailPlanListDto();
            dto.setList(dtoList);
            List<TpmMaterialPurchasingOrderDto> tpmMaterialPurchasingOrderDtoList = this.buildData(dto);
            if (CollectionUtils.isEmpty(tpmMaterialPurchasingOrderDtoList)) {
                return "\u6d88\u8d39\u6210\u529f.";
            }
            this.tpmMaterialPurchasingOrderService.saveBatch(tpmMaterialPurchasingOrderDtoList);
        }
        catch (Exception e) {
            log.error(ActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    private List<TpmMaterialPurchasingOrderDto> buildData(ActivityDetailPlanListDto listDto) {
        ArrayList tpmMaterialPurchasingOrderDtoList = Lists.newArrayList();
        if (Objects.isNull(listDto)) {
            return tpmMaterialPurchasingOrderDtoList;
        }
        List activityDetailPlanDtoList = listDto.getList();
        if (CollectionUtils.isEmpty((Collection)activityDetailPlanDtoList)) {
            return tpmMaterialPurchasingOrderDtoList;
        }
        String tenantCode = TenantUtils.getTenantCode();
        activityDetailPlanDtoList.forEach(activityDetailPlanDto -> {
            List itemList = activityDetailPlanDto.getItemList().stream().filter(e -> StringUtils.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)e.getIsClose())).filter(e -> StringUtils.isNotEmpty((CharSequence)e.getMaterialCode())).filter(e -> "Z0008".equals(e.getActivityTypeCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(itemList)) {
                return;
            }
            List materialCode = itemList.stream().map(ActivityDetailPlanItemBase::getMaterialCode).collect(Collectors.toList());
            Result promotionMaterialVOResultList = this.promotionMaterialFeign.findByCodeList(materialCode);
            ArrayList promotionMaterialVOList = Lists.newArrayList();
            if (promotionMaterialVOResultList.isSuccess()) {
                promotionMaterialVOList.addAll((Collection)promotionMaterialVOResultList.getResult());
            }
            Map promotionMaterialVOMap = promotionMaterialVOList.stream().collect(Collectors.toMap(PromotionMaterialVO::getMaterialCode, Function.identity()));
            Map<String, List<ActivityDetailPlanItemDto>> dimensionToPlanItemDtoListMap = itemList.stream().collect(Collectors.groupingBy(ActivityDetailPlanItemBase::getMaterialCode));
            dimensionToPlanItemDtoListMap.forEach((key, value) -> {
                ActivityDetailPlanItemDto temp = (ActivityDetailPlanItemDto)value.get(0);
                PromotionMaterialVO promotionMaterialVO = (PromotionMaterialVO)promotionMaterialVOMap.get(key);
                if (Objects.nonNull(promotionMaterialVO) && StringUtils.isNotEmpty((CharSequence)promotionMaterialVO.getSupplierCode())) {
                    List<String> supplierCodes = Arrays.asList(promotionMaterialVO.getSupplierCode().split(","));
                    List<String> supplierNames = Arrays.asList(promotionMaterialVO.getSupplierName().split(","));
                    for (String supplierCode : supplierCodes) {
                        TpmMaterialPurchasingOrderDto dto = new TpmMaterialPurchasingOrderDto();
                        dto.setTenantCode(tenantCode);
                        dto.setBusinessUnitCode(temp.getBusinessUnitCode());
                        dto.setBusinessFormatCode(temp.getBusinessFormatCode());
                        dto.setStatus(TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue());
                        dto.setChangeStatus(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.NOT_CHANGED.getValue());
                        dto.setSupplierCode(supplierCode);
                        int index = supplierCodes.indexOf(supplierCode);
                        dto.setSupplierName(index < supplierNames.size() ? supplierNames.get(index) : null);
                        dto.setMaterialCode(promotionMaterialVO.getMaterialCode());
                        dto.setMaterialName(promotionMaterialVO.getMaterialName());
                        dto.setCreateAccount(temp.getCreateAccount());
                        dto.setCreateName(temp.getCreateName());
                        dto.setModifyAccount(temp.getModifyAccount());
                        dto.setModifyName(temp.getModifyName());
                        tpmMaterialPurchasingOrderDtoList.add(dto);
                    }
                }
            });
        });
        return tpmMaterialPurchasingOrderDtoList;
    }
}

