/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_PASS_MATERIAL_PURCHASING_ORDER", consumerGroup="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_PASS_MATERIAL_PURCHASING_ORDER${rocketmq.environment}", consumeMode=ConsumeMode.ORDERLY, messageModel=MessageModel.CLUSTERING)
public class SubComActivityDetailPlanModifyPassMaterialPurchasingOrderConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanModifyPassMaterialPurchasingOrderConsumer.class);
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7269\u6599\u91c7\u8d2d\u5355 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            List businessNoList = JSON.parseArray((String)message.getMsgBody(), String.class);
            List voList = this.subComActivityDetailPlanVoService.findDetailPlanAndItemByPlanCode(businessNoList);
            List<TpmMaterialPurchasingOrderDetailDto> itemList = this.buildData(voList);
            if (CollectionUtils.isEmpty(itemList)) {
                return "\u6d88\u8d39\u6210\u529f.";
            }
            this.tpmMaterialPurchasingOrderService.updateBatch(itemList);
        }
        catch (Exception e) {
            log.error(SubComActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    private List<TpmMaterialPurchasingOrderDetailDto> buildData(List<SubComActivityDetailPlanVo> voList) {
        ArrayList detailList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(voList)) {
            return detailList;
        }
        String tenantCode = TenantUtils.getTenantCode();
        Map<String, List<SubComActivityDetailPlanVo>> formatToSubComActivityDetailPlanVoList = voList.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getBusinessFormatCode())).collect(Collectors.groupingBy(SubComActivityDetailPlanVo::getBusinessFormatCode));
        formatToSubComActivityDetailPlanVoList.forEach((format, subComActivityDetailPlanVoList) -> subComActivityDetailPlanVoList.forEach(activityDetailPlanVo -> {
            List<SubComActivityDetailPlanItemVo> itemList = activityDetailPlanVo.getItemList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSupplierCode())).filter(e -> Objects.nonNull(e.getQuantity())).filter(e -> Objects.nonNull(e.getMaterialPrice())).filter(e -> TpmMaterialPurchasingOrderEnums.IsTypeOfPurchaseNo.subsidiariesUnifiedPurchase.getValue().equals(e.getProcurementType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(itemList)) {
                return;
            }
            itemList.forEach(item -> {
                TpmMaterialPurchasingOrderDetailDto detailDto = new TpmMaterialPurchasingOrderDetailDto();
                detailDto.setTenantCode(tenantCode);
                detailDto.setActivityDetailItemCode(item.getConstituentDetailPlanItemCode());
                BigDecimal quantity = item.getQuantity();
                BigDecimal price = item.getMaterialPrice();
                BigDecimal amount = quantity.multiply(price);
                detailDto.setCustomerCode(item.getCustomerCode());
                detailDto.setCustomerName(item.getCustomerName());
                detailDto.setMaterialCode(item.getMaterialCode());
                detailDto.setMaterialName(item.getMaterialName());
                detailList.add(detailDto);
            });
        }));
        return detailList;
    }
}

