/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.consumer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_PASS_MATERIAL_PURCHASING_ORDER", consumerGroup="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_PASS_MATERIAL_PURCHASING_ORDER${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class SubComActivityDetailPlanPassMaterialPurchasingOrderConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanPassMaterialPurchasingOrderConsumer.class);
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7269\u6599\u91c7\u8d2d\u5355 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            List businessNoList = JSON.parseArray((String)message.getMsgBody(), String.class);
            List subDetailPlanList = this.subComActivityDetailPlanVoService.findDetailByPlanCodes(businessNoList);
            if (CollectionUtils.isEmpty((Collection)subDetailPlanList)) {
                log.error("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7269\u6599\u91c7\u8d2d\u5355,\u672a\u67e5\u8be2\u5230\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848!");
                return "\u672a\u67e5\u8be2\u5230\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\uff01";
            }
            List<TpmMaterialPurchasingOrderDto> tpmMaterialPurchasingOrderDtoList = this.buildData(subDetailPlanList);
            if (CollectionUtils.isEmpty(tpmMaterialPurchasingOrderDtoList)) {
                log.error("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7269\u6599\u91c7\u8d2d\u5355,\u6784\u5efa\u7269\u6599\u91c7\u8d2d\u5355\u4fe1\u606f\u5931\u8d25!");
                return "\u6d88\u8d39\u6210\u529f.";
            }
            log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7269\u6599\u91c7\u8d2d\u5355,\u5f00\u59cb\u4fdd\u5b58\u6d3b\u52a8\u7ec6\u6848\u7684\u7269\u6599\u91c7\u8d2d\u5355");
            this.tpmMaterialPurchasingOrderService.saveBatch(tpmMaterialPurchasingOrderDtoList);
        }
        catch (Exception e) {
            log.error(SubComActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    private List<TpmMaterialPurchasingOrderDto> buildData(List<SubComActivityDetailPlanVo> subDetailPlanList) {
        ArrayList tpmMaterialPurchasingOrderDtoList = Lists.newArrayList();
        if (Objects.isNull(subDetailPlanList)) {
            return tpmMaterialPurchasingOrderDtoList;
        }
        String tenantCode = TenantUtils.getTenantCode();
        subDetailPlanList.forEach(activityDetailPlanDto -> {
            List itemList = activityDetailPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSupplierCode())).filter(e -> Objects.nonNull(e.getQuantity())).filter(e -> Objects.nonNull(e.getMaterialPrice())).filter(e -> TpmMaterialPurchasingOrderEnums.IsTypeOfPurchaseNo.subsidiariesUnifiedPurchase.getValue().equals(e.getProcurementType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(itemList)) {
                log.error("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7269\u6599\u91c7\u8d2d\u5355,\u6784\u5efa\u7269\u6599\u91c7\u8d2d\u5355\u4fe1\u606f,\u5206\u5b50\u7ec6\u6848:{},\u6ca1\u6709\u660e\u7ec6\u9700\u751f\u6210\u7269\u6599\u91c7\u8d2d\u5355", (Object)activityDetailPlanDto.getConstituentDetailPlanCode());
                return;
            }
            Map<String, List<SubComActivityDetailPlanItemVo>> dimensionToPlanItemDtoListMap = itemList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemVo::getSupplierCode));
            dimensionToPlanItemDtoListMap.forEach((key, value) -> {
                SubComActivityDetailPlanItemVo temp = (SubComActivityDetailPlanItemVo)value.get(0);
                TpmMaterialPurchasingOrderDto dto = new TpmMaterialPurchasingOrderDto();
                dto.setTenantCode(tenantCode);
                dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                dto.setBusinessFormatCode(activityDetailPlanDto.getBusinessFormatCode());
                dto.setStatus(TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue());
                dto.setSupplierCode(temp.getSupplierCode());
                dto.setSupplierName(temp.getSupplierName());
                dto.setChangeStatus(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.NOT_CHANGED.getValue());
                ArrayList detailList = Lists.newArrayList();
                value.forEach(item -> {
                    TpmMaterialPurchasingOrderDetailDto detailDto = new TpmMaterialPurchasingOrderDetailDto();
                    detailDto.setTenantCode(tenantCode);
                    detailDto.setActivityDetailItemCode(item.getConstituentDetailPlanItemCode());
                    BigDecimal quantity = item.getQuantity();
                    BigDecimal price = item.getMaterialPrice();
                    BigDecimal amount = quantity.multiply(price);
                    detailDto.setCustomerCode(item.getCustomerCode());
                    detailDto.setCustomerName(item.getCustomerName());
                    detailDto.setMaterialCode(item.getMaterialCode());
                    detailDto.setMaterialName(item.getMaterialName());
                    detailList.add(detailDto);
                });
                dto.setDetailList((List)detailList);
                tpmMaterialPurchasingOrderDtoList.add(dto);
            });
        });
        return tpmMaterialPurchasingOrderDtoList;
    }
}

