/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.material.purchasing.order.local.consumer.ActivityDetailPlanPassMaterialPurchasingOrderConsumer;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderfindCustomerDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderAuditFileVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderFileVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderFindCustomerVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderVo;
import com.bizunited.nebula.common.util.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/tpmMaterialPurchasingOrder"})
@Api(tags={"TPM-\u7269\u6599\u91c7\u8d2d\u5355"})
public class TpmMaterialPurchasingOrderController {
    private static final Logger log = LoggerFactory.getLogger(TpmMaterialPurchasingOrderController.class);
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;
    @Autowired(required=false)
    private ActivityDetailPlanPassMaterialPurchasingOrderConsumer activityDetailPlanPassMaterialPurchasingOrderConsumer;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<TpmMaterialPurchasingOrderVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="TPM-\u7269\u6599\u91c7\u8d2d\u5355") TpmMaterialPurchasingOrderDto dto) {
        try {
            Page page = this.tpmMaterialPurchasingOrderService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6dfb\u52a0\u8be6\u60c5")
    @PostMapping(value={"createDetailList"})
    public Result<?> addDetailList(@RequestBody TpmMaterialPurchasingOrderDto dto) {
        try {
            this.tpmMaterialPurchasingOrderService.addDetailList(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u8be6\u60c5id\u67e5\u8be2")
    @GetMapping(value={"findDetailById"})
    public Result<TpmMaterialPurchasingOrderDetailVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            TpmMaterialPurchasingOrderDetailVo detailVo = this.tpmMaterialPurchasingOrderService.findDetailById(id);
            return Result.ok((Object)detailVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u7269\u6599\u7ec4\u7f16\u8f91")
    @PostMapping(value={"materialGroupUpdate"})
    public Result<?> materialGroupUpdate(@RequestBody TpmMaterialPurchasingOrderDto dto) {
        boolean lockSuccess = false;
        try {
            Validate.notEmpty((CharSequence)dto.getId(), (String)"\u4e3b\u952e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            lockSuccess = this.redisLockService.tryLock("template_check_repeat:lock:" + dto.getId(), TimeUnit.SECONDS, 30L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.tpmMaterialPurchasingOrderService.materialGroupUpdate(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("template_check_repeat:lock:" + dto.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4f9b\u5e94\u5546\u7f16\u8f91")
    @PostMapping(value={"supplierUpdate"})
    public Result<?> supplierUpdate(@RequestBody TpmMaterialPurchasingOrderDto dto) {
        try {
            Validate.notEmpty((CharSequence)dto.getId(), (String)"\u4e3b\u952e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            boolean lock = this.redisLockService.tryLock("template_check_repeat:lock:" + dto.getId(), TimeUnit.SECONDS, 30L);
            Validate.isTrue((boolean)lock, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u8be5\u6761\u6570\u636e,\u8bf7\u7a0d\u540e\u518d\u63d0\u4ea4", (Object[])new Object[0]);
            this.tpmMaterialPurchasingOrderService.supplierUpdate(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisLockService.unlock("template_check_repeat:lock:" + dto.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u51fa\u5e93\u5355\u786e\u8ba4")
    @PostMapping(value={"outConfirm"})
    public Result<?> outConfirm(@RequestBody TpmMaterialPurchasingOrderDto dto) {
        try {
            Validate.notEmpty((Collection)dto.getIds(), (String)"ids\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            boolean lock = this.redisLockService.batchLock("template_check_repeat:lock:", dto.getIds(), TimeUnit.SECONDS, 60);
            Validate.isTrue((boolean)lock, (String)"\u9632\u91cd\u590d\u63d0\u4ea4,\u8bf7\u7a0d\u540e\u518d\u63d0\u4ea4", (Object[])new Object[0]);
            this.tpmMaterialPurchasingOrderService.outConfirm(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.info("\u786e\u8ba4\u62a5\u9519,{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (CollectionUtils.isNotEmpty((Collection)dto.getIds())) {
                this.redisLockService.batchUnLock("template_check_repeat:lock:", dto.getIds());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u51fa\u5e93\u5355\u64a4\u56de")
    @PostMapping(value={"outCancel"})
    public Result<?> outCancel(@RequestBody TpmMaterialPurchasingOrderDto dto) {
        try {
            Validate.notEmpty((Collection)dto.getIds(), (String)"ids\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            boolean lock = this.redisLockService.batchLock("template_check_repeat:lock:", dto.getIds(), TimeUnit.SECONDS, 60);
            Validate.isTrue((boolean)lock, (String)"\u9632\u91cd\u590d\u63d0\u4ea4,\u8bf7\u7a0d\u540e\u518d\u63d0\u4ea4", (Object[])new Object[0]);
            this.tpmMaterialPurchasingOrderService.outCancel(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (CollectionUtils.isNotEmpty((Collection)dto.getIds())) {
                this.redisLockService.batchUnLock("template_check_repeat:lock:", dto.getIds());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u51fa\u5e93\u5355\u50ac\u7b7e")
    @PostMapping(value={"outExpediting"})
    public Result<?> outExpediting(@RequestBody TpmMaterialPurchasingOrderDto dto) {
        try {
            Validate.notEmpty((Collection)dto.getIds(), (String)"ids\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            boolean lock = this.redisLockService.batchLock("template_check_repeat:lock:", dto.getIds(), TimeUnit.SECONDS, 60);
            Validate.isTrue((boolean)lock, (String)"\u9632\u91cd\u590d\u63d0\u4ea4,\u8bf7\u7a0d\u540e\u518d\u63d0\u4ea4", (Object[])new Object[0]);
            this.tpmMaterialPurchasingOrderService.outExpediting(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (CollectionUtils.isNotEmpty((Collection)dto.getIds())) {
                this.redisLockService.batchUnLock("template_check_repeat:lock:", dto.getIds());
            }
        }
    }

    @ApiOperation(value="\u6279\u91cf\u4e0b\u8f7d\u8ba2\u5355\u786e\u8ba4\u8868")
    @GetMapping(value={"downloadOrderConfirmBatch"})
    public Result<List<TpmMaterialPurchasingOrderFileVo>> downloadOrderConfirmBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            List result = this.tpmMaterialPurchasingOrderService.downloadOrderConfirmBatch(ids);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u4e0b\u8f7d\u7b7e\u6536\u5355")
    @GetMapping(value={"downloadOutConfirmBatch"})
    public Result<List<TpmMaterialPurchasingOrderFileVo>> downloadOutConfirmBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            List result = this.tpmMaterialPurchasingOrderService.downloadOutConfirmBatch(ids);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0a\u4f20\u7b7e\u6536\u5355")
    @PostMapping(value={"uploadOutConfirm"})
    public Result<?> uploadOutConfirm(@RequestBody TpmMaterialPurchasingOrderDetailDto dto) {
        try {
            this.tpmMaterialPurchasingOrderService.uploadOutConfirm(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.info("\u4e0a\u4f20\u7b7e\u6536\u5355\u62a5\u9519\u4e86:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6279\u91cf\u63d0\u4ea4\u5ba1\u6279")
    @PostMapping(value={"submitProcess"})
    public Result<?> submitProcess(@RequestBody TpmMaterialPurchasingOrderDto dto) {
        try {
            Validate.notEmpty((Collection)dto.getDetailList(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            boolean lock = this.redisLockService.batchLock("template_check_repeat:lock:", dto.getDetailList().stream().map(UuidDto::getId).collect(Collectors.toList()), TimeUnit.SECONDS, 60);
            Validate.isTrue((boolean)lock, (String)"\u9632\u91cd\u590d\u63d0\u4ea4,\u8bf7\u7a0d\u540e\u518d\u63d0\u4ea4", (Object[])new Object[0]);
            this.tpmMaterialPurchasingOrderService.submitProcess(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (CollectionUtils.isNotEmpty((Collection)dto.getDetailList())) {
                this.redisLockService.batchUnLock("template_check_repeat:lock:", dto.getDetailList().stream().map(UuidDto::getId).collect(Collectors.toList()));
            }
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<TpmMaterialPurchasingOrderVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            TpmMaterialPurchasingOrderVo tpmMaterialPurchasingOrder = this.tpmMaterialPurchasingOrderService.findById(id);
            return Result.ok((Object)tpmMaterialPurchasingOrder);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0a\u4f20\u6838\u9500\u8d44\u6599")
    @PatchMapping(value={"updateAuditFile"})
    public Result<?> updateAuditFile(@ApiParam(name="dto", value="dto") @RequestBody TpmMaterialPurchasingOrderDto dto) {
        try {
            this.tpmMaterialPurchasingOrderService.updateAuditFile(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7269\u6599\u8d39\u7ed3\u6848\u67e5\u8be2\u6838\u9500\u8d44\u6599")
    @GetMapping(value={"auditFindMaterialAuditInfo"})
    public Result<Page<TpmMaterialPurchasingOrderAuditFileVo>> auditFindMaterialAuditInfo(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="TPM-\u7269\u6599\u91c7\u8d2d\u5355") TpmMaterialPurchasingOrderDto dto) {
        try {
            log.info("\u7269\u6599\u8d39\u7ed3\u6848\u67e5\u8be2\u6838\u9500\u8d44\u6599,materialPurchasingOrders\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)dto.getMaterialPurchasingOrders()));
            return Result.ok((Object)this.tpmMaterialPurchasingOrderService.auditFindMaterialAuditInfo(pageable, dto.getMaterialPurchasingOrders()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7269\u6599\u91c7\u8d2d\u5355")
    @PostMapping(value={"batchDeleteMaterialPurchaseOrder"})
    public Result<?> batchDeleteMaterialPurchaseOrder(@RequestBody List<String> ids) {
        try {
            this.tpmMaterialPurchasingOrderService.batchDeleteMaterialPurchaseOrder(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6838\u9500\u8d44\u6599")
    @GetMapping(value={"getAuditFile"})
    public Result<TpmMaterialPurchasingOrderVo> getAuditFile(@ApiParam(name="id", value="id") @RequestParam(value="id") String id) {
        try {
            TpmMaterialPurchasingOrderVo orderVo = this.tpmMaterialPurchasingOrderService.getAuditFile(id);
            return Result.ok((Object)orderVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u91c7\u8d2d\u5355\u786e\u8ba4")
    @PatchMapping(value={"confirm"})
    public Result<?> confirm(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestBody TpmMaterialPurchasingOrderDto dto) {
        boolean lockSuccess = false;
        try {
            Validate.notEmpty((Collection)dto.getIds(), (String)"ids\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            lockSuccess = this.redisLockService.batchLock("template_check_repeat:lock:", dto.getIds(), TimeUnit.SECONDS, 60);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.tpmMaterialPurchasingOrderService.confirm(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess && CollectionUtils.isNotEmpty((Collection)dto.getIds())) {
                this.redisLockService.batchUnLock("template_check_repeat:lock:", dto.getIds());
            }
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e\uff08\u6838\u9500\u7528\uff09")
    @GetMapping(value={"findDetailListByCodeForAuditPage"})
    public Result<Page<TpmMaterialPurchasingOrderDetailVo>> findDetailListByCodeForAuditPage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="TPM-\u7269\u6599\u91c7\u8d2d\u5355") TpmMaterialPurchasingOrderDto dto) {
        try {
            Page page = this.tpmMaterialPurchasingOrderService.findDetailListByCodeForAuditPage(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5f53\u524d\u91c7\u8d2d\u5355\u6240\u6709\u5ba2\u6237")
    @GetMapping(value={"findCustomerById"})
    public Result<Page<TpmMaterialPurchasingOrderFindCustomerVo>> findCustomerById(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="TPM-\u7269\u6599\u91c7\u8d2d\u5355-\u67e5\u8be2\u5ba2\u6237") TpmMaterialPurchasingOrderfindCustomerDto dto) {
        try {
            Page page = this.tpmMaterialPurchasingOrderService.findCustomerByCode(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5f53\u524d\u91c7\u8d2d\u5355\u6240\u6709\u53ef\u53d1\u8d27\u660e\u7ec6")
    @GetMapping(value={"findOutStorageAbleDetailById"})
    public Result<Page<TpmMaterialPurchasingOrderDetailVo>> findOutStorageAbleDetailById(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="TPM-\u7269\u6599\u91c7\u8d2d\u5355-\u67e5\u8be2\u5ba2\u6237") TpmMaterialPurchasingOrderDto dto) {
        try {
            Page page = this.tpmMaterialPurchasingOrderService.findOutStorageAbleDetailById(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u4fee\u6539\u5ba2\u6237\u5730\u5740")
    @PatchMapping(value={"editCustomerById"})
    public Result<?> editCustomerById(@ApiParam(name="dto", value="TPM-\u7269\u6599\u91c7\u8d2d\u5355-\u67e5\u8be2\u5ba2\u6237") @RequestBody TpmMaterialPurchasingOrderfindCustomerDto dto) {
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock("template_check_repeat:lock:" + dto.getId(), TimeUnit.SECONDS, 30L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.tpmMaterialPurchasingOrderService.editCustomerAddressById(dto);
            Result result = Result.ok((String)"\u4fee\u6539\u5ba2\u6237\u5730\u5740\u6210\u529f\uff01");
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("template_check_repeat:lock:" + dto.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5b8c\u6210\u51fa\u5e93")
    @PatchMapping(value={"finishOutStorage"})
    public Result<?> finishOutStorage(@ApiParam(name="dto", value="TPM-\u7269\u6599\u91c7\u8d2d\u5355") @RequestBody TpmMaterialPurchasingOrderDto dto) {
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock("template_check_repeat:lock:" + dto.getId(), TimeUnit.SECONDS, 30L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.tpmMaterialPurchasingOrderService.finishOutStorage(dto);
            Result result = Result.ok((String)"\u5b8c\u6210\u51fa\u5e93\u6210\u529f\uff01");
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("template_check_repeat:lock:" + dto.getId());
            }
        }
    }

    @ApiOperation(value="\u7ed3\u6848\u6838\u9500\u4fee\u6539 \u5df2\u7ed3\u6848\u91d1\u989d\u3001\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u72b6\u6001")
    @PatchMapping(value={"audit"})
    public Result<?> audit(@ApiParam(name="dto", value="\u7269\u6599\u91c7\u8d2d\u5355") @RequestBody List<TpmMaterialPurchasingOrderDto> dto) {
        try {
            this.tpmMaterialPurchasingOrderService.audit(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

