/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.export;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderMaterialGroupExportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmMaterialPurchasingOrderMaterialGroupExportsProcess
implements ExportProcess<TpmMaterialPurchasingOrderMaterialGroupExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmMaterialPurchasingOrderMaterialGroupExportsProcess.class);
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderDetailService detailService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = this.getCacheKey(params);
        Integer total = this.detailService.getTotal(cacheKey);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58Key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (String)cacheKey;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = this.getCacheKey(params);
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        Page detailVoList = this.detailService.findCachePageList((Pageable)pageable, new TpmMaterialPurchasingOrderDetailDto(), cacheKey);
        if (CollectionUtils.isEmpty((Collection)detailVoList.getRecords())) {
            return new JSONArray();
        }
        Collection exportsVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailVoList.getRecords(), TpmMaterialPurchasingOrderDetailVo.class, TpmMaterialPurchasingOrderMaterialGroupExportsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.adjustData(exportsVos);
        return JSON.parseArray((String)JSON.toJSONString((Object)exportsVos));
    }

    public String getBusinessCode() {
        return "TPM_MATERIAL_PURCHASING_ORDER_MATERIAL_GROOUP_EXPORT";
    }

    public String getBusinessName() {
        return "\u7269\u6599\u91c7\u8d2d\u5355\u7269\u6599\u7ec4\u7f16\u8f91\u5bfc\u51fa";
    }

    private void adjustData(Collection<TpmMaterialPurchasingOrderMaterialGroupExportsVo> data) {
        for (TpmMaterialPurchasingOrderMaterialGroupExportsVo vo : data) {
            if (Objects.nonNull(vo.getDeliveryDate())) {
                vo.setDeliveryDateStr(vo.getDeliveryDate());
            }
            if (Objects.nonNull(vo.getRecipientDate())) {
                vo.setRecipientDateStr(vo.getRecipientDate());
            }
            if (Objects.nonNull(vo.getCreateTime())) {
                vo.setCreateTimeStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd_HH_mm_ss, (Date)vo.getCreateTime()));
            }
            if (!Objects.nonNull(vo.getModifyTime())) continue;
            vo.setModifyTimeStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd_HH_mm_ss, (Date)vo.getModifyTime()));
        }
    }

    public Class<TpmMaterialPurchasingOrderMaterialGroupExportsVo> findCrmExcelVoClass() {
        return TpmMaterialPurchasingOrderMaterialGroupExportsVo.class;
    }
}

