/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderDetailRepository;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmMaterialPurchasingOrderDetailCacheHelper
extends MnPageCacheHelper<TpmMaterialPurchasingOrderDetailVo, TpmMaterialPurchasingOrderDetailDto> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderDetailRepository tpmMaterialPurchasingOrderDetailRepository;

    public String getCacheKeyPrefix() {
        return "tpm_material_purchasing_order:audit_invoice:";
    }

    public Class<TpmMaterialPurchasingOrderDetailDto> getDtoClass() {
        return TpmMaterialPurchasingOrderDetailDto.class;
    }

    public Class<TpmMaterialPurchasingOrderDetailVo> getVoClass() {
        return TpmMaterialPurchasingOrderDetailVo.class;
    }

    public List<TpmMaterialPurchasingOrderDetailDto> findDtoListFromRepository(TpmMaterialPurchasingOrderDetailDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getCode())) {
            return Lists.newArrayList();
        }
        List<Object> dtoList = this.tpmMaterialPurchasingOrderDetailRepository.findByCode(dto.getCode());
        if (StringUtils.isNotEmpty((CharSequence)dto.getProcessNo())) {
            dtoList = dtoList.stream().filter(o -> dto.getProcessNo().equals(o.getProcessNo())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(dtoList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, TpmMaterialPurchasingOrderDetailVo.class, TpmMaterialPurchasingOrderDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<TpmMaterialPurchasingOrderDetailDto> newItem(String cacheKey, List<TpmMaterialPurchasingOrderDetailDto> itemList) {
        itemList.forEach(e -> {
            e.setId(UUID.randomUUID().toString().replace("-", ""));
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        return itemList;
    }

    public List<TpmMaterialPurchasingOrderDetailDto> copyItem(String cacheKey, List<TpmMaterialPurchasingOrderDetailDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, TpmMaterialPurchasingOrderDetailDto.class, TpmMaterialPurchasingOrderDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (TpmMaterialPurchasingOrderDetailDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return newItemList;
    }

    public Object getDtoKey(TpmMaterialPurchasingOrderDetailDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(TpmMaterialPurchasingOrderDetailDto dto) {
        return dto.getChecked();
    }

    public void filterSaveItem(String cacheKey, List<Object> idList, List<TpmMaterialPurchasingOrderDetailDto> itemList, List<TpmMaterialPurchasingOrderDetailDto> updateList) {
        itemList.removeIf(item -> idList.contains(this.getDtoKey((TpmMaterialPurchasingOrderDetailDto)item)));
    }
}

