/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderMaterialGroupImportVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmMaterialPurchasingOrderMaterialGroupImportsProcess
implements ImportProcess<TpmMaterialPurchasingOrderMaterialGroupImportVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmMaterialPurchasingOrderMaterialGroupImportsProcess.class);
    @Autowired
    private TpmMaterialPurchasingOrderDetailService detailService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmMaterialPurchasingOrderMaterialGroupImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Collection<TpmMaterialPurchasingOrderMaterialGroupImportVo> importVos;
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtil.isNotEmpty(data) && CollectionUtil.isNotEmpty(importVos = data.values())) {
            ArrayList importVoList = Lists.newArrayList(importVos);
            for (int i = 0; i < importVoList.size(); ++i) {
                TpmMaterialPurchasingOrderMaterialGroupImportVo importVo = (TpmMaterialPurchasingOrderMaterialGroupImportVo)importVoList.get(i);
                Integer index = i + 1;
                Validate.notEmpty((CharSequence)importVo.getId(), (String)("\u7b2c" + index + "\u884c,\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
            }
            List detailVoList = this.detailService.findCacheList((String)cacheKey);
            Map importVoMap = importVos.stream().collect(Collectors.toMap(TpmMaterialPurchasingOrderMaterialGroupImportVo::getId, Function.identity()));
            detailVoList.forEach(detailVo -> {
                if (importVoMap.containsKey(detailVo.getId())) {
                    TpmMaterialPurchasingOrderMaterialGroupImportVo importVo = (TpmMaterialPurchasingOrderMaterialGroupImportVo)importVoMap.get(detailVo.getId());
                    detailVo.setRecipientAddress(importVo.getRecipientAddress());
                    detailVo.setRecipientPhone(importVo.getRecipientPhone());
                    detailVo.setRecipientContacts(importVo.getRecipientContacts());
                }
            });
            this.detailService.addItemCache((String)cacheKey, detailVoList);
        }
        return null;
    }

    public Class<TpmMaterialPurchasingOrderMaterialGroupImportVo> findCrmExcelVoClass() {
        return TpmMaterialPurchasingOrderMaterialGroupImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_MATERIAL_PURCHASING_ORDER_MATERIAL_GROUP_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u7269\u6599\u91c7\u8d2d\u5355\u660e\u7ec6\u5bfc\u5165-\u7269\u6599\u7ec4";
    }

    public String getBusinessCode() {
        return "TPM_MATERIAL_PURCHASING_ORDER_MATERIAL_GROUP_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u7269\u6599\u91c7\u8d2d\u5355\u660e\u7ec6\u7269\u6599\u7ec4\u5bfc\u5165";
    }
}

