/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderSupplierImportVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpmMaterialPurchasingOrderSupplierImportsProcess
implements ImportProcess<TpmMaterialPurchasingOrderSupplierImportVo> {
    private static final Logger log = LoggerFactory.getLogger(TpmMaterialPurchasingOrderSupplierImportsProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TpmMaterialPurchasingOrderDetailService detailService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmMaterialPurchasingOrderSupplierImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Collection<TpmMaterialPurchasingOrderSupplierImportVo> importVos;
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (CollectionUtil.isNotEmpty(data) && CollectionUtil.isNotEmpty(importVos = data.values())) {
            ArrayList importVoList = Lists.newArrayList(importVos);
            for (int i = 0; i < importVoList.size(); ++i) {
                TpmMaterialPurchasingOrderSupplierImportVo importVo = (TpmMaterialPurchasingOrderSupplierImportVo)importVoList.get(i);
                Integer index = i + 1;
                Validate.notEmpty((CharSequence)importVo.getId(), (String)("\u7b2c" + index + "\u884c,\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
                if (StringUtils.isNotEmpty((CharSequence)importVo.getDeliveryDateStr())) {
                    try {
                        df.parse(importVo.getDeliveryDateStr());
                    }
                    catch (ParseException e) {
                        Validate.notEmpty((CharSequence)importVo.getDeliveryDateStr(), (String)("\u7b2c" + index + "\u884c,\u53d1\u8d27\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e"), (Object[])new Object[0]);
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)importVo.getRecipientDateStr())) continue;
                try {
                    df.parse(importVo.getRecipientDateStr());
                    continue;
                }
                catch (ParseException e) {
                    Validate.notEmpty((CharSequence)importVo.getRecipientDateStr(), (String)("\u7b2c" + index + "\u884c,\u6536\u8d27\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e"), (Object[])new Object[0]);
                }
            }
            List detailVoList = this.detailService.findCacheList((String)cacheKey);
            Map importVoMap = importVos.stream().collect(Collectors.toMap(TpmMaterialPurchasingOrderSupplierImportVo::getId, Function.identity()));
            detailVoList.forEach(detailVo -> {
                if (importVoMap.containsKey(detailVo.getId())) {
                    TpmMaterialPurchasingOrderSupplierImportVo importVo = (TpmMaterialPurchasingOrderSupplierImportVo)importVoMap.get(detailVo.getId());
                    detailVo.setDeliveryDate(importVo.getDeliveryDateStr());
                    detailVo.setRecipientDate(importVo.getRecipientDateStr());
                    detailVo.setMaterialCategory(importVo.getMaterialCategory());
                    detailVo.setPackingBoxNumber(importVo.getPackingBoxNumber());
                    detailVo.setUnit(importVo.getUnit());
                    detailVo.setMaterialBaseStandard(importVo.getMaterialBaseStandard());
                    detailVo.setWeixinNo(importVo.getWeixinNo());
                    detailVo.setDeliveryContacts(importVo.getDeliveryContacts());
                    detailVo.setDeliveryPhone(importVo.getDeliveryPhone());
                    if (!ProcessStatusEnum.COMMIT.getDictCode().equals(detailVo.getDetailStatus()) && !ProcessStatusEnum.PASS.getDictCode().equals(detailVo.getDetailStatus())) {
                        detailVo.setDeliveryQuantity(importVo.getDeliveryQuantity());
                        Validate.isTrue((importVo.getDeliveryQuantity().compareTo(Optional.ofNullable(detailVo.getPurchasingQuantity()).orElse(BigDecimal.ZERO)) <= 0 ? 1 : 0) != 0, (String)"\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u91c7\u8d2d\u6570\u91cf", (Object[])new Object[0]);
                        if (TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_DELIVERIED.getValue().equals(detailVo.getReceivingStatus())) {
                            Validate.isTrue((importVo.getDeliveryQuantity().compareTo(Optional.ofNullable(detailVo.getReceivingQuantity()).orElse(BigDecimal.ZERO)) >= 0 ? 1 : 0) != 0, (String)"\u53d1\u8d27\u6570\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e\u7b7e\u6536\u6570\u91cf", (Object[])new Object[0]);
                        }
                    }
                }
            });
            this.detailService.addItemCache((String)cacheKey, detailVoList);
        }
        return null;
    }

    public Class<TpmMaterialPurchasingOrderSupplierImportVo> findCrmExcelVoClass() {
        return TpmMaterialPurchasingOrderSupplierImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_MATERIAL_PURCHASING_ORDER_SUPPLIER_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u7269\u6599\u91c7\u8d2d\u5355\u660e\u7ec6\u5bfc\u5165-\u4f9b\u5e94\u5546";
    }

    public String getBusinessCode() {
        return "TPM_MATERIAL_PURCHASING_ORDER_SUPPLIER_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u7269\u6599\u91c7\u8d2d\u5355\u660e\u7ec6\u4f9b\u5e94\u5546\u5bfc\u5165";
    }
}

