/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MaterialPurchasingCloseEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MaterialPurchasingEventDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.event.materialPurchaingOrder.MaterialPurchasingOrderEventListener;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrder;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderDetailRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderRepository;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class MaterialPurchasingOrderEventListenerImpl
implements MaterialPurchasingOrderEventListener {
    private static final Logger log = LoggerFactory.getLogger(MaterialPurchasingOrderEventListenerImpl.class);
    @Autowired
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired
    private TpmMaterialPurchasingOrderRepository tpmMaterialPurchasingOrderRepository;
    @Autowired
    private TpmMaterialPurchasingOrderDetailRepository tpmMaterialPurchasingOrderDetailRepository;
    @Autowired
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;

    @Transactional(rollbackFor={Exception.class})
    public void onActivityDetailPlanModify(MaterialPurchasingEventDto dto) {
        log.info("\u7ec6\u6848\u660e\u7ec6\u8fdb\u884c\u8c03\u6574\u4fee\u6539\u7269\u6599\u91c7\u8d2d\u5355\u8c03\u6574\u72b6\u6001\u4fee\u6539,{}", (Object)JSON.toJSONString((Object)dto));
        if (Objects.isNull(dto) || StringUtils.isEmpty((CharSequence)dto.getActivityDetailPlanCode()) || StringUtils.isEmpty((CharSequence)dto.getProcessStatus())) {
            return;
        }
        String detailPlanCode = dto.getActivityDetailPlanCode();
        String modifyBusinessCode = dto.getModifyBusinessCode();
        List originalVoList = this.activityDetailPlanItemSdkService.findListByDetailPlanCode(detailPlanCode);
        log.info("\u7ec6\u6848\u660e\u7ec6\u8fdb\u884c\u8c03\u6574\u4fee\u6539\u7269\u6599\u91c7\u8d2d\u5355\u8c03\u6574\u72b6\u6001\u4fee\u6539,originalVoList:{}", (Object)JSON.toJSONString((Object)originalVoList));
        List modifyDtoList = this.activityDetailPlanItemSdkService.findDtoListByModifyCode(modifyBusinessCode);
        log.info("\u7ec6\u6848\u660e\u7ec6\u8fdb\u884c\u8c03\u6574\u4fee\u6539\u7269\u6599\u91c7\u8d2d\u5355\u8c03\u6574\u72b6\u6001\u4fee\u6539,modifyDtoList:{}", (Object)JSON.toJSONString((Object)modifyDtoList));
        Map modifyDtoMap = modifyDtoList.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity()));
        HashMap<String, BigDecimal> activityDetailPlanItemMap = new HashMap<String, BigDecimal>();
        for (ActivityDetailPlanItemVo itemVo : originalVoList) {
            ActivityDetailPlanItemModifyDto modifyDto = (ActivityDetailPlanItemModifyDto)modifyDtoMap.get(itemVo.getDetailPlanItemCode());
            if (modifyDto == null || Optional.ofNullable(itemVo.getMaterialQuantity()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(modifyDto.getMaterialQuantity()).orElse(BigDecimal.ZERO)) == 0) continue;
            activityDetailPlanItemMap.put(itemVo.getDetailPlanItemCode(), modifyDto.getMaterialQuantity());
        }
        Set detailPlanItemCodes = activityDetailPlanItemMap.keySet();
        log.info("\u7ec6\u6848\u660e\u7ec6\u8fdb\u884c\u8c03\u6574\u4fee\u6539\u7269\u6599\u91c7\u8d2d\u5355\u8c03\u6574\u72b6\u6001\u4fee\u6539,key:{},value:{}", (Object)JSON.toJSONString(activityDetailPlanItemMap.keySet()), (Object)JSON.toJSONString(activityDetailPlanItemMap.values()));
        if (CollectionUtils.isNotEmpty(detailPlanItemCodes)) {
            List<TpmMaterialPurchasingOrderDetail> detailList = this.tpmMaterialPurchasingOrderDetailRepository.findByActivityDetailItemCodes(new ArrayList<String>(detailPlanItemCodes));
            log.info("\u7ec6\u6848\u660e\u7ec6\u8fdb\u884c\u8c03\u6574\u4fee\u6539\u7269\u6599\u91c7\u8d2d\u5355\u8c03\u6574\u72b6\u6001\u4fee\u6539-\u91c7\u8d2d\u5355\u660e\u7ec6\u6570\u636e,{}", (Object)JSON.toJSONString(detailList));
            if (CollectionUtils.isNotEmpty(detailList)) {
                List<String> purchasingOrderCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).collect(Collectors.toList());
                List<TpmMaterialPurchasingOrder> purchasingOrderList = this.tpmMaterialPurchasingOrderRepository.findByCodeList(purchasingOrderCodes);
                log.info("\u7ec6\u6848\u660e\u7ec6\u8fdb\u884c\u8c03\u6574\u4fee\u6539\u7269\u6599\u91c7\u8d2d\u5355\u8c03\u6574\u72b6\u6001\u4fee\u6539-\u91c7\u8d2d\u5355\u62ac\u5934\u6570\u636e,{}", (Object)JSON.toJSONString(purchasingOrderList));
                detailList = this.filterProcessStatus(purchasingOrderList, detailList);
                log.info("\u7ec6\u6848\u660e\u7ec6\u8fdb\u884c\u8c03\u6574\u4fee\u6539\u7269\u6599\u91c7\u8d2d\u5355\u8c03\u6574\u72b6\u6001\u4fee\u6539-\u91c7\u8d2d\u5355\u660e\u7ec6\u8fc7\u6ee4\u540e\u7684\u6570\u636e,{}", (Object)JSON.toJSONString(detailList));
                if (CollectionUtils.isNotEmpty(detailList)) {
                    StringBuffer changeStatus = new StringBuffer();
                    if (dto.getProcessStatus().equals(ProcessStatusEnum.COMMIT.getKey())) {
                        changeStatus.append(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGEING.getValue());
                    } else if (dto.getProcessStatus().equals(ProcessStatusEnum.PASS.getKey())) {
                        changeStatus.append(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGED.getValue());
                    } else {
                        changeStatus.append(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.NOT_CHANGED.getValue());
                    }
                    detailList.forEach(detail -> {
                        detail.setActivityDetailChangeStatus(changeStatus.toString());
                        if (dto.getProcessStatus().equals(ProcessStatusEnum.PASS.getKey())) {
                            detail.setPurchasingQuantity((BigDecimal)activityDetailPlanItemMap.get(detail.getActivityDetailItemCode()));
                        }
                    });
                    log.info("\u7ec6\u6848\u660e\u7ec6\u8fdb\u884c\u8c03\u6574\u4fee\u6539\u7269\u6599\u91c7\u8d2d\u5355\u8c03\u6574\u72b6\u6001\u4fee\u6539-\u91c7\u8d2d\u5355\u660e\u7ec6\u8981\u4fee\u6539\u7684\u6570\u636e,{}", (Object)JSON.toJSONString(detailList));
                    this.tpmMaterialPurchasingOrderDetailRepository.updateBatchById(detailList);
                    List materialPurchasingCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).distinct().collect(Collectors.toList());
                    this.tpmMaterialPurchasingOrderService.handleChangeStatus(materialPurchasingCodes);
                }
            }
        }
    }

    private List<TpmMaterialPurchasingOrderDetail> filterProcessStatus(List<TpmMaterialPurchasingOrder> purchasingOrderList, List<TpmMaterialPurchasingOrderDetail> detailList) {
        if (CollectionUtils.isEmpty(detailList)) {
            return Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(purchasingOrderList)) {
            return Lists.newArrayList();
        }
        List purchasingOrderCodeList = purchasingOrderList.stream().filter(o -> TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue().equals(o.getStatus()) || TpmMaterialPurchasingOrderEnums.OrderStatus.BACK_40.getValue().equals(o.getStatus())).map(TpmMaterialPurchasingOrder::getCode).collect(Collectors.toList());
        return detailList.stream().filter(item -> purchasingOrderCodeList.contains(item.getCode())).collect(Collectors.toList());
    }

    public void onActivityDetailPlanItemClose(MaterialPurchasingCloseEventDto dto) {
        List newDetailList;
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getActivityDetailPlanItemCodes())) {
            return;
        }
        List<TpmMaterialPurchasingOrderDetail> detailList = this.tpmMaterialPurchasingOrderDetailRepository.findByActivityDetailItemCodes(dto.getActivityDetailPlanItemCodes());
        if (CollectionUtils.isNotEmpty(detailList) && CollectionUtils.isNotEmpty(newDetailList = detailList.stream().filter(a -> StringUtils.equals((CharSequence)a.getReceivingStatus(), (CharSequence)TpmMaterialPurchasingOrderEnums.ReceiveStatus.WAIT_RECEIVE.getValue())).filter(a -> StringUtils.equals((CharSequence)a.getReceivingStatus(), (CharSequence)TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_RECEIVE.getValue())).filter(a -> StringUtils.equals((CharSequence)a.getReceivingStatus(), (CharSequence)TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_DELIVERIED.getValue())).collect(Collectors.toList()))) {
            List<String> materialPurchasingCodes = newDetailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).distinct().collect(Collectors.toList());
            List<TpmMaterialPurchasingOrder> entityList = this.tpmMaterialPurchasingOrderRepository.findByCodeList(materialPurchasingCodes);
            if (CollectionUtils.isNotEmpty(entityList)) {
                entityList.forEach(entity -> entity.setChangeStatus(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGED.getValue()));
            }
            List ids = newDetailList.stream().map(UuidEntity::getId).distinct().collect(Collectors.toList());
            this.tpmMaterialPurchasingOrderRepository.updateBatchById(entityList);
            this.tpmMaterialPurchasingOrderDetailRepository.removeByIds(ids);
        }
    }
}

