/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.listener;

import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TpmMaterialPurchasingProcessCompleteListener
implements ProcessCompleteListener {
    @Autowired
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;
    @Autowired
    private TpmMaterialPurchasingOrderDetailService tpmMaterialPurchasingOrderDetailService;

    public String getBusinessCode() {
        return "tpm_material_purchasing_order";
    }

    @Transactional
    public void onProcessComplete(ProcessStatusDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getBusinessNoList())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.tpmMaterialPurchasingOrderService.processBack(dto.getBusinessNoList(), TpmMaterialPurchasingOrderEnums.OrderStatus.CONFIRM_30.getValue());
            this.tpmMaterialPurchasingOrderDetailService.updateReceivingStatusByCodes(dto.getBusinessNoList(), TpmMaterialPurchasingOrderEnums.ReceiveStatus.WAIT_RECEIVE.getValue());
            this.tpmMaterialPurchasingOrderDetailService.generateSignInPdfByCodes(dto.getBusinessNoList());
        }
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus)) {
            this.tpmMaterialPurchasingOrderService.processBack(dto.getBusinessNoList(), TpmMaterialPurchasingOrderEnums.OrderStatus.WAIT_EDIT.getValue());
        }
        if (ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.tpmMaterialPurchasingOrderService.processBack(dto.getBusinessNoList(), TpmMaterialPurchasingOrderEnums.OrderStatus.BACK_40.getValue());
        }
    }
}

