/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderAuditFile;
import com.biz.crm.tpm.business.material.purchasing.order.local.mapper.TpmMaterialPurchasingOrderAuditFileMapper;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderAuditFileVo;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmMaterialPurchasingOrderAuditFileRepository
extends ServiceImpl<TpmMaterialPurchasingOrderAuditFileMapper, TpmMaterialPurchasingOrderAuditFile> {
    public List<TpmMaterialPurchasingOrderAuditFile> findByBusinessCode(String businessCode) {
        if (StringUtils.isEmpty((CharSequence)businessCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrderAuditFile::getBusinessCode, (Object)businessCode)).orderByAsc(TpmMaterialPurchasingOrderAuditFile::getTypeCode)).list();
    }

    public List<TpmMaterialPurchasingOrderAuditFile> findByBusinessCodes(List<String> businessCodes) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmMaterialPurchasingOrderAuditFile::getBusinessCode, businessCodes)).list();
    }

    public void deleteByBusinessCode(String businessCode) {
        if (StringUtils.isEmpty((CharSequence)businessCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TpmMaterialPurchasingOrderAuditFile::getBusinessCode, (Object)businessCode)).remove();
    }

    public void deleteByBusinessCodes(List<String> businessCodes) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(TpmMaterialPurchasingOrderAuditFile::getBusinessCode, businessCodes)).remove();
    }

    public Page<TpmMaterialPurchasingOrderAuditFileVo> auditFindMaterialAuditInfo(Pageable pageable, List<String> materialPurchasingOrders) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (CollectionUtils.isEmpty(materialPurchasingOrders)) {
            return page;
        }
        return ((TpmMaterialPurchasingOrderAuditFileMapper)this.getBaseMapper()).auditFindMaterialAuditInfo((Page<TpmMaterialPurchasingOrderAuditFileVo>)page, materialPurchasingOrders);
    }
}

