/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.mapper.TpmMaterialPurchasingOrderDetailMapper;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderfindCustomerDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderFindCustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmMaterialPurchasingOrderDetailRepository
extends ServiceImpl<TpmMaterialPurchasingOrderDetailMapper, TpmMaterialPurchasingOrderDetail> {
    private static final Logger log = LoggerFactory.getLogger(TpmMaterialPurchasingOrderDetailRepository.class);
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderDetailMapper tpmMaterialPurchasingOrderDetailMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<TpmMaterialPurchasingOrderDetailVo> findByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Lists.newArrayList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        List details = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrderDetail::getCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
        Collection conditions = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)details, TpmMaterialPurchasingOrderDetail.class, TpmMaterialPurchasingOrderDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)conditions);
    }

    public List<TpmMaterialPurchasingOrderDetail> findByCodeList(List<String> codList) {
        if (CollectionUtils.isEmpty(codList)) {
            return Lists.newArrayList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmMaterialPurchasingOrderDetail::getCode, codList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).orderByDesc(TpmMaterialPurchasingOrderDetail::getSubCode)).list();
    }

    public List<TpmMaterialPurchasingOrderDetail> findByCodeAndCustomerCodeList(TpmMaterialPurchasingOrderfindCustomerDto dto) {
        String code = dto.getCode();
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrderDetail::getCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(TpmMaterialPurchasingOrderDetail::getCustomerCode, (Collection)dto.getCustomerCodeList())).list();
    }

    public List<TpmMaterialPurchasingOrderDetail> findByDetailPlanItemCodeList(List<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)) {
            return Lists.newArrayList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(TpmMaterialPurchasingOrderDetail::getActivityDetailItemCode, detailPlanItemCodeList)).list();
    }

    public void removeByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TpmMaterialPurchasingOrderDetail::getCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public Page<TpmMaterialPurchasingOrderFindCustomerVo> findCustomerByCode(Pageable pageable, TpmMaterialPurchasingOrderfindCustomerDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmMaterialPurchasingOrderDetailMapper.findCustomerByCode((Page<TpmMaterialPurchasingOrderFindCustomerVo>)page, dto);
    }

    public Page<TpmMaterialPurchasingOrderDetailVo> findOutStorageAbleDetailById(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmMaterialPurchasingOrderDetailMapper.findOutStorageAbleDetailById((Page<TpmMaterialPurchasingOrderDetailVo>)page, dto);
    }

    public TpmMaterialPurchasingOrderDetail getBySubCode(String subCode) {
        return (TpmMaterialPurchasingOrderDetail)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrderDetail::getSubCode, (Object)subCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<TpmMaterialPurchasingOrderDetail> getByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrderDetail::getCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void deleteByCode(String code) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TpmMaterialPurchasingOrderDetail::getCode, (Object)code)).remove();
    }

    public List<TpmMaterialPurchasingOrderDetail> findByActivityDetailItemCodes(List<String> activityDetailPlanItemCodes) {
        if (CollectionUtils.isEmpty(activityDetailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmMaterialPurchasingOrderDetail::getActivityDetailItemCode, activityDetailPlanItemCodes)).list();
    }

    public TpmMaterialPurchasingOrderDetail findByDetailCode(String detailCode) {
        if (StringUtils.isEmpty((CharSequence)detailCode)) {
            return null;
        }
        return (TpmMaterialPurchasingOrderDetail)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrderDetail::getDetailCode, (Object)detailCode)).one());
    }

    public TpmMaterialPurchasingOrderDetail findByContractId(String contractId) {
        if (StringUtils.isEmpty((CharSequence)contractId)) {
            return null;
        }
        return (TpmMaterialPurchasingOrderDetail)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrderDetail::getContractId, (Object)contractId)).one());
    }

    public Page<TpmMaterialPurchasingOrderDetailVo> findDetailListByCodeForAuditPage(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmMaterialPurchasingOrderDetailMapper.findDetailListByCodeForAuditPage((Page<TpmMaterialPurchasingOrderDetailVo>)page, dto);
    }

    public Integer getToTalByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return 0;
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrderDetail::getCode, (Object)code)).count();
    }

    public List<TpmMaterialPurchasingOrderDetail> findDetailListByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrderDetail::getCode, (Object)code)).list();
    }

    public void updateReceivingStatusByCodes(List<String> codes, String status) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TpmMaterialPurchasingOrderDetail::getCode, codes)).set(TpmMaterialPurchasingOrderDetail::getReceivingStatus, (Object)status)).update();
    }

    public Page<TpmMaterialPurchasingOrderDetailVo> findSupplierApprovalList(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmMaterialPurchasingOrderDetailMapper.findSupplierApprovalList((Page<TpmMaterialPurchasingOrderDetailVo>)page, dto);
    }

    public void updateDeliveryDate(String date, String code) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TpmMaterialPurchasingOrderDetail::getCode, (Object)code)).set(TpmMaterialPurchasingOrderDetail::getDeliveryDate, (Object)date)).update();
    }

    public void updateRecipientDate(String date, String code) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(TpmMaterialPurchasingOrderDetail::getCode, (Object)code)).set(TpmMaterialPurchasingOrderDetail::getRecipientDate, (Object)date)).update();
    }

    public void updateReceivingFieldNull(TpmMaterialPurchasingOrderDetail detail) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidEntity::getId, (Object)detail.getId())).set(TpmMaterialPurchasingOrderDetail::getReceivingStatus, (Object)detail.getReceivingStatus())).set(TpmMaterialPurchasingOrderDetail::getReceivingAmount, null)).set(TpmMaterialPurchasingOrderDetail::getReceivingQuantity, null)).update();
    }

    public Page<TpmMaterialPurchasingOrderDetailVo> auditFindMaterialPurchasingOrderDetailByCondition(Pageable pageable, TpmMaterialPurchasingOrderDetailDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((TpmMaterialPurchasingOrderDetailMapper)this.getBaseMapper()).auditFindMaterialPurchasingOrderDetailByCondition((Page<TpmMaterialPurchasingOrderDetailVo>)page, dto);
    }

    public void supplierProcessBack(List<TpmMaterialPurchasingOrderDetailVo> detailVos, String processStatus) {
        if (CollectionUtils.isEmpty(detailVos)) {
            return;
        }
        ArrayList<TpmMaterialPurchasingOrderDetail> detailList = new ArrayList<TpmMaterialPurchasingOrderDetail>();
        for (TpmMaterialPurchasingOrderDetailVo detailVo : detailVos) {
            TpmMaterialPurchasingOrderDetail orderDetail = new TpmMaterialPurchasingOrderDetail();
            orderDetail.setId(detailVo.getId());
            orderDetail.setDetailStatus(processStatus);
            detailList.add(orderDetail);
        }
        log.info("\u7269\u6599\u91c7\u8d2d\u5355\u63d0\u4ea4\u5ba1\u6279\u5ba1\u6279\u901a\u8fc7,detailList:{}", (Object)JsonUtils.obj2JsonString(detailList));
        this.updateBatchById(detailList);
    }

    public List<TpmMaterialPurchasingOrderDetailVo> findByDetailCodes(List<String> detailCodeList) {
        if (CollectionUtils.isEmpty(detailCodeList)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmMaterialPurchasingOrderDetail::getDetailCode, detailCodeList)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Collection tpmMaterialPurchasingOrderDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmMaterialPurchasingOrderDetail.class, TpmMaterialPurchasingOrderDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)tpmMaterialPurchasingOrderDetailVos;
    }

    public void deleteByCodes(List<String> codes) {
        if (CollectionUtils.isNotEmpty(codes)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(TpmMaterialPurchasingOrderDetail::getCode, codes)).update();
        }
    }

    public Page<TpmMaterialPurchasingOrderDetailVo> findSupplierSubmitApprovalDetailInfo(Pageable pageable, TpmMaterialPurchasingOrderDetailDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmMaterialPurchasingOrderDetailMapper.findSupplierSubmitApprovalDetailInfo((Page<TpmMaterialPurchasingOrderDetailVo>)page, dto);
    }
}

