/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderFile;
import com.biz.crm.tpm.business.material.purchasing.order.local.mapper.TpmMaterialPurchasingOrderFileMapper;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TpmMaterialPurchasingOrderFileRepository
extends ServiceImpl<TpmMaterialPurchasingOrderFileMapper, TpmMaterialPurchasingOrderFile> {
    public List<TpmMaterialPurchasingOrderFile> findByBusinessCode(String businessCode) {
        if (StringUtils.isEmpty((CharSequence)businessCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrderFile::getBusinessCode, (Object)businessCode)).list();
    }

    public List<TpmMaterialPurchasingOrderFile> findByBusinessCodes(List<String> businessCodes) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmMaterialPurchasingOrderFile::getBusinessCode, businessCodes)).list();
    }

    public void deleteByBusinessCode(String businessCode) {
        if (StringUtils.isEmpty((CharSequence)businessCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TpmMaterialPurchasingOrderFile::getBusinessCode, (Object)businessCode)).remove();
    }

    public void deleteByBusinessCodes(List<String> businessCodes) {
        if (CollectionUtils.isEmpty(businessCodes)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(TpmMaterialPurchasingOrderFile::getBusinessCode, businessCodes)).remove();
    }

    public List<TpmMaterialPurchasingOrderFile> findSignByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Lists.newArrayList();
        }
        return ((TpmMaterialPurchasingOrderFileMapper)this.baseMapper).findSignByCode(code);
    }
}

