/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrder;
import com.biz.crm.tpm.business.material.purchasing.order.local.mapper.TpmMaterialPurchasingOrderMapper;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class TpmMaterialPurchasingOrderRepository
extends ServiceImpl<TpmMaterialPurchasingOrderMapper, TpmMaterialPurchasingOrder> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderMapper tpmMaterialPurchasingOrderMapper;

    public Page<TpmMaterialPurchasingOrderVo> findByConditions(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmMaterialPurchasingOrderMapper.findByConditions((Page<TpmMaterialPurchasingOrderVo>)page, dto);
    }

    public Page<TpmMaterialPurchasingOrderVo> findByConditionsForAuditPage(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmMaterialPurchasingOrderMapper.findByConditionsForAuditPage((Page<TpmMaterialPurchasingOrderVo>)page, dto);
    }

    public List<TpmMaterialPurchasingOrderVo> findByConditionsForJava(TpmMaterialPurchasingOrderDto dto) {
        return this.tpmMaterialPurchasingOrderMapper.findByConditionsForJava(dto);
    }

    public TpmMaterialPurchasingOrder getByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        return (TpmMaterialPurchasingOrder)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TpmMaterialPurchasingOrder::getCode, (Object)code)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<TpmMaterialPurchasingOrder> findByCodeList(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(TpmMaterialPurchasingOrder::getCode, codeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<TpmMaterialPurchasingOrderVo> findRepeatByDimension(TpmMaterialPurchasingOrderDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        return this.tpmMaterialPurchasingOrderMapper.findRepeatByDimension(dto);
    }

    public void updateStatusByCodes(List<String> codes, String status) {
        if (CollectionUtils.isEmpty(codes) || StringUtils.isEmpty((CharSequence)status)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(TpmMaterialPurchasingOrder::getCode, codes)).set(TpmMaterialPurchasingOrder::getStatus, (Object)status)).update();
    }

    public void supplierProcessBack(List<String> businessNoList, String processStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TpmMaterialPurchasingOrder::getCode, businessNoList)).set(TpmMaterialPurchasingOrder::getProcessStatus, (Object)processStatus)).update();
    }

    public void updateChangeStatusByCodes(List<TpmMaterialPurchasingOrder> mainOrderList) {
        if (CollectionUtils.isNotEmpty(mainOrderList)) {
            mainOrderList.forEach(item -> ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(TpmMaterialPurchasingOrder::getChangeStatus, (Object)item.getChangeStatus())).eq(TpmMaterialPurchasingOrder::getCode, (Object)item.getCode())).update());
        }
    }

    public List<TpmMaterialPurchasingOrderVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Collection tpmMaterialPurchasingOrderVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmMaterialPurchasingOrder.class, TpmMaterialPurchasingOrderVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)tpmMaterialPurchasingOrderVos;
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).in(UuidEntity::getId, ids)).update();
        }
    }
}

