/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderFile;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderDetailRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderFileRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderPdfService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tpmMaterialPurchasingOrderDetailService")
public class TpmMaterialPurchasingOrderDetailServiceImpl
extends MnPageCacheServiceImpl<TpmMaterialPurchasingOrderDetailVo, TpmMaterialPurchasingOrderDetailDto>
implements TpmMaterialPurchasingOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(TpmMaterialPurchasingOrderDetailServiceImpl.class);
    @Autowired
    private TpmMaterialPurchasingOrderDetailRepository detailRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderPdfService pdfService;
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderFileRepository fileRepository;

    @Override
    public Integer getTotal(String cacheKey) {
        String key = this.helper.getRedisCacheIdKey(cacheKey);
        return this.redisService.lSize(key).intValue();
    }

    @Override
    public List<TpmMaterialPurchasingOrderDetailVo> findDetailListByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Lists.newArrayList();
        }
        List<TpmMaterialPurchasingOrderDetail> detailList = this.detailRepository.findDetailListByCode(code);
        if (CollectionUtils.isEmpty(detailList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailList, TpmMaterialPurchasingOrderDetail.class, TpmMaterialPurchasingOrderDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public List<TpmMaterialPurchasingOrderDetailVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List list = this.detailRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, TpmMaterialPurchasingOrderDetail.class, TpmMaterialPurchasingOrderDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public void updateBatch(List<TpmMaterialPurchasingOrderDetailVo> detailVoList) {
        if (CollectionUtils.isEmpty(detailVoList)) {
            return;
        }
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailVoList, TpmMaterialPurchasingOrderDetailVo.class, TpmMaterialPurchasingOrderDetail.class, HashSet.class, ArrayList.class, new String[0]);
        this.detailRepository.updateBatchById(list);
    }

    @Override
    @Transactional
    public void updateReceivingStatusByCodes(List<String> businessNoList, String status) {
        if (CollectionUtils.isEmpty(businessNoList)) {
            return;
        }
        this.detailRepository.updateReceivingStatusByCodes(businessNoList, status);
    }

    @Override
    public Page<TpmMaterialPurchasingOrderDetailVo> findSupplierApprovalList(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        return this.detailRepository.findSupplierApprovalList(pageable, dto);
    }

    @Override
    public Page<TpmMaterialPurchasingOrderDetailVo> auditFindMaterialPurchasingOrderDetailByCondition(Pageable pageable, TpmMaterialPurchasingOrderDetailDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmMaterialPurchasingOrderDetailDto();
        }
        return this.detailRepository.auditFindMaterialPurchasingOrderDetailByCondition(pageable, dto);
    }

    @Override
    public Page<TpmMaterialPurchasingOrderDetailVo> findSupplierSubmitApprovalDetailInfo(Pageable pageable, TpmMaterialPurchasingOrderDetailDto dto) {
        return this.detailRepository.findSupplierSubmitApprovalDetailInfo(pageable, dto);
    }

    @Override
    public void generateSignInPdfByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        List<TpmMaterialPurchasingOrderDetail> detailList = this.detailRepository.findByCodeList(codes);
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        log.info("\u91c7\u8d2d\u5355\u786e\u8ba4\u901a\u8fc7\uff1adetailList\uff1a{}", (Object)JsonUtils.obj2JsonString(detailList));
        ArrayList fileList = Lists.newArrayList();
        detailList.forEach(detail -> {
            TpmMaterialPurchasingOrderFile file = this.pdfService.outConfirmPdf((TpmMaterialPurchasingOrderDetail)((Object)detail));
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                log.info("\u7761\u4e0d\u7740\u4e86,{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            fileList.add(file);
        });
        log.info("\u91c7\u8d2d\u5355\u786e\u8ba4\u901a\u8fc7\uff1adetailList\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)fileList));
        List<String> detailCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getDetailCode).collect(Collectors.toList());
        this.fileRepository.deleteByBusinessCodes(detailCodes);
        this.fileRepository.saveBatch(fileList);
    }
}

