/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.service.internal;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.dto.CallbackArgumentsDto;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.service.ElectronicCallbackService;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderDetailRepository;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.ThirdReconciliationStatusEnum;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="TpmMaterialPurchasingOrderElectronicCallbackService")
public class TpmMaterialPurchasingOrderElectronicCallbackServiceImpl
implements ElectronicCallbackService {
    private static final Logger log = LoggerFactory.getLogger(TpmMaterialPurchasingOrderElectronicCallbackServiceImpl.class);
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TpmMaterialPurchasingOrderDetailRepository detailRepository;

    public void electronicCallback(CallbackArgumentsDto dto) {
        log.info("\u7269\u6599\u7b7e\u6536\u5355\uff0c\u7535\u5b50\u7b7e\u7ae0\u56de\u8c03!!!!!! {}", (Object)JSONUtil.toJsonPrettyStr((Object)dto));
        if (Objects.isNull(dto) || StringUtils.isEmpty((CharSequence)dto.getContractId()) || StringUtils.isEmpty((CharSequence)dto.getReconciliationResult())) {
            return;
        }
        TpmMaterialPurchasingOrderDetail detail = this.detailRepository.findByContractId(dto.getContractId());
        if (detail == null) {
            return;
        }
        String code = ThirdReconciliationStatusEnum.findByThirdCode((String)dto.getReconciliationResult());
        if (StrUtil.isNotEmpty((CharSequence)code)) {
            if (ThirdReconciliationStatusEnum.COMPLETE.getThirdCode().equals(code)) {
                if (detail.getDeliveryQuantity().compareTo(detail.getPurchasingQuantity()) >= 0) {
                    detail.setReceivingStatus(TpmMaterialPurchasingOrderEnums.ReceiveStatus.DELIVERIED.getValue());
                }
                if (detail.getDeliveryQuantity().compareTo(detail.getPurchasingQuantity()) < 0) {
                    detail.setReceivingStatus(TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_DELIVERIED.getValue());
                }
                detail.setReceivingQuantity(detail.getAlreadyDeliveryQuantity());
                detail.setReceivingAmount(Optional.ofNullable(detail.getReceivingQuantity()).orElse(BigDecimal.ZERO).multiply(Optional.ofNullable(detail.getContractPrice()).orElse(BigDecimal.ZERO)));
                detail.setReceivingDate(DateUtil.formatDate());
            }
            this.detailRepository.updateById((Object)detail);
        }
    }
}

