/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.service.internal;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderFile;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderPdfService;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.internal.TpmMaterialPurchasingBaseElectronicSignature;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.utils.PdfUtil;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TpmMaterialPurchasingOrderPdfServiceImpl
implements TpmMaterialPurchasingOrderPdfService {
    private static final Logger log = LoggerFactory.getLogger(TpmMaterialPurchasingOrderPdfServiceImpl.class);
    @Autowired
    private TpmMaterialPurchasingBaseElectronicSignature baseElectronicSignature;
    @Autowired
    private FileHandleService fileHandleService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TpmMaterialPurchasingOrderFile outConfirmPdf(TpmMaterialPurchasingOrderDetail detail) {
        TpmMaterialPurchasingOrderFile detailFile = null;
        log.info("pdf\u521b\u5efa\u5f00\u59cb");
        String path = this.baseElectronicSignature.fileRoot;
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(path + "/" + detail.getDetailCode() + ".pdf");
        FileOutputStream outputStream = null;
        InputStream inputStream = null;
        Document document = null;
        try {
            outputStream = new FileOutputStream(file);
            document = PdfUtil.createDocument();
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            Font font = PdfUtil.createFont((int)23, (int)0, (BaseColor)BaseColor.BLACK);
            Font colFont = PdfUtil.createFont((int)7, (int)0, (BaseColor)BaseColor.BLACK);
            Paragraph paragraph = PdfUtil.createParagraph((String)"\u8499\u725b\u4fc3\u9500\u7269\u6599\u5230\u8d27\u7b7e\u6536\u5355", (Font)font);
            paragraph.setAlignment(1);
            document.add((Element)paragraph);
            font = PdfUtil.createFont((int)13, (int)0, (BaseColor)BaseColor.BLACK);
            Font fontBold = PdfUtil.createFont((int)13, (int)1, (BaseColor)BaseColor.BLACK);
            Font detailFont = PdfUtil.createFont((int)11, (int)0, (BaseColor)BaseColor.BLACK);
            PdfPTable table = new PdfPTable(1);
            float[] columnWidths = new float[]{1.0f};
            table.setWidthPercentage(100.0f);
            table.setPaddingTop(200.0f);
            table.setWidths(columnWidths);
            table.addCell(this.getPdfPCell1("\u4e00\u3001\u57fa\u7840\u4fe1\u606f", font, 0));
            document.add((Element)table);
            PdfPTable table2 = new PdfPTable(3);
            float[] columnWidths2 = new float[]{1.0f, 1.0f, 1.0f};
            table2.setWidthPercentage(100.0f);
            table2.setWidths(columnWidths2);
            table2.addCell(this.getPdfPCell1("\u5355\u636e\u7f16\u53f7", font, 1));
            table2.addCell(this.getPdfPCell1("\u9001\u8d27\u5e02\u573a", font, 1));
            table2.addCell(this.getPdfPCell1("\u7269\u6599\u4f7f\u7528\u54c1\u7c7b", font, 1));
            document.add((Element)table2);
            PdfPTable table3 = new PdfPTable(3);
            table3.setWidthPercentage(100.0f);
            table3.setWidths(columnWidths2);
            table3.addCell(this.getPdfPCell1(detail.getDetailCode(), detailFont, 1));
            table3.addCell(this.getPdfPCell1(detail.getDeliveryDealer(), detailFont, 1));
            table3.addCell(this.getPdfPCell1(detail.getMaterialCategory(), detailFont, 1));
            document.add((Element)table3);
            PdfPTable table4 = new PdfPTable(1);
            table4.setWidthPercentage(100.0f);
            table4.setWidths(columnWidths);
            table4.addCell(this.getPdfPCell1("\u4e8c\u3001\u7269\u6599\u5230\u8d27\u4fe1\u606f", font, 0));
            document.add((Element)table4);
            PdfPTable table5 = new PdfPTable(4);
            float[] columnWidths5 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            table5.setWidthPercentage(100.0f);
            table5.setWidths(columnWidths5);
            table5.addCell(this.getPdfPCell1("\u7269\u6599\u540d\u79f0", font, 1));
            table5.addCell(this.getPdfPCell1("\u88c5\u7bb1\u6570", font, 1));
            table5.addCell(this.getPdfPCell1("\u5355\u4f4d", font, 1));
            table5.addCell(this.getPdfPCell1("\u6570\u91cf", font, 1));
            document.add((Element)table5);
            PdfPTable table6 = new PdfPTable(4);
            float[] columnWidths6 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            table6.setWidthPercentage(100.0f);
            table6.setWidths(columnWidths6);
            table6.addCell(this.getPdfPCell1(detail.getMaterialName(), detailFont, 0));
            table6.addCell(this.getPdfPCell1(Optional.ofNullable(detail.getPackingBoxNumber()).orElse(BigDecimal.ZERO).toString() + "\u4e2a/\u7bb1", detailFont, 0));
            table6.addCell(this.getPdfPCell1(detail.getUnit(), detailFont, 0));
            table6.addCell(this.getPdfPCell1(Optional.ofNullable(detail.getDeliveryQuantity()).orElse(BigDecimal.ZERO).setScale(0, 4).toString(), detailFont, 0));
            document.add((Element)table6);
            PdfPTable table7 = new PdfPTable(1);
            float[] columnWidths7 = new float[]{1.0f};
            table7.setWidthPercentage(100.0f);
            table7.setWidths(columnWidths7);
            table7.addCell(this.getPdfPCell1("\u4e09\u3001\u7269\u6599\u57fa\u672c\u5de5\u827a\u6807\u51c6", font, 0));
            document.add((Element)table7);
            PdfPTable table8 = new PdfPTable(1);
            float[] columnWidths8 = new float[]{1.0f};
            table8.setWidthPercentage(100.0f);
            table8.setWidths(columnWidths8);
            table8.addCell(this.getPdfPCell(detail.getMaterialBaseStandard(), detailFont, 1));
            document.add((Element)table8);
            PdfPTable table9 = new PdfPTable(1);
            float[] columnWidths9 = new float[]{1.0f};
            table9.setWidthPercentage(100.0f);
            table9.setWidths(columnWidths9);
            table9.addCell(this.getPdfPCell1("\u56db\u3001\u53d1\u8d27\u65b9\u4fe1\u606f", font, 0));
            document.add((Element)table9);
            PdfPTable table10 = new PdfPTable(4);
            float[] columnWidths10 = new float[]{1.0f, 2.0f, 1.0f, 2.0f};
            table10.setWidthPercentage(100.0f);
            table10.setWidths(columnWidths10);
            table10.addCell(this.getPdfPCell1("\u53d1\u8d27\u5355\u4f4d\uff1a", font, 0));
            table10.addCell(this.getPdfPCell1(detail.getSupplierName(), detailFont, 0));
            table10.addCell(this.getPdfPCell1("\u5fae\u4fe1\u53f7\uff1a", font, 0));
            table10.addCell(this.getPdfPCell1(detail.getWeixinNo(), detailFont, 0));
            document.add((Element)table10);
            PdfPTable table11 = new PdfPTable(4);
            float[] columnWidths11 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            table11.setWidthPercentage(100.0f);
            table11.setWidths(columnWidths11);
            table11.addCell(this.getPdfPCell1("\u53d1\u8d27\u65b9\u8054\u7cfb\u4eba\uff1a", font, 0));
            table11.addCell(this.getPdfPCell1(detail.getDeliveryContacts(), detailFont, 0));
            table11.addCell(this.getPdfPCell1("\u8054\u7cfb\u7535\u8bdd\uff1a", font, 0));
            table11.addCell(this.getPdfPCell1(detail.getDeliveryPhone(), detailFont, 0));
            document.add((Element)table11);
            PdfPTable table12 = new PdfPTable(1);
            float[] columnWidths12 = new float[]{1.0f};
            table12.setWidthPercentage(100.0f);
            table12.setWidths(columnWidths12);
            table12.addCell(this.getPdfPCell1("\u4e94\u3001\u6536\u8d27\u65b9\u4fe1\u606f", font, 0));
            document.add((Element)table12);
            float[] columnWidths13 = new float[]{1.0f, 3.0f};
            PdfPTable table13 = new PdfPTable(2);
            table13.setWidthPercentage(100.0f);
            table13.setWidths(columnWidths13);
            table13.addCell(this.getPdfPCell1("\u5ba2\u6237\u540d\u79f0\uff1a", font, 0));
            table13.addCell(this.getPdfPCell1(detail.getCustomerName(), detailFont, 0));
            document.add((Element)table13);
            PdfPTable table14 = new PdfPTable(2);
            table14.setWidthPercentage(100.0f);
            table14.setWidths(columnWidths13);
            table14.addCell(this.getPdfPCell1("\u6536\u8d27\u5730\u5740\uff1a", font, 0));
            table14.addCell(this.getPdfPCell1(detail.getRecipientAddress(), detailFont, 0));
            document.add((Element)table14);
            PdfPTable table15 = new PdfPTable(2);
            table15.setWidthPercentage(100.0f);
            table15.setWidths(columnWidths13);
            table15.addCell(this.getPdfPCell1("\u6536\u8d27\u8054\u7cfb\u4eba\uff1a", font, 0));
            table15.addCell(this.getPdfPCell1(detail.getRecipientContacts(), detailFont, 0));
            document.add((Element)table15);
            PdfPTable table16 = new PdfPTable(2);
            table16.setWidthPercentage(100.0f);
            table16.setWidths(columnWidths13);
            table16.addCell(this.getPdfPCell1("\u6536\u8d27\u4eba\u7535\u8bdd\uff1a", font, 0));
            table16.addCell(this.getPdfPCell1(detail.getRecipientPhone(), detailFont, 0));
            document.add((Element)table16);
            PdfPTable table17 = new PdfPTable(1);
            float[] columnWidths17 = new float[]{1.0f};
            table17.setWidthPercentage(100.0f);
            table17.setWidths(columnWidths17);
            table17.addCell(this.getPdfPCell1("\u516d\u3001\u6536\u8d27\u65b9\u7b7e\u6536\u786e\u8ba4", font, 0));
            document.add((Element)table17);
            PdfPTable table18 = new PdfPTable(1);
            float[] columnWidths18 = new float[]{1.0f};
            table18.setWidthPercentage(100.0f);
            table18.setWidths(columnWidths18);
            table18.addCell(this.getPdfPCell1("\u53cd\u9988\u6e20\u9053\uff1a\u82e5\u6709\u5f02\u8bae\u8bf7\u8054\u7cfb\u8499\u725b\u516c\u53f8\u53cd\u9988\uff1b", font, 0));
            document.add((Element)table18);
            PdfPTable table19 = new PdfPTable(1);
            float[] columnWidths19 = new float[]{1.0f};
            table19.setWidthPercentage(100.0f);
            table19.setWidths(columnWidths19);
            table19.addCell(this.getPdfPCell1("\u6536\u8d27\u7ecf\u529e\u4eba\u786e\u8ba4\uff1a", font, 0));
            document.add((Element)table19);
            PdfPTable table20 = new PdfPTable(1);
            float[] columnWidths20 = new float[]{1.0f};
            table20.setWidthPercentage(100.0f);
            table20.setWidths(columnWidths20);
            table20.addCell(this.getPdfPCell1("\u8054\u7cfb\u7535\u8bdd\uff1a", font, 0));
            document.add((Element)table20);
            document.close();
            log.info("\u751f\u6210\u5bf9\u8d26\u5355\uff1apdf\u5199\u5165\u7ed3\u675f");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (Objects.nonNull(outputStream)) {
                    ((OutputStream)outputStream).close();
                }
                if (Objects.nonNull(inputStream)) {
                    inputStream.close();
                }
                if (Objects.nonNull(outputStream)) {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("pdf\u4e0a\u4f20");
        byte[] fileByte = new byte[(int)file.length()];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int read = fileInputStream.read(fileByte);
            OrdinaryFileVo ordinaryFileVo = this.fileHandleService.fileUpload("default", TenantUtils.getTenantCode(), null, detail.getDetailCode() + ".pdf", fileByte);
            Validate.notNull((Object)ordinaryFileVo, (String)"\u4fc3\u9500\u7269\u6599\u5230\u8d27\u5355\u6587\u4ef6\u751f\u6210\u5931\u8d25!!! \u7f16\u7801\uff1a[%s]", (Object[])new Object[]{detail.getId()});
            detailFile = new TpmMaterialPurchasingOrderFile();
            detailFile.setFileType(TpmMaterialPurchasingOrderEnums.FileType.RECEIVE.getValue());
            detailFile.setFileCode(ordinaryFileVo.getId());
            detailFile.setOriginalFileName(ordinaryFileVo.getOriginalFileName());
            detailFile.setBusinessCode(detail.getDetailCode());
            detailFile.setTenantCode(TenantUtils.getTenantCode());
        }
        catch (IOException e) {
            log.info("\u751f\u6210\u7269\u6599\uff1apdf\u4e0a\u4f20\u5f02\u5e38\uff1a" + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            if (Objects.nonNull(fileInputStream)) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        boolean delete = file.delete();
        if (delete) {
            log.info("\u6587\u4ef6\u5220\u9664\u6210\u529f,{}", (Object)file.getName());
        } else {
            log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25,{}", (Object)file.getName());
        }
        return detailFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TpmMaterialPurchasingOrderFile orderConfirmPdf(TpmMaterialPurchasingOrderVo orderVo) {
        TpmMaterialPurchasingOrderFile detailFile = null;
        log.info("\u751f\u6210\u8ba2\u5355\u786e\u8ba4\u8868\uff1apdf\u5199\u5165\u5f00\u59cb");
        String path = this.baseElectronicSignature.fileRoot;
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(path + "/" + orderVo.getCode() + ".pdf");
        FileOutputStream outputStream = null;
        InputStream inputStream = null;
        Document document = null;
        try {
            outputStream = new FileOutputStream(file);
            document = PdfUtil.createDocument();
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            Font font = PdfUtil.createFont((int)23, (int)0, (BaseColor)BaseColor.BLACK);
            Font colFont = PdfUtil.createFont((int)7, (int)0, (BaseColor)BaseColor.BLACK);
            Paragraph paragraph = PdfUtil.createParagraph((String)"\u8ba2\u5355\u786e\u8ba4\u8868", (Font)font);
            paragraph.setAlignment(1);
            document.add((Element)paragraph);
            font = PdfUtil.createFont((int)13, (int)0, (BaseColor)BaseColor.BLACK);
            Font fontBold = PdfUtil.createFont((int)13, (int)1, (BaseColor)BaseColor.BLACK);
            Font detailFont = PdfUtil.createFont((int)21, (int)0, (BaseColor)BaseColor.BLACK);
            PdfPTable table = new PdfPTable(4);
            float[] columnWidths = new float[]{1.0f, 2.0f, 1.0f, 2.0f};
            table.setWidthPercentage(100.0f);
            table.setPaddingTop(205.0f);
            table.setWidths(columnWidths);
            table.addCell(this.getPdfPCell("\u4f9b\u5e94\u5546\u540d\u79f0", font));
            table.addCell(this.getPdfPCell(orderVo.getSupplierName(), font, 3, 1));
            document.add((Element)table);
            table = new PdfPTable(4);
            table.setWidthPercentage(100.0f);
            table.setWidths(columnWidths);
            table.addCell(this.getPdfPCell("\u7b7e\u53d1\u8ba2\u5355\u65f6\u95f4", font));
            table.addCell(this.getPdfPCell(DateUtil.format((Date)orderVo.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"), font));
            table.addCell(this.getPdfPCell("\u8054\u7cfb\u7535\u8bdd", font));
            table.addCell(this.getPdfPCell(orderVo.getPhone(), font));
            document.add((Element)table);
            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100.0f);
            table.addCell(this.getPdfPCell("\u7269\u6599\u540d\u79f0", font));
            table.addCell(this.getPdfPCell(orderVo.getMaterialName(), font, 3, 1));
            document.add((Element)table);
            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100.0f);
            table.addCell(this.getPdfPCell("\u57fa\u672c\u7269\u6599\u5de5\u827a\u6807\u51c6", font));
            table.addCell(this.getPdfPCell(orderVo.getMaterialBaseStandard(), font, 3, 1));
            document.add((Element)table);
            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100.0f);
            table.addCell(this.getPdfPCell("\u5408\u540c\u5355\u4ef7", font));
            table.addCell(this.getPdfPCell(Optional.ofNullable(orderVo.getContractPrice()).orElse(BigDecimal.ZERO).setScale(2, 4).toPlainString(), font, 3, 1));
            document.add((Element)table);
            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100.0f);
            table.addCell(this.getPdfPCell("\u8ba2\u5355\u6570\u91cf", font));
            table.addCell(this.getPdfPCell(Optional.ofNullable(orderVo.getQuantity()).orElse(BigDecimal.ZERO).setScale(0, 4).toPlainString(), font, 3, 1));
            document.add((Element)table);
            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100.0f);
            table.addCell(this.getPdfPCell("\u91d1\u989d", font));
            table.addCell(this.getPdfPCell(Optional.ofNullable(orderVo.getAmount()).orElse(BigDecimal.ZERO).setScale(2, 4).toPlainString(), font, 3, 1));
            document.add((Element)table);
            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100.0f);
            table.addCell(this.getPdfPCell("\u5230\u8d27\u65f6\u95f4\u8981\u6c42", font));
            table.addCell(this.getPdfPCell(orderVo.getDeliveryDateAsk(), font, 3, 1));
            document.add((Element)table);
            table = new PdfPTable(8);
            float[] columnWidths2 = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
            table.setWidths(columnWidths2);
            table.setWidthPercentage(100.0f);
            table.addCell(this.getPdfPCell("\u5173\u952e\u8282\u70b9\u6392\u671f\u786e\u8ba4", font, 0, 1));
            table.addCell(this.getPdfPCell("\u8282\u70b9", font));
            table.addCell(this.getPdfPCell("\u8ffd\u6837/\u7b7e\u6837", font));
            table.addCell(this.getPdfPCell("\u6a21\u5177\u5b8c\u6210", font));
            table.addCell(this.getPdfPCell("\u5927\u8d27\u6837\u9001\u8fbe", font));
            table.addCell(this.getPdfPCell("\u65e5\u4ea7\u80fd", font));
            table.addCell(this.getPdfPCell("\u5f00\u59cb\u53d1\u8d27", font));
            table.addCell(this.getPdfPCell("\u7ed3\u6848\u6750\u6599\u63d0\u4ea4", font));
            document.add((Element)table);
            table = new PdfPTable(8);
            table.setWidths(columnWidths2);
            table.setWidthPercentage(100.0f);
            table.addCell(this.getPdfPCell("", font));
            table.addCell(this.getPdfPCell("\u65f6\u95f4", font));
            table.addCell(this.getPdfPCell(orderVo.getNodeReceiveDate(), font));
            table.addCell(this.getPdfPCell(orderVo.getNodeMoldDate(), font));
            table.addCell(this.getPdfPCell(orderVo.getNodeSendedDate(), font));
            table.addCell(this.getPdfPCell(orderVo.getNodeCapacityDate(), font));
            table.addCell(this.getPdfPCell(orderVo.getNodeStartDeliveryDate(), font));
            table.addCell(this.getPdfPCell(orderVo.getNodeEndCaseDate(), font));
            document.add((Element)table);
            table = new PdfPTable(4);
            table.setWidths(columnWidths);
            table.setWidthPercentage(100.0f);
            table.addCell(this.getPdfPCell("\u5907\u6ce8", font));
            table.addCell(this.getPdfPCell(orderVo.getRemark(), font, 3, 1));
            document.add((Element)table);
            table = new PdfPTable(2);
            int[] width3 = new int[]{80, 55};
            table.setWidths(width3);
            PdfPCell cell = this.getPdfPCell("\u53d1\u5355\u4eba\u7b7e\u5b57/\u65e5\u671f\uff1a", font);
            PdfPCell cell1 = this.getPdfPCell("\u4f9b\u5e94\u5546\u63a5\u5355\u4eba\u7b7e\u5b57/\u65e5\u671f\uff1a", font);
            cell.setBorder(0);
            cell1.setBorder(0);
            table.addCell(cell);
            table.addCell(cell1);
            document.add((Element)table);
            table = new PdfPTable(2);
            table.setWidths(width3);
            PdfPCell cell2 = this.getPdfPCell("", font);
            PdfPCell cell3 = this.getPdfPCell("\u4f9b\u5e94\u5546\u7b7e\u7ae0\uff08\u516c\u7ae0\uff09", font);
            cell2.setBorder(0);
            cell3.setBorder(0);
            table.addCell(cell2);
            table.addCell(cell3);
            document.add((Element)table);
            document.close();
            log.info("\u751f\u6210\u8ba2\u5355\u786e\u8ba4\u8868\uff1apdf\u5199\u5165\u7ed3\u675f");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (Objects.nonNull(outputStream)) {
                    ((OutputStream)outputStream).close();
                }
                if (Objects.nonNull(inputStream)) {
                    inputStream.close();
                }
                if (Objects.nonNull(outputStream)) {
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("pdf\u4e0a\u4f20");
        byte[] fileByte = new byte[(int)file.length()];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int read = fileInputStream.read(fileByte);
            OrdinaryFileVo ordinaryFileVo = this.fileHandleService.fileUpload("default", TenantUtils.getTenantCode(), null, orderVo.getCode() + ".pdf", fileByte);
            Validate.notNull((Object)ordinaryFileVo, (String)"\u4fc3\u9500\u7269\u6599\u5230\u8d27\u5355\u6587\u4ef6\u751f\u6210\u5931\u8d25!!! \u7f16\u7801\uff1a[%s]", (Object[])new Object[]{orderVo.getCode()});
            detailFile = new TpmMaterialPurchasingOrderFile();
            detailFile.setFileType(TpmMaterialPurchasingOrderEnums.FileType.CONFIRM.getValue());
            detailFile.setFileCode(ordinaryFileVo.getId());
            detailFile.setOriginalFileName(ordinaryFileVo.getOriginalFileName());
            detailFile.setBusinessCode(orderVo.getCode());
            detailFile.setTenantCode(TenantUtils.getTenantCode());
        }
        catch (IOException e) {
            log.info("\u751f\u6210\u7269\u6599\uff1apdf\u4e0a\u4f20\u5f02\u5e38\uff1a" + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            if (Objects.nonNull(fileInputStream)) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        boolean delete = file.delete();
        if (delete) {
            log.info("\u6587\u4ef6\u5220\u9664\u6210\u529f,{}", (Object)file.getName());
        } else {
            log.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25,{}", (Object)file.getName());
        }
        return detailFile;
    }

    public PdfPCell getPdfPCell(String value, Font font, Integer alignElement) {
        return this.getPdfPCell(value, font, 0, 0, alignElement);
    }

    public PdfPCell getPdfPCell(String value, Font font) {
        return this.getPdfPCell(value, font, 0, 0, null);
    }

    public PdfPCell getPdfPCell(String value, Font font, int colspan, int rowspan) {
        return this.getPdfPCell(value, font, colspan, rowspan, null);
    }

    public PdfPCell getPdfPCell(String value, Font font, int colspan, int rowspan, Integer alignElement) {
        PdfPCell cell = new PdfPCell(new Phrase(value, font));
        cell.setUseBorderPadding(true);
        cell.setBorderColor(BaseColor.LIGHT_GRAY);
        cell.setFixedHeight(40.0f);
        if (Objects.nonNull(alignElement)) {
            cell.setHorizontalAlignment(alignElement.intValue());
        } else {
            cell.setHorizontalAlignment(1);
        }
        cell.setVerticalAlignment(5);
        cell.setColspan(colspan);
        cell.setRowspan(rowspan);
        return cell;
    }

    public PdfPCell getPdfPCell1(String value, Font font, Integer alignElement) {
        return this.getPdfPCell1(value, font, 0, 0, alignElement);
    }

    public PdfPCell getPdfPCell1(String value, Font font, int colspan, int rowspan, Integer alignElement) {
        PdfPCell cell = new PdfPCell(new Phrase(value, font));
        cell.setUseBorderPadding(true);
        cell.setBorderColor(BaseColor.LIGHT_GRAY);
        cell.setFixedHeight(20.0f);
        if (Objects.nonNull(alignElement)) {
            cell.setHorizontalAlignment(alignElement.intValue());
        } else {
            cell.setHorizontalAlignment(1);
        }
        cell.setVerticalAlignment(5);
        cell.setColspan(colspan);
        cell.setRowspan(rowspan);
        return cell;
    }
}

