/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.local.service.internal;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.news.notice.sdk.service.NewsNoticeVoService;
import com.biz.crm.mdm.business.promotion.material.sdk.dto.OrderQualityLevelDto;
import com.biz.crm.mdm.business.promotion.material.sdk.service.PromotionMaterialService;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.OrderQualityLevelVO;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.CreateContractVo;
import com.biz.crm.mn.third.system.electronic.signature.center.sdk.vo.ElectronicSignatureVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrder;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderAuditFile;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderAuditInvoice;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderDetail;
import com.biz.crm.tpm.business.material.purchasing.order.local.entity.TpmMaterialPurchasingOrderFile;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderAuditFileRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderAuditInvoiceRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderDetailRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderFileRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.repository.TpmMaterialPurchasingOrderRepository;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderAuditInvoiceService;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderDetailService;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.TpmMaterialPurchasingOrderPdfService;
import com.biz.crm.tpm.business.material.purchasing.order.local.service.internal.TpmMaterialPurchasingBaseElectronicSignature;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderAuditFileDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderAuditInvoiceDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderFileDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderfindCustomerDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.log.TpmMaterialPurchasingOrderLogEventDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.enums.TpmMaterialPurchasingOrderEnums;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.event.log.TpmMaterialPurchasingOrderLogEventListener;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderAuditFileVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderAuditInvoiceVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderDetailVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderFileVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderFindCustomerVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tpmMaterialPurchasingOrderService")
public class TpmMaterialPurchasingOrderServiceImpl
implements TpmMaterialPurchasingOrderService {
    private static final Logger log = LoggerFactory.getLogger(TpmMaterialPurchasingOrderServiceImpl.class);
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderRepository tpmMaterialPurchasingOrderRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderDetailRepository tpmMaterialPurchasingOrderDetailRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderDetailService tpmMaterialPurchasingOrderDetailService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;
    @Autowired
    private PromotionMaterialService promotionMaterialService;
    @Autowired(required=false)
    private ProcessBatchBusinessService processBatchBusinessService;
    @Autowired
    private TpmMaterialPurchasingOrderPdfService pdfService;
    @Autowired
    private TpmMaterialPurchasingOrderFileRepository fileRepository;
    @Autowired
    private TpmMaterialPurchasingBaseElectronicSignature baseElectronicSignature;
    @Autowired
    private TpmMaterialPurchasingOrderAuditInvoiceRepository auditInvoiceRepository;
    @Autowired
    private TpmMaterialPurchasingOrderAuditFileRepository auditFileRepository;
    @Autowired
    private TpmMaterialPurchasingOrderAuditInvoiceService tpmMaterialPurchasingOrderAuditInvoiceService;
    @Autowired(required=false)
    private NewsNoticeVoService newsNoticeVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderService tpmMaterialPurchasingOrderService;

    public Page<TpmMaterialPurchasingOrderVo> findByConditions(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmMaterialPurchasingOrderDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.tpmMaterialPurchasingOrderRepository.findByConditions(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveBatch(List<TpmMaterialPurchasingOrderDto> tpmMaterialPurchasingOrderDtoList) {
        if (CollectionUtils.isEmpty(tpmMaterialPurchasingOrderDtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List entityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(tpmMaterialPurchasingOrderDtoList, TpmMaterialPurchasingOrderDto.class, TpmMaterialPurchasingOrder.class, HashSet.class, ArrayList.class, new String[0]);
        List codeList = this.generateCodeService.generateCode("WLCGD", entityList.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        List supplierCodes = tpmMaterialPurchasingOrderDtoList.stream().map(TpmMaterialPurchasingOrderDto::getSupplierCode).collect(Collectors.toList());
        List supplierVoList = this.supplierVoService.findBySupplierCodes(supplierCodes);
        Map supplierVoMap = supplierVoList.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, Function.identity()));
        AtomicInteger index = new AtomicInteger(0);
        entityList.forEach(entity -> {
            String code = (String)codeList.get(index.getAndIncrement());
            entity.setCode(code);
            entity.setTenantCode(tenantCode);
            entity.setStatus(TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue());
            if (Objects.nonNull(supplierVoMap.get(entity.getSupplierCode()))) {
                entity.setSupplierOrg(((SupplierVo)supplierVoMap.get(entity.getSupplierCode())).getHrOrgCode());
                entity.setSupplierOrgName(((SupplierVo)supplierVoMap.get(entity.getSupplierCode())).getHrOrgName());
            }
            log.info("\u65b0\u751f\u6210\u7269\u6599\u91c7\u8d2d\u5355\u751f\u6210\u786e\u8ba4\u8868");
            TpmMaterialPurchasingOrderVo orderVo = (TpmMaterialPurchasingOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmMaterialPurchasingOrderVo.class, HashSet.class, ArrayList.class, new String[0]);
            TpmMaterialPurchasingOrderFile file = this.pdfService.orderConfirmPdf(orderVo);
            if (Objects.nonNull((Object)file)) {
                this.fileRepository.save((Object)file);
            }
        });
        this.tpmMaterialPurchasingOrderRepository.saveBatch(entityList);
    }

    public Page<TpmMaterialPurchasingOrderVo> findByConditionsForAuditPage(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmMaterialPurchasingOrderDto();
        }
        dto.setStatus(TpmMaterialPurchasingOrderEnums.OrderStatus.BACK_40.getValue());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.tpmMaterialPurchasingOrderRepository.findByConditionsForAuditPage(pageable, dto);
    }

    public Page<TpmMaterialPurchasingOrderDetailVo> findDetailListByCodeForAuditPage(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmMaterialPurchasingOrderDto();
        }
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u8bf7\u586b\u5199\u4e1a\u6001\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u8bf7\u586b\u5199\u4e1a\u52a1\u5355\u5143\uff01", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setStatus(TpmMaterialPurchasingOrderEnums.OrderStatus.CONFIRM_30.getValue());
        ArrayList detailReceiveStatusList = Lists.newArrayList();
        detailReceiveStatusList.add(TpmMaterialPurchasingOrderEnums.ReceiveStatus.DELIVERIED.getValue());
        detailReceiveStatusList.add(TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_DELIVERIED.getValue());
        dto.setDetailReceiveStatusList((List)detailReceiveStatusList);
        return this.tpmMaterialPurchasingOrderDetailRepository.findDetailListByCodeForAuditPage(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void addDetailList(TpmMaterialPurchasingOrderDto dto) {
        List customerVoList;
        this.addDetailValidate(dto);
        TpmMaterialPurchasingOrder entity = this.tpmMaterialPurchasingOrderRepository.getByCode(dto.getCode());
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u7269\u6599\u91c7\u8d2d\u5355", (Object[])new Object[0]);
        List dtos = this.tpmMaterialPurchasingOrderDetailService.findCacheList(dto.getCacheKey());
        Validate.notEmpty((Collection)dtos, (String)"\u660e\u7ec6\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)TpmMaterialPurchasingOrderEnums.OrderStatus.CONFIRM_30.getValue(), (CharSequence)entity.getStatus())) {
            this.updateDetailForConfirmStatus(dtos, entity);
            return;
        }
        Validate.isTrue((!StringUtils.equals((CharSequence)TpmMaterialPurchasingOrderEnums.OrderStatus.CONFIRM_30.getValue(), (CharSequence)entity.getStatus()) ? 1 : 0) != 0, (String)"\u5df2\u786e\u8ba4\u7684\u91c7\u8d2d\u5355\u4e0d\u80fd\u6dfb\u52a0\u660e\u7ec6", (Object[])new Object[0]);
        List<String> activityDetailPlanItemCodes = dtos.stream().map(TpmMaterialPurchasingOrderDetailDto::getActivityDetailItemCode).collect(Collectors.toList());
        List<TpmMaterialPurchasingOrderDetail> oldDetailList = this.tpmMaterialPurchasingOrderDetailRepository.findByDetailPlanItemCodeList(activityDetailPlanItemCodes);
        if (CollectionUtils.isNotEmpty(oldDetailList)) {
            List codes = oldDetailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).distinct().collect(Collectors.toList());
            for (String code : codes) {
                Validate.isTrue((boolean)code.equals(entity.getCode()), (String)"\u660e\u7ec6\u884c\u5728\u5176\u4ed6\u7269\u6599\u91c7\u8d2d\u5355\u4e2d\u5df2\u5b58\u5728", (Object[])new Object[0]);
            }
        }
        List<TpmMaterialPurchasingOrderDetailVo> oldDetailList2 = this.tpmMaterialPurchasingOrderDetailRepository.findByCode(dto.getCode());
        this.tpmMaterialPurchasingOrderDetailRepository.deleteByCode(dto.getCode());
        List detailList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dtos, TpmMaterialPurchasingOrderDetailDto.class, TpmMaterialPurchasingOrderDetail.class, HashSet.class, ArrayList.class, new String[0]);
        log.info("\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)detailList));
        AtomicReference<BigDecimal> totalPurchasingQuantity = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> totalDeliveryQuantity = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> totalReceivingQuantity = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        detailList.forEach(detail -> {
            if (Objects.nonNull(detail.getPurchasingQuantity())) {
                totalPurchasingQuantity.set(((BigDecimal)totalPurchasingQuantity.get()).add(detail.getPurchasingQuantity()));
            }
            if (Objects.nonNull(detail.getDeliveryQuantity())) {
                totalDeliveryQuantity.set(((BigDecimal)totalDeliveryQuantity.get()).add(detail.getDeliveryQuantity()));
            }
            if (Objects.nonNull(detail.getReceivingQuantity())) {
                totalReceivingQuantity.set(((BigDecimal)totalReceivingQuantity.get()).add(detail.getReceivingQuantity()));
            }
        });
        entity.setQuantity(totalPurchasingQuantity.get());
        entity.setDeliveryQuantity(totalDeliveryQuantity.get());
        entity.setReceivingQuantity(totalReceivingQuantity.get());
        OrderQualityLevelDto qualityLevelDto = new OrderQualityLevelDto();
        qualityLevelDto.setMaterialCode(dto.getMaterialCode());
        qualityLevelDto.setMaterialQuantityStr(String.valueOf(totalPurchasingQuantity.get().intValue()));
        OrderQualityLevelVO qualityLevelVO = this.promotionMaterialService.findPriceByMaterialCode(qualityLevelDto);
        log.info("\u7269\u6599\u780d\u4ef7\uff1a{}", (Object)JSONObject.toJSONString((Object)qualityLevelVO));
        Validate.notNull((Object)qualityLevelVO, (String)"\u672a\u627e\u5230\u7269\u6599\u574e\u4ef7", (Object[])new Object[0]);
        ArrayList codeList = Lists.newArrayList();
        if (detailList.stream().anyMatch(e -> StringUtils.isBlank((CharSequence)e.getDetailCode()))) {
            codeList.addAll(this.generateCodeService.generateCode("WLCGDD", (int)detailList.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getDetailCode())).count(), Integer.valueOf(5), 2L, TimeUnit.DAYS));
        }
        List materialCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getMaterialCode).distinct().collect(Collectors.toList());
        HashMap materialVOMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(materialCodes)) {
            List materialVOS = this.promotionMaterialService.findByCodeList(materialCodes);
            materialVOMap.putAll(materialVOS.stream().collect(Collectors.toMap(PromotionMaterialVO::getMaterialCode, Function.identity(), (v1, v2) -> v1)));
        }
        List customerCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getCustomerCode).distinct().collect(Collectors.toList());
        HashMap customerVoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(customerCodes) && CollectionUtils.isNotEmpty((Collection)(customerVoList = this.customerVoService.findByCustomerCodes(customerCodes)))) {
            customerVoMap.putAll(customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity(), (v1, v2) -> v1)));
        }
        String tenantCode = TenantUtils.getTenantCode();
        Validate.notNull((Object)qualityLevelVO.getMoney(), (String)"\u672a\u627e\u5230\u7269\u6599\u574e\u4ef7", (Object[])new Object[0]);
        BigDecimal money = qualityLevelVO.getMoney();
        entity.setAmount(totalPurchasingQuantity.get().multiply(money));
        entity.setDeliveryAmount(totalDeliveryQuantity.get().multiply(money));
        entity.setReceivingAmount(totalReceivingQuantity.get().multiply(money));
        entity.setContractPrice(money);
        AtomicInteger index = new AtomicInteger(0);
        detailList.forEach(detail -> {
            if (StringUtils.isBlank((CharSequence)detail.getDetailCode())) {
                String detailCode = (String)codeList.get(index.getAndIncrement());
                detail.setDetailCode(detailCode);
            }
            detail.setTenantCode(tenantCode);
            detail.setCode(entity.getCode());
            detail.setAmount(money.multiply(detail.getPurchasingQuantity()));
            detail.setContractPrice(money);
            detail.setSupplierCode(entity.getSupplierCode());
            detail.setSupplierName(entity.getSupplierName());
            detail.setReceivingStatus(TpmMaterialPurchasingOrderEnums.ReceiveStatus.WAIT_RECEIVE.getValue());
            detail.setDetailStatus(ProcessStatusEnum.PREPARE.getDictCode());
            if (Objects.nonNull(detail.getDeliveryQuantity())) {
                detail.setDeliveryAmount(detail.getDeliveryQuantity().multiply(money));
            }
            if (Objects.nonNull(detail.getReceivingQuantity())) {
                detail.setReceivingAmount(detail.getReceivingQuantity().multiply(money));
            }
            if (materialVOMap.containsKey(detail.getMaterialCode())) {
                detail.setUnit(((PromotionMaterialVO)materialVOMap.get(detail.getMaterialCode())).getUnit());
                detail.setPackingBoxNumber(Objects.nonNull(((PromotionMaterialVO)materialVOMap.get(detail.getMaterialCode())).getBoxSpecification()) ? new BigDecimal(((PromotionMaterialVO)materialVOMap.get(detail.getMaterialCode())).getBoxSpecification()) : null);
                detail.setMaterialBaseStandard(((PromotionMaterialVO)materialVOMap.get(detail.getMaterialCode())).getQualityStandard());
            }
            if (customerVoMap.containsKey(detail.getCustomerCode())) {
                detail.setDeliveryDealer(((CustomerVo)customerVoMap.get(detail.getCustomerCode())).getCityName());
            }
        });
        this.tpmMaterialPurchasingOrderRepository.updateById((Object)entity);
        this.tpmMaterialPurchasingOrderDetailRepository.saveOrUpdateBatch(detailList);
        this.handleChangeStatus(Lists.newArrayList((Object[])new String[]{entity.getCode()}));
        this.updateActivityDetail(entity.getCode(), activityDetailPlanItemCodes, oldDetailList2);
    }

    private void updateActivityDetail(String code, List<String> activityDetailPlanItemCodes, List<TpmMaterialPurchasingOrderDetailVo> oldDetailList2) {
        List<String> newActivityDetailCodes = activityDetailPlanItemCodes;
        List oldActivityDetailCodes = oldDetailList2.stream().map(TpmMaterialPurchasingOrderDetailVo::getActivityDetailItemCode).collect(Collectors.toList());
        List<Object> thisNewActivityDetailCodes = new ArrayList();
        List<Object> thisDelActivityDetailCodes = new ArrayList();
        thisNewActivityDetailCodes = CollectionUtils.isEmpty(oldActivityDetailCodes) ? newActivityDetailCodes : newActivityDetailCodes.stream().filter(n -> oldActivityDetailCodes.stream().noneMatch(o -> o.equals(n))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(oldActivityDetailCodes)) {
            thisDelActivityDetailCodes = oldActivityDetailCodes.stream().filter(o -> newActivityDetailCodes.stream().noneMatch(n -> n.equals(o))).collect(Collectors.toList());
        }
        this.activityDetailPlanItemSdkService.updateActivityDetailPurchasingOrder(code, thisNewActivityDetailCodes, thisDelActivityDetailCodes);
    }

    private void updateDetailForConfirmStatus(List<TpmMaterialPurchasingOrderDetailDto> dtos, TpmMaterialPurchasingOrder entity) {
        BigDecimal totalPurchasingQuantity = BigDecimal.ZERO;
        TpmMaterialPurchasingOrder tpmMaterialPurchasingOrder = new TpmMaterialPurchasingOrder();
        tpmMaterialPurchasingOrder.setId(entity.getId());
        tpmMaterialPurchasingOrder.setDeliveryQuantity(BigDecimal.ZERO);
        ArrayList<TpmMaterialPurchasingOrderDetail> detailList = new ArrayList<TpmMaterialPurchasingOrderDetail>();
        for (TpmMaterialPurchasingOrderDetailDto dto : dtos) {
            TpmMaterialPurchasingOrderDetail orderDetail = new TpmMaterialPurchasingOrderDetail();
            orderDetail.setId(dto.getId());
            orderDetail.setRecipientAddress(dto.getRecipientAddress());
            orderDetail.setRecipientContacts(dto.getRecipientContacts());
            orderDetail.setRecipientPhone(dto.getRecipientPhone());
            orderDetail.setWeixinNo(dto.getWeixinNo());
            orderDetail.setDeliveryContacts(dto.getDeliveryContacts());
            orderDetail.setDeliveryPhone(dto.getDeliveryPhone());
            orderDetail.setDeliveryQuantity(dto.getDeliveryQuantity());
            orderDetail.setDeliveryDate(dto.getDeliveryDate());
            orderDetail.setRecipientDate(dto.getRecipientDate());
            detailList.add(orderDetail);
            tpmMaterialPurchasingOrder.setDeliveryQuantity(tpmMaterialPurchasingOrder.getDeliveryQuantity().add(Optional.ofNullable(dto.getDeliveryQuantity()).orElse(BigDecimal.ZERO)));
            totalPurchasingQuantity = totalPurchasingQuantity.add(Optional.ofNullable(dto.getPurchasingQuantity()).orElse(BigDecimal.ZERO));
        }
        OrderQualityLevelDto qualityLevelDto = new OrderQualityLevelDto();
        qualityLevelDto.setMaterialCode(entity.getMaterialCode());
        qualityLevelDto.setMaterialQuantityStr(String.valueOf(totalPurchasingQuantity.intValue()));
        OrderQualityLevelVO qualityLevelVO = this.promotionMaterialService.findPriceByMaterialCode(qualityLevelDto);
        log.info("\u7269\u6599\u780d\u4ef7\uff1a{}", (Object)JSONObject.toJSONString((Object)qualityLevelVO));
        Validate.notNull((Object)qualityLevelVO, (String)"\u672a\u627e\u5230\u7269\u6599\u574e\u4ef7", (Object[])new Object[0]);
        Validate.notNull((Object)qualityLevelVO.getMoney(), (String)"\u672a\u627e\u5230\u7269\u6599\u574e\u4ef7", (Object[])new Object[0]);
        BigDecimal money = qualityLevelVO.getMoney();
        tpmMaterialPurchasingOrder.setDeliveryAmount(Optional.ofNullable(tpmMaterialPurchasingOrder.getDeliveryAmount()).orElse(BigDecimal.ZERO).multiply(money));
        for (TpmMaterialPurchasingOrderDetail orderDetail : detailList) {
            if (!Objects.nonNull(orderDetail.getDeliveryQuantity())) continue;
            orderDetail.setDeliveryAmount(orderDetail.getDeliveryQuantity().multiply(money));
        }
        this.tpmMaterialPurchasingOrderRepository.updateById((Object)tpmMaterialPurchasingOrder);
        this.tpmMaterialPurchasingOrderDetailRepository.updateBatchById(detailList);
    }

    @Transactional
    public void processBack(List<String> codes, String status) {
        if (CollectionUtils.isEmpty(codes) || StringUtils.isEmpty((CharSequence)status)) {
            return;
        }
        this.tpmMaterialPurchasingOrderRepository.updateStatusByCodes(codes, status);
    }

    @Transactional
    public void materialGroupUpdate(TpmMaterialPurchasingOrderDto dto) {
        this.updateValidate(dto);
        TpmMaterialPurchasingOrder entity = (TpmMaterialPurchasingOrder)((Object)this.tpmMaterialPurchasingOrderRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u7269\u6599\u62a5\u635f\u7b49\u7ea7\u4fe1\u606f", (Object[])new Object[0]);
        entity.setPhone(dto.getPhone());
        entity.setRemark(dto.getRemark());
        entity.setDeliveryDateAsk(dto.getDeliveryDateAsk());
        entity.setNodeEndCaseDate(dto.getNodeEndCaseDate());
        entity.setMaterialBaseStandard(dto.getMaterialBaseStandard());
        entity.setMaterialGroupEdit(YesOrNoEnum.YES.getCode());
        this.tpmMaterialPurchasingOrderRepository.updateById((Object)entity);
        this.tpmMaterialPurchasingOrderDetailRepository.updateRecipientDate(dto.getDeliveryDateAsk(), entity.getCode());
        TpmMaterialPurchasingOrderVo orderVo = (TpmMaterialPurchasingOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmMaterialPurchasingOrderVo.class, HashSet.class, ArrayList.class, new String[0]);
        TpmMaterialPurchasingOrderFile file = this.pdfService.orderConfirmPdf(orderVo);
        this.fileRepository.deleteByBusinessCode(entity.getCode());
        this.fileRepository.save((Object)file);
    }

    @Transactional(rollbackFor={Exception.class})
    public void outConfirm(TpmMaterialPurchasingOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List detailList = this.tpmMaterialPurchasingOrderDetailRepository.listByIds(dto.getIds());
        Validate.notEmpty((Collection)detailList, (String)"\u672a\u627e\u5230\u8be6\u60c5\u4fe1\u606f", (Object[])new Object[0]);
        List<String> codes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).distinct().collect(Collectors.toList());
        List<TpmMaterialPurchasingOrder> orderList = this.tpmMaterialPurchasingOrderRepository.findByCodeList(codes);
        Validate.notEmpty(orderList, (String)"\u672a\u627e\u5230\u91c7\u8d2d\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Map orderMap = orderList.stream().collect(Collectors.toMap(TpmMaterialPurchasingOrder::getCode, Function.identity()));
        detailList.forEach(detail -> {
            TpmMaterialPurchasingOrder order = (TpmMaterialPurchasingOrder)((Object)((Object)orderMap.get(detail.getCode())));
            Validate.notNull((Object)((Object)order), (String)(detail.getDetailCode() + ":\u672a\u627e\u5230\u91c7\u8d2d\u5355\u4fe1\u606f"), (Object[])new Object[0]);
            if (!TpmMaterialPurchasingOrderEnums.OrderStatus.CONFIRM_30.getValue().equals(order.getStatus()) || !StringUtils.equalsAny((CharSequence)detail.getReceivingStatus(), (CharSequence[])new CharSequence[]{TpmMaterialPurchasingOrderEnums.ReceiveStatus.WAIT_RECEIVE.getValue()}) || TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGEING.getValue().equals(detail.getActivityDetailChangeStatus())) {
                throw new IllegalArgumentException("\u53ea\u80fd\u5bf9\u91c7\u8d2d\u72b6\u6001\u4e3a\u3010\u5df2\u786e\u8ba4\u3011\u4e14\u7b7e\u6536\u72b6\u6001\u4e3a\u3010\u5f85\u51fa\u5e93\u3011\u4e14\u6d3b\u52a8\u7ec6\u6848\u8c03\u6574\u72b6\u6001\u4e0d\u4e3a\u3010\u8c03\u6574\u4e2d\u3011\u7684\u7269\u6599\u91c7\u8d2d\u5355\u51fa\u5e93\u786e\u8ba4");
            }
        });
        ArrayList<TpmMaterialPurchasingOrder> orderListUpdate = new ArrayList<TpmMaterialPurchasingOrder>();
        for (TpmMaterialPurchasingOrder order : orderList) {
            TpmMaterialPurchasingOrder orderUpdate = new TpmMaterialPurchasingOrder();
            orderUpdate.setId(order.getId());
            orderUpdate.setSubmitTime(DateUtil.dateStrNowAll());
            orderListUpdate.add(orderUpdate);
        }
        this.tpmMaterialPurchasingOrderRepository.updateBatchById(orderListUpdate);
        ArrayList fileList = Lists.newArrayList();
        detailList.forEach(detail -> {
            TpmMaterialPurchasingOrderFile file = this.pdfService.outConfirmPdf((TpmMaterialPurchasingOrderDetail)((Object)detail));
            fileList.add(file);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                log.info("\u7761\u4e0d\u7740\u4e86,{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            ElectronicSignatureVo<CreateContractVo> signatureVo = this.baseElectronicSignature.pushElectronicSignature((TpmMaterialPurchasingOrderDetail)((Object)detail), file);
            log.info("\u7b2c\u4e09\u65b9\u7b7e\u7ae0\u8fd4\u56de\uff1a{}", (Object)JSONObject.toJSONString(signatureVo));
            Optional<ElectronicSignatureVo<CreateContractVo>> electronicSignatureVo = Optional.ofNullable(signatureVo);
            if (electronicSignatureVo.isPresent()) {
                ElectronicSignatureVo<CreateContractVo> voElectronicSignatureVo = electronicSignatureVo.get();
                if (Objects.isNull(voElectronicSignatureVo.getResult())) {
                    return;
                }
                detail.setContractId(String.valueOf(((CreateContractVo)voElectronicSignatureVo.getResult()).getContractId()));
                detail.setDocumentsId(String.valueOf(((CreateContractVo)voElectronicSignatureVo.getResult()).getDocumentId()));
                detail.setAlreadyDeliveryQuantity(detail.getDeliveryQuantity());
            }
            if (Optional.ofNullable(detail.getDeliveryQuantity()).orElse(BigDecimal.ZERO).compareTo(detail.getPurchasingQuantity()) >= 0) {
                detail.setReceivingStatus(TpmMaterialPurchasingOrderEnums.ReceiveStatus.RECEIVED.getValue());
            }
            if (Optional.ofNullable(detail.getDeliveryQuantity()).orElse(BigDecimal.ZERO).compareTo(detail.getPurchasingQuantity()) < 0) {
                detail.setReceivingStatus(TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_RECEIVE.getValue());
            }
        });
        List<String> detailCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getDetailCode).collect(Collectors.toList());
        this.fileRepository.deleteByBusinessCodes(detailCodes);
        this.fileRepository.saveBatch(fileList);
        this.tpmMaterialPurchasingOrderDetailRepository.updateBatchById(detailList);
        this.handleReceiving(detailList);
        List transferDto = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailList, TpmMaterialPurchasingOrderDetail.class, TpmMaterialPurchasingOrderDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.tpmMaterialPurchasingOrderDetailService.addItemCache(dto.getCacheKey(), transferDto);
    }

    private void handleReceiving(List<TpmMaterialPurchasingOrderDetail> detailList) {
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        List<String> codes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).distinct().collect(Collectors.toList());
        List<TpmMaterialPurchasingOrder> orderList = this.tpmMaterialPurchasingOrderRepository.findByCodeList(codes);
        if (CollectionUtils.isEmpty(orderList)) {
            return;
        }
        List<TpmMaterialPurchasingOrderDetail> details = this.tpmMaterialPurchasingOrderDetailRepository.findByCodeList(codes);
        Map<String, List<TpmMaterialPurchasingOrderDetail>> groupBy = details.stream().collect(Collectors.groupingBy(TpmMaterialPurchasingOrderDetail::getCode));
        orderList.forEach(order -> {
            if (groupBy.containsKey(order.getCode())) {
                TpmMaterialPurchasingOrder update = new TpmMaterialPurchasingOrder();
                update.setId(order.getId());
                AtomicReference<BigDecimal> totalReceivingQuantity = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> totalReceivingAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                ((List)groupBy.get(order.getCode())).forEach(detail -> {
                    if (Objects.nonNull(detail.getReceivingQuantity())) {
                        totalReceivingQuantity.set(((BigDecimal)totalReceivingQuantity.get()).add(detail.getReceivingQuantity()));
                    }
                    if (Objects.nonNull(detail.getReceivingAmount())) {
                        totalReceivingAmount.set(((BigDecimal)totalReceivingAmount.get()).add(detail.getReceivingAmount()));
                    }
                });
                update.setReceivingAmount(totalReceivingAmount.get());
                update.setReceivingQuantity(totalReceivingQuantity.get());
                this.tpmMaterialPurchasingOrderRepository.updateById((Object)update);
            }
        });
    }

    public List<TpmMaterialPurchasingOrderFileVo> downloadOrderConfirmBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List entityList = this.tpmMaterialPurchasingOrderRepository.listByIds(ids);
        Validate.notEmpty((Collection)entityList, (String)"\u672a\u627e\u5230\u7269\u6599\u91c7\u8d2d\u5355\u4fe1\u606f", (Object[])new Object[0]);
        List<String> codes = entityList.stream().map(TpmMaterialPurchasingOrder::getCode).collect(Collectors.toList());
        List<TpmMaterialPurchasingOrderFile> fileList = this.fileRepository.findByBusinessCodes(codes);
        Validate.notEmpty(fileList, (String)"\u672a\u627e\u5230\u8ba2\u5355\u786e\u8ba4\u8868", (Object[])new Object[0]);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(fileList, TpmMaterialPurchasingOrderFile.class, TpmMaterialPurchasingOrderFileVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void outCancel(TpmMaterialPurchasingOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List detailList = this.tpmMaterialPurchasingOrderDetailRepository.listByIds(dto.getIds());
        Validate.notEmpty((Collection)detailList, (String)"\u672a\u627e\u5230\u8be6\u60c5\u4fe1\u606f", (Object[])new Object[0]);
        List<String> codes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).distinct().collect(Collectors.toList());
        List<TpmMaterialPurchasingOrder> orderList = this.tpmMaterialPurchasingOrderRepository.findByCodeList(codes);
        Validate.notEmpty(orderList, (String)"\u672a\u627e\u5230\u91c7\u8d2d\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Map orderMap = orderList.stream().collect(Collectors.toMap(TpmMaterialPurchasingOrder::getCode, Function.identity()));
        detailList.forEach(detail -> {
            TpmMaterialPurchasingOrder order = (TpmMaterialPurchasingOrder)((Object)((Object)orderMap.get(detail.getCode())));
            Validate.notNull((Object)((Object)order), (String)(detail.getDetailCode() + ":\u672a\u627e\u5230\u91c7\u8d2d\u5355\u4fe1\u606f"), (Object[])new Object[0]);
            if (StringUtils.equals((CharSequence)detail.getReceivingStatus(), (CharSequence)TpmMaterialPurchasingOrderEnums.ReceiveStatus.WAIT_RECEIVE.getValue())) {
                throw new IllegalArgumentException("\u7b7e\u6536\u72b6\u6001\u4e3a\u3010\u5f85\u51fa\u5e93\u3011\u7684\u4e0d\u80fd\u64a4\u56de");
            }
            if (StringUtils.equalsAny((CharSequence)detail.getReceivingStatus(), (CharSequence[])new CharSequence[]{TpmMaterialPurchasingOrderEnums.ReceiveStatus.DELIVERIED.getValue(), TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_DELIVERIED.getValue()})) {
                throw new IllegalArgumentException("\u7b7e\u6536\u72b6\u6001\u4e3a\u3010\u5df2\u6536\u8d27\u3011\u3001\u3010\u90e8\u5206\u6536\u8d27\u3011\u7684\u4e0d\u80fd\u64a4\u56de");
            }
        });
        StringBuffer errorMsg = new StringBuffer();
        detailList.forEach(detail -> {
            try {
                ElectronicSignatureVo electronicSignatureVo = this.baseElectronicSignature.withdrawalElectronicSignature((TpmMaterialPurchasingOrderDetail)((Object)detail));
                if (Objects.nonNull(electronicSignatureVo) && electronicSignatureVo.isSuccess()) {
                    detail.setReceivingStatus(TpmMaterialPurchasingOrderEnums.ReceiveStatus.WAIT_RECEIVE.getValue());
                    detail.setReceivingQuantity(null);
                    detail.setReceivingAmount(null);
                    this.tpmMaterialPurchasingOrderDetailRepository.updateReceivingFieldNull((TpmMaterialPurchasingOrderDetail)((Object)detail));
                } else {
                    errorMsg.append("[" + detail.getDetailCode() + "]\u64a4\u9500\u5931\u8d25");
                }
            }
            catch (Exception e) {
                errorMsg.append("[" + detail.getDetailCode() + "]\u64a4\u9500\u5931\u8d25");
            }
        });
        List<String> detailCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getDetailCode).collect(Collectors.toList());
        this.fileRepository.deleteByBusinessCodes(detailCodes);
        List transferDto = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailList, TpmMaterialPurchasingOrderDetail.class, TpmMaterialPurchasingOrderDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.tpmMaterialPurchasingOrderDetailService.addItemCache(dto.getCacheKey(), transferDto);
    }

    @Transactional
    public void outExpediting(TpmMaterialPurchasingOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List detailList = this.tpmMaterialPurchasingOrderDetailRepository.listByIds(dto.getIds());
        Validate.notEmpty((Collection)detailList, (String)"\u672a\u627e\u5230\u8be6\u60c5\u4fe1\u606f", (Object[])new Object[0]);
        List<String> codes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getCode).distinct().collect(Collectors.toList());
        List<TpmMaterialPurchasingOrder> orderList = this.tpmMaterialPurchasingOrderRepository.findByCodeList(codes);
        Validate.notEmpty(orderList, (String)"\u672a\u627e\u5230\u91c7\u8d2d\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Map orderMap = orderList.stream().collect(Collectors.toMap(TpmMaterialPurchasingOrder::getCode, Function.identity()));
        detailList.forEach(detail -> {
            TpmMaterialPurchasingOrder order = (TpmMaterialPurchasingOrder)((Object)((Object)orderMap.get(detail.getCode())));
            Validate.notNull((Object)((Object)order), (String)(detail.getDetailCode() + ":\u672a\u627e\u5230\u91c7\u8d2d\u5355\u4fe1\u606f"), (Object[])new Object[0]);
            if (!StringUtils.equalsAny((CharSequence)detail.getReceivingStatus(), (CharSequence[])new CharSequence[]{TpmMaterialPurchasingOrderEnums.ReceiveStatus.RECEIVED.getValue(), TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_RECEIVE.getValue()})) {
                throw new IllegalArgumentException("\u7b7e\u6536\u72b6\u6001\u4e3a\u3010\u5df2\u51fa\u5e93\u3011\u3001\u3010\u90e8\u5206\u51fa\u5e93\u3011\u7684\u624d\u80fd\u50ac\u7b7e");
            }
        });
        detailList.forEach(detail -> {
            ElectronicSignatureVo electronicSignatureVo = this.baseElectronicSignature.expeditingElectronicSignature((TpmMaterialPurchasingOrderDetail)((Object)detail));
        });
        List transferDto = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailList, TpmMaterialPurchasingOrderDetail.class, TpmMaterialPurchasingOrderDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.tpmMaterialPurchasingOrderDetailService.addItemCache(dto.getCacheKey(), transferDto);
    }

    public List<TpmMaterialPurchasingOrderFileVo> downloadOutConfirmBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List detailList = this.tpmMaterialPurchasingOrderDetailRepository.listByIds(ids);
        Validate.notEmpty((Collection)detailList, (String)"\u672a\u627e\u5230\u7269\u6599\u91c7\u8d2d\u5355\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        List<String> codes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getDetailCode).collect(Collectors.toList());
        List<TpmMaterialPurchasingOrderFile> fileList = this.fileRepository.findByBusinessCodes(codes);
        Validate.notEmpty(fileList, (String)"\u672a\u627e\u5230\u8ba2\u5355\u7b7e\u6536\u8868", (Object[])new Object[0]);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(fileList, TpmMaterialPurchasingOrderFile.class, TpmMaterialPurchasingOrderFileVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public TpmMaterialPurchasingOrderDetailVo findDetailById(String id) {
        Validate.notEmpty((CharSequence)id, (String)"\u53c2\u6570\u9519\u8bef", (Object[])new Object[0]);
        TpmMaterialPurchasingOrderDetail detail = (TpmMaterialPurchasingOrderDetail)((Object)this.tpmMaterialPurchasingOrderDetailRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)detail), (String)"\u672a\u627e\u5230\u8be6\u60c5\u4fe1\u606f", (Object[])new Object[0]);
        TpmMaterialPurchasingOrderDetailVo detailVo = (TpmMaterialPurchasingOrderDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail, TpmMaterialPurchasingOrderDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<TpmMaterialPurchasingOrderFile> fileEntityList = this.fileRepository.findByBusinessCode(detailVo.getDetailCode());
        if (!CollectionUtils.isEmpty(fileEntityList)) {
            List fileVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(fileEntityList, TpmMaterialPurchasingOrderFile.class, TpmMaterialPurchasingOrderFileVo.class, HashSet.class, ArrayList.class, new String[0]);
            detailVo.setFileList(fileVoList);
        }
        return detailVo;
    }

    @Transactional
    public void uploadOutConfirm(TpmMaterialPurchasingOrderDetailDto dto) {
        Validate.notNull((Object)dto, (String)"\u4e0a\u4f20\u65f6\uff0c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u4e0a\u4f20\u65f6\uff0ccacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getReceivingQuantity(), (String)"\u7b7e\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getId(), (String)"\u8be6\u60c5id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((dto.getReceivingQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u7b7e\u6536\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((dto.getReceivingQuantity().toPlainString().length() <= 16 ? 1 : 0) != 0, (String)"\u7b7e\u6536\u6570\u91cf\u586b\u5199\u6570\u503c\u8fc7\u5927", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getFileList(), (String)"\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TpmMaterialPurchasingOrderDetail detail = (TpmMaterialPurchasingOrderDetail)((Object)this.tpmMaterialPurchasingOrderDetailRepository.getById((Serializable)((Object)dto.getId())));
        TpmMaterialPurchasingOrderDetail update = new TpmMaterialPurchasingOrderDetail();
        update.setId(detail.getId());
        update.setReceivingQuantity(Optional.ofNullable(detail.getReceivingQuantity()).orElse(BigDecimal.ZERO).add(dto.getReceivingQuantity()));
        update.setReceivingAmount(update.getReceivingQuantity().multiply(detail.getContractPrice()));
        update.setAlreadyDeliveryQuantity(update.getReceivingQuantity());
        update.setReceivingDate(DateUtil.formatDate());
        Validate.notNull((Object)detail.getDeliveryQuantity(), (String)"\u672a\u5bfc\u5165\u53d1\u8d27\u6570\u91cf", (Object[])new Object[0]);
        Validate.isTrue((detail.getDeliveryQuantity().compareTo(update.getAlreadyDeliveryQuantity()) >= 0 ? 1 : 0) != 0, (String)"\u5df2\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf", (Object[])new Object[0]);
        Validate.isTrue((!TpmMaterialPurchasingOrderEnums.ReceiveStatus.RECEIVED.getValue().equals(detail.getReceivingStatus()) && !TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_RECEIVE.getValue().equals(detail.getReceivingStatus()) ? 1 : 0) != 0, (String)"\u7b7e\u6536\u72b6\u6001\u4e3a\u5df2\u51fa\u5e93\u548c\u90e8\u5206\u51fa\u5e93\u4e0d\u80fd\u88ab\u7b7e\u6536", (Object[])new Object[0]);
        if (update.getReceivingQuantity().compareTo(Optional.ofNullable(detail.getDeliveryQuantity()).orElse(BigDecimal.ZERO)) >= 0) {
            update.setReceivingStatus(TpmMaterialPurchasingOrderEnums.ReceiveStatus.DELIVERIED.getValue());
        }
        if (update.getReceivingQuantity().compareTo(Optional.ofNullable(detail.getDeliveryQuantity()).orElse(BigDecimal.ZERO)) < 0) {
            update.setReceivingStatus(TpmMaterialPurchasingOrderEnums.ReceiveStatus.PORTIAL_DELIVERIED.getValue());
        }
        List fileEntityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getFileList(), TpmMaterialPurchasingOrderFileDto.class, TpmMaterialPurchasingOrderFile.class, HashSet.class, ArrayList.class, new String[0]);
        String tenantCode = TenantUtils.getTenantCode();
        fileEntityList.forEach(file -> {
            file.setBusinessCode(detail.getDetailCode());
            file.setTenantCode(tenantCode);
            file.setFileType(TpmMaterialPurchasingOrderEnums.FileType.RECEIVE.getValue());
        });
        this.fileRepository.deleteByBusinessCode(detail.getDetailCode());
        this.fileRepository.saveBatch(fileEntityList);
        this.tpmMaterialPurchasingOrderDetailRepository.updateById((Object)update);
        this.handleReceiving(Lists.newArrayList((Object[])new TpmMaterialPurchasingOrderDetail[]{update}));
        TpmMaterialPurchasingOrderDetail newDetail = (TpmMaterialPurchasingOrderDetail)((Object)this.tpmMaterialPurchasingOrderDetailRepository.getById((Serializable)((Object)dto.getId())));
        TpmMaterialPurchasingOrderDetailDto transferDto = (TpmMaterialPurchasingOrderDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)newDetail, TpmMaterialPurchasingOrderDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.tpmMaterialPurchasingOrderDetailService.addItemCache(dto.getCacheKey(), Lists.newArrayList((Object[])new TpmMaterialPurchasingOrderDetailDto[]{transferDto}));
    }

    @Transactional
    public void submitProcess(TpmMaterialPurchasingOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u63d0\u4ea4\u5ba1\u6279\u65f6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getDetailList(), (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getProcessBusiness(), (String)"\u5ba1\u6279\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List ids = dto.getDetailList().stream().map(UuidDto::getId).collect(Collectors.toList());
        List detailList = this.tpmMaterialPurchasingOrderDetailRepository.listByIds(ids);
        this.approceProcess(detailList, dto);
        ArrayList updateList = Lists.newArrayList();
        detailList.forEach(e -> {
            TpmMaterialPurchasingOrderDetail update = new TpmMaterialPurchasingOrderDetail();
            update.setId(e.getId());
            update.setDetailStatus(ProcessStatusEnum.COMMIT.getDictCode());
            update.setProcessNo(e.getProcessNo());
            updateList.add(update);
        });
        this.tpmMaterialPurchasingOrderDetailRepository.updateBatchById(updateList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAuditFile(TpmMaterialPurchasingOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u4e0a\u4f20\u65f6\uff0c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getId(), (String)"\u4e3b\u952e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TpmMaterialPurchasingOrder order = (TpmMaterialPurchasingOrder)((Object)this.tpmMaterialPurchasingOrderRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)order), (String)"\u672a\u627e\u5230\u7269\u6599\u91c7\u8d2d\u5355\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        this.auditInvoiceRepository.deleteByCode(order.getCode());
        List invoiceDtos = this.tpmMaterialPurchasingOrderAuditInvoiceService.findCacheList(dto.getCacheKey());
        if (CollectionUtils.isNotEmpty((Collection)invoiceDtos)) {
            List auditInvoiceEntityList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)invoiceDtos, TpmMaterialPurchasingOrderAuditInvoiceDto.class, TpmMaterialPurchasingOrderAuditInvoice.class, HashSet.class, ArrayList.class, new String[0]);
            auditInvoiceEntityList.forEach(auditInvoice -> {
                auditInvoice.setId(null);
                auditInvoice.setCode(order.getCode());
                auditInvoice.setTenantCode(tenantCode);
            });
            this.auditInvoiceRepository.saveBatch(auditInvoiceEntityList);
        }
        this.auditFileRepository.deleteByBusinessCode(order.getCode());
        if (CollectionUtils.isNotEmpty((Collection)dto.getAuditFileList())) {
            List auditFileList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getAuditFileList(), TpmMaterialPurchasingOrderAuditFileDto.class, TpmMaterialPurchasingOrderAuditFile.class, HashSet.class, ArrayList.class, new String[0]);
            auditFileList.forEach(auditFile -> {
                auditFile.setId(null);
                auditFile.setBusinessCode(order.getCode());
                auditFile.setTenantCode(tenantCode);
            });
            this.auditFileRepository.saveBatch(auditFileList);
        }
        this.tpmMaterialPurchasingOrderAuditInvoiceService.clearCache(dto.getCacheKey());
    }

    public TpmMaterialPurchasingOrderVo getAuditFile(String id) {
        List auditFileVoList;
        Validate.notEmpty((CharSequence)id, (String)"\u4e3b\u952e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TpmMaterialPurchasingOrder order = (TpmMaterialPurchasingOrder)((Object)this.tpmMaterialPurchasingOrderRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)order), (String)"\u672a\u627e\u5230\u7269\u6599\u91c7\u8d2d\u5355\u4fe1\u606f", (Object[])new Object[0]);
        TpmMaterialPurchasingOrderVo orderVo = (TpmMaterialPurchasingOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)order, TpmMaterialPurchasingOrderVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<TpmMaterialPurchasingOrderAuditInvoice> auditInvoiceEntityList = this.auditInvoiceRepository.findByCode(order.getCode());
        if (CollectionUtils.isNotEmpty(auditInvoiceEntityList)) {
            List auditInvoiceVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditInvoiceEntityList, TpmMaterialPurchasingOrderAuditInvoice.class, TpmMaterialPurchasingOrderAuditInvoiceVo.class, HashSet.class, ArrayList.class, new String[0]);
            orderVo.setAuditInvoiceList(auditInvoiceVoList);
        }
        List<TpmMaterialPurchasingOrderFile> confirmFileList = this.fileRepository.findByBusinessCode(order.getCode());
        List<TpmMaterialPurchasingOrderFile> signFileList = this.fileRepository.findSignByCode(order.getCode());
        List<TpmMaterialPurchasingOrderAuditFile> auditFileList = this.auditFileRepository.findByBusinessCode(order.getCode());
        ArrayList allList = Lists.newArrayList();
        List fileList = auditFileList.stream().filter(a -> !StringUtils.equalsAny((CharSequence)a.getTypeCode(), (CharSequence[])new CharSequence[]{TpmMaterialPurchasingOrderEnums.AuditFileTypeCode.CONFIRM.getValue(), TpmMaterialPurchasingOrderEnums.AuditFileTypeCode.SIGN.getValue()})).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(fileList)) {
            auditFileVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditFileList, TpmMaterialPurchasingOrderAuditFile.class, TpmMaterialPurchasingOrderAuditFileVo.class, HashSet.class, ArrayList.class, new String[0]);
            allList.addAll(auditFileVoList);
        }
        if (CollectionUtils.isNotEmpty(confirmFileList)) {
            auditFileVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(confirmFileList, TpmMaterialPurchasingOrderFile.class, TpmMaterialPurchasingOrderAuditFileVo.class, HashSet.class, ArrayList.class, new String[0]);
            auditFileVoList.forEach(file -> {
                file.setTypeCode(TpmMaterialPurchasingOrderEnums.AuditFileTypeCode.CONFIRM.getValue());
                file.setBusinessName(TpmMaterialPurchasingOrderEnums.AuditFileTypeCode.CONFIRM.getDesc());
            });
            allList.addAll(auditFileVoList);
        }
        if (CollectionUtils.isNotEmpty(signFileList)) {
            auditFileVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(signFileList, TpmMaterialPurchasingOrderFile.class, TpmMaterialPurchasingOrderAuditFileVo.class, HashSet.class, ArrayList.class, new String[0]);
            auditFileVoList.forEach(file -> {
                file.setTypeCode(TpmMaterialPurchasingOrderEnums.AuditFileTypeCode.SIGN.getValue());
                file.setBusinessName(TpmMaterialPurchasingOrderEnums.AuditFileTypeCode.SIGN.getDesc());
            });
            allList.addAll(auditFileVoList);
        }
        orderVo.setAuditFileList((List)allList);
        return orderVo;
    }

    private void approceProcess(List<TpmMaterialPurchasingOrderDetail> detailList, TpmMaterialPurchasingOrderDto dto) {
        List detailCodes = detailList.stream().map(TpmMaterialPurchasingOrderDetail::getDetailCode).collect(Collectors.toList());
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNoList(detailCodes);
        processBusiness.setBusinessNo(new Snowflake().nextIdStr());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("tpm_material_purchasing_supplier_order");
        log.info("\u91c7\u8d2d\u5355\u6d41\u7a0b\u63d0\u4ea4\u53c2\u6570(\u63d0\u4ea4\u5ba1\u6279),{}", (Object)JSON.toJSONString((Object)processBusiness));
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
        detailList.forEach(item -> item.setProcessNo(processBusinessVo.getProcessNo()));
        log.info("\u91c7\u8d2d\u5355\u6d41\u7a0b\u63d0\u4ea4\u5ba1\u6279\uff1adetailList\uff1a{}", (Object)JsonUtils.obj2JsonString(detailList));
    }

    private void updateValidate(TpmMaterialPurchasingOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u7f16\u8f91\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getId(), (String)"\u4e3b\u952e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getRemark()) || dto.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u5df2\u7ecf\u8d85\u8fc7255\u957f\u5ea6", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getMaterialBaseStandard()) || dto.getMaterialBaseStandard().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6599\u57fa\u672c\u5de5\u827a\u6807\u51c6\u5df2\u7ecf\u8d85\u8fc7255\u957f\u5ea6", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isBlank((CharSequence)dto.getPhone()) || dto.getPhone().length() <= 20 ? 1 : 0) != 0, (String)"\u7535\u8bdd\u5df2\u7ecf\u8d85\u8fc720\u957f\u5ea6", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void supplierUpdate(TpmMaterialPurchasingOrderDto dto) {
        this.updateValidate(dto);
        TpmMaterialPurchasingOrder entity = (TpmMaterialPurchasingOrder)((Object)this.tpmMaterialPurchasingOrderRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u7269\u6599\u62a5\u635f\u7b49\u7ea7\u4fe1\u606f", (Object[])new Object[0]);
        entity.setPhone(dto.getPhone());
        entity.setRemark(dto.getRemark());
        entity.setNodeMoldDate(dto.getNodeMoldDate());
        entity.setNodeSendedDate(dto.getNodeSendedDate());
        entity.setNodeReceiveDate(dto.getNodeReceiveDate());
        entity.setNodeCapacityDate(dto.getNodeCapacityDate());
        entity.setNodeStartDeliveryDate(dto.getNodeStartDeliveryDate());
        entity.setSupplierEdit(YesOrNoEnum.YES.getCode());
        this.tpmMaterialPurchasingOrderRepository.updateById((Object)entity);
        this.tpmMaterialPurchasingOrderDetailRepository.updateDeliveryDate(dto.getNodeStartDeliveryDate(), entity.getCode());
        TpmMaterialPurchasingOrderVo orderVo = (TpmMaterialPurchasingOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmMaterialPurchasingOrderVo.class, HashSet.class, ArrayList.class, new String[0]);
        TpmMaterialPurchasingOrderFile file = this.pdfService.orderConfirmPdf(orderVo);
        this.fileRepository.deleteByBusinessCode(entity.getCode());
        this.fileRepository.save((Object)file);
    }

    private void addDetailValidate(TpmMaterialPurchasingOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getCode(), (String)"\u7269\u6599\u91c7\u8d2d\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List dtos = this.tpmMaterialPurchasingOrderDetailService.findCacheList(dto.getCacheKey());
        Validate.notEmpty((Collection)dtos, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dtos.forEach(detail -> {
            Validate.notEmpty((CharSequence)detail.getActivityDetailItemCode(), (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)detail.getSalesOrgCode(), (String)"\u9500\u552e\u5927\u533a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)detail.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)detail.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)detail.getPurchasingQuantity(), (String)"\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
    }

    public List<TpmMaterialPurchasingOrderVo> findByConditionsForJava(TpmMaterialPurchasingOrderDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newArrayList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.tpmMaterialPurchasingOrderRepository.findByConditionsForJava(dto);
    }

    public Page<TpmMaterialPurchasingOrderFindCustomerVo> findCustomerByCode(Pageable pageable, TpmMaterialPurchasingOrderfindCustomerDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmMaterialPurchasingOrderfindCustomerDto();
        }
        Validate.notNull((Object)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        TpmMaterialPurchasingOrder entity = (TpmMaterialPurchasingOrder)((Object)this.tpmMaterialPurchasingOrderRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(entity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        dto.setCode(entity.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.tpmMaterialPurchasingOrderDetailRepository.findCustomerByCode(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void editCustomerAddressById(TpmMaterialPurchasingOrderfindCustomerDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getId())) {
            return;
        }
        TpmMaterialPurchasingOrder entity = (TpmMaterialPurchasingOrder)((Object)this.tpmMaterialPurchasingOrderRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(entity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.noNullElements((Iterable)dto.getCustomerCodeList(), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u66f4\u6539\u5730\u5740\u7684\u5ba2\u6237\uff01", (Object[])new Object[0]);
        dto.setCode(entity.getCode());
        List<TpmMaterialPurchasingOrderDetail> detailList = this.tpmMaterialPurchasingOrderDetailRepository.findByCodeAndCustomerCodeList(dto);
        String recipientAddress = dto.getRecipientAddress();
        detailList.forEach(e -> e.setRecipientAddress(recipientAddress));
        this.tpmMaterialPurchasingOrderDetailRepository.saveOrUpdateBatch(detailList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void finishOutStorage(TpmMaterialPurchasingOrderDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getId())) {
            return;
        }
        TpmMaterialPurchasingOrder entity = (TpmMaterialPurchasingOrder)((Object)this.tpmMaterialPurchasingOrderRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(entity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        entity.setStatus(TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue());
        this.tpmMaterialPurchasingOrderRepository.saveOrUpdate((Object)entity);
    }

    public Page<TpmMaterialPurchasingOrderDetailVo> findOutStorageAbleDetailById(Pageable pageable, TpmMaterialPurchasingOrderDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmMaterialPurchasingOrderDto();
        }
        Validate.notNull((Object)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        TpmMaterialPurchasingOrder entity = (TpmMaterialPurchasingOrder)((Object)this.tpmMaterialPurchasingOrderRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(entity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)TpmMaterialPurchasingOrderEnums.OrderStatus.WAIT_CONFIRM_20.getValue().equals(entity.getStatus()), (String)"\u53ea\u6709\u5f85\u51fa\u5e93\u72b6\u6001\u7684\u91c7\u8d2d\u5355\u53ef\u4ee5\u8fdb\u884c\u53d1\u8d27", (Object[])new Object[0]);
        dto.setCode(entity.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.tpmMaterialPurchasingOrderDetailRepository.findOutStorageAbleDetailById(pageable, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void audit(List<TpmMaterialPurchasingOrderDto> dtoList) {
    }

    public TpmMaterialPurchasingOrderVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TpmMaterialPurchasingOrder entity = (TpmMaterialPurchasingOrder)((Object)this.tpmMaterialPurchasingOrderRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(entity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((boolean)tenantCode.equals(entity.getTenantCode()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        TpmMaterialPurchasingOrderVo tpmMaterialPurchasingOrderVo = (TpmMaterialPurchasingOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmMaterialPurchasingOrderVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<TpmMaterialPurchasingOrderDetailVo> detailVos = this.tpmMaterialPurchasingOrderDetailRepository.findByCode(entity.getCode());
        tpmMaterialPurchasingOrderVo.setDetailList(detailVos);
        return tpmMaterialPurchasingOrderVo;
    }

    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public TpmMaterialPurchasingOrderVo create(TpmMaterialPurchasingOrderDto dto) {
        this.createValidate(dto);
        dto.setStatus(TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue());
        TpmMaterialPurchasingOrder entity = (TpmMaterialPurchasingOrder)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmMaterialPurchasingOrder.class, HashSet.class, ArrayList.class, new String[0]));
        String tenantCode = TenantUtils.getTenantCode();
        entity.setTenantCode(tenantCode);
        String code = (String)this.generateCodeService.generateCode("WLCGD", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        AtomicInteger index = new AtomicInteger(1);
        Collection details = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getDetailList(), TpmMaterialPurchasingOrderDetailDto.class, TpmMaterialPurchasingOrderDetail.class, HashSet.class, ArrayList.class, new String[0]);
        details.forEach(e -> {
            e.setTenantCode(tenantCode);
            e.setCode(code);
            e.setSubCode(code + "-" + index.getAndIncrement());
        });
        this.tpmMaterialPurchasingOrderRepository.saveOrUpdate((Object)entity);
        this.tpmMaterialPurchasingOrderDetailRepository.saveBatch(details);
        TpmMaterialPurchasingOrderLogEventDto logEventDto = new TpmMaterialPurchasingOrderLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = TpmMaterialPurchasingOrderLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmMaterialPurchasingOrderLogEventListener.class, (SerializableBiConsumer)onCreate);
        return (TpmMaterialPurchasingOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmMaterialPurchasingOrderVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public void updateBatch(List<TpmMaterialPurchasingOrderDetailDto> tpmMaterialPurchasingOrderDetailDtoList) {
        if (CollectionUtils.isEmpty(tpmMaterialPurchasingOrderDetailDtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List<String> detailPlanItemCodeList = tpmMaterialPurchasingOrderDetailDtoList.stream().map(TpmMaterialPurchasingOrderDetailDto::getActivityDetailItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<TpmMaterialPurchasingOrderDetail> detailEntityList = this.tpmMaterialPurchasingOrderDetailRepository.findByDetailPlanItemCodeList(detailPlanItemCodeList);
        Map detailPlanItemCodeToDetailDto = tpmMaterialPurchasingOrderDetailDtoList.stream().collect(Collectors.toMap(TpmMaterialPurchasingOrderDetailDto::getActivityDetailItemCode, Function.identity(), (e1, e2) -> e1));
        detailEntityList.forEach(entity -> {
            String activityDetailItemCode = entity.getActivityDetailItemCode();
            if (detailPlanItemCodeToDetailDto.containsKey(activityDetailItemCode)) {
                TpmMaterialPurchasingOrderDetailDto item = (TpmMaterialPurchasingOrderDetailDto)detailPlanItemCodeToDetailDto.get(activityDetailItemCode);
                entity.setTenantCode(tenantCode);
                entity.setActivityDetailItemCode(item.getActivityDetailItemCode());
            }
        });
        this.tpmMaterialPurchasingOrderDetailRepository.saveOrUpdateBatch(detailEntityList);
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmMaterialPurchasingOrderVo update(TpmMaterialPurchasingOrderDto dto) {
        this.updateValidate(dto);
        TpmMaterialPurchasingOrder oldEntity = (TpmMaterialPurchasingOrder)((Object)this.tpmMaterialPurchasingOrderRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)oldEntity), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(oldEntity.getDelFlag()), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01", (Object[])new Object[0]);
        if (!TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue().equals(dto.getStatus())) {
            return new TpmMaterialPurchasingOrderVo();
        }
        Validate.notNull((Object)((Object)oldEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(oldEntity.getDelFlag()), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        TpmMaterialPurchasingOrderDto oldDto = (TpmMaterialPurchasingOrderDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, TpmMaterialPurchasingOrderDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<TpmMaterialPurchasingOrderDetailVo> detailVos = this.tpmMaterialPurchasingOrderDetailRepository.findByCode(oldEntity.getCode());
        oldDto.setDetailList((List)Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(detailVos, TpmMaterialPurchasingOrderDetailVo.class, TpmMaterialPurchasingOrderDetailDto.class, HashSet.class, ArrayList.class, new String[0])));
        String tenantCode = TenantUtils.getTenantCode();
        TpmMaterialPurchasingOrder newEntity = (TpmMaterialPurchasingOrder)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmMaterialPurchasingOrder.class, HashSet.class, ArrayList.class, new String[0]));
        Collection newDetails = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getDetailList(), TpmMaterialPurchasingOrderDetailDto.class, TpmMaterialPurchasingOrderDetail.class, HashSet.class, ArrayList.class, new String[0]);
        String code = newEntity.getCode();
        AtomicInteger index = new AtomicInteger(1);
        newDetails.forEach(e -> {
            e.setTenantCode(tenantCode);
            e.setCode(code);
            e.setSubCode(code + "-" + index.getAndIncrement());
        });
        this.tpmMaterialPurchasingOrderDetailRepository.removeByCode(oldEntity.getCode());
        this.tpmMaterialPurchasingOrderRepository.saveOrUpdate((Object)newEntity);
        this.tpmMaterialPurchasingOrderDetailRepository.saveBatch(newDetails);
        TpmMaterialPurchasingOrderLogEventDto logEventDto = new TpmMaterialPurchasingOrderLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = TpmMaterialPurchasingOrderLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, TpmMaterialPurchasingOrderLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return (TpmMaterialPurchasingOrderVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)newEntity, TpmMaterialPurchasingOrderVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void confirm(TpmMaterialPurchasingOrderDto dto) {
        this.confirmOrOutstorageOrSignValidate(dto);
        List entityList = this.tpmMaterialPurchasingOrderRepository.listByIds(dto.getIds());
        Validate.notEmpty((Collection)entityList, (String)"\u672a\u627e\u5230\u7269\u6599\u91c7\u8d2d\u5355\u4fe1\u606f", (Object[])new Object[0]);
        entityList.forEach(entity -> {
            Validate.isTrue((boolean)StringUtils.equalsAny((CharSequence)entity.getStatus(), (CharSequence[])new CharSequence[]{TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue(), TpmMaterialPurchasingOrderEnums.OrderStatus.BACK_40.getValue(), TpmMaterialPurchasingOrderEnums.OrderStatus.WAIT_EDIT.getValue()}), (String)"\u53ea\u80fd\u786e\u8ba4\u72b6\u6001\u4e3a\uff1a\u3010\u5f85\u63d0\u4ea4\u3011\u3010\u5df2\u64a4\u56de\u3011\u3010\u5f85\u4fee\u6539\u3011\u7684\u7269\u6599\u91c7\u8d2d\u5355", (Object[])new Object[0]);
            Validate.isTrue((!TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGEING.getValue().equals(entity.getChangeStatus()) || !TpmMaterialPurchasingOrderEnums.OrderChangeStatus.PART_CHANGED.getValue().equals(entity.getChangeStatus()) ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u786e\u8ba4\u91c7\u8d2d\u660e\u7ec6\u4e2d\u72b6\u6001\u6709\u3010\u8c03\u6574\u4e2d\u3001\u90e8\u5206\u8c03\u6574\u3011\u7684\u7269\u6599\u91c7\u8d2d\u5355", (Object[])new Object[0]);
            Validate.isTrue((boolean)YesOrNoEnum.YES.getCode().equals(entity.getMaterialGroupEdit()), (String)"\u7269\u6599\u7ec4\u7f16\u8f91\u5fc5\u987b\u4e3a\u662f", (Object[])new Object[0]);
        });
        ArrayList codes = Lists.newArrayList();
        Date now = new Date();
        entityList.forEach(entity -> {
            entity.setConfirmDate(now);
            entity.setStatus(TpmMaterialPurchasingOrderEnums.OrderStatus.WAIT_CONFIRM_20.getValue());
            codes.add(entity.getCode());
        });
        this.verifyDetailData(codes);
        ProcessBusinessDto processBusinessDto = dto.getProcessBusiness();
        processBusinessDto.setBusinessCode("tpm_material_purchasing_order");
        processBusinessDto.setBusinessNoList((List)codes);
        processBusinessDto.setBusinessNo(new Snowflake().nextIdStr());
        log.info("\u91c7\u8d2d\u5355\u6d41\u7a0b\u63d0\u4ea4\u53c2\u6570,{}", (Object)JSON.toJSONString((Object)processBusinessDto));
        ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusinessDto);
        entityList.forEach(entity -> entity.setProcessNo(processBusinessVo.getProcessNo()));
        this.tpmMaterialPurchasingOrderRepository.updateBatchById(entityList);
    }

    private void verifyDetailData(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        List<TpmMaterialPurchasingOrderDetail> detailList = this.tpmMaterialPurchasingOrderDetailRepository.findByCodeList(codes);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(detailList), (String)"\u91c7\u8d2d\u5355\u90fd\u672a\u7ef4\u62a4\u660e\u7ec6\u6570\u636e", (Object[])new Object[0]);
        Map<String, List<TpmMaterialPurchasingOrderDetail>> detailMap = detailList.stream().collect(Collectors.groupingBy(TpmMaterialPurchasingOrderDetail::getCode));
        for (String code : codes) {
            List<TpmMaterialPurchasingOrderDetail> detailList1 = detailMap.get(code);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(detailList1), (String)"\u91c7\u8d2d\u5355\u7f16\u7801\u3010%s\u3011\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{code});
        }
    }

    private void createValidate(TpmMaterialPurchasingOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSupplierCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List detailList = dto.getDetailList();
        Validate.noNullElements((Iterable)detailList, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        detailList.forEach(detail -> {
            Validate.notBlank((CharSequence)detail.getActivityDetailItemCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)detail.getCustomerCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)detail.getMaterialCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        });
    }

    private void confirmOrOutstorageOrSignValidate(TpmMaterialPurchasingOrderDto dto) {
        Validate.notNull((Object)dto, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getIds(), (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Transactional
    public void supplierProcessBack(List<String> businessNoList, String processStatus) {
        if (CollectionUtils.isEmpty(businessNoList)) {
            return;
        }
        List<TpmMaterialPurchasingOrderDetailVo> detailVos = this.tpmMaterialPurchasingOrderDetailRepository.findByDetailCodes(businessNoList);
        log.info("\u7269\u6599\u91c7\u8d2d\u5355\u63d0\u4ea4\u5ba1\u6279\u5ba1\u6279\u901a\u8fc7,detailVos:{}", (Object)JsonUtils.obj2JsonString(detailVos));
        this.tpmMaterialPurchasingOrderDetailRepository.supplierProcessBack(detailVos, processStatus);
        List activityDetailItemCodes = detailVos.stream().map(TpmMaterialPurchasingOrderDetailVo::getActivityDetailItemCode).collect(Collectors.toList());
        this.activityDetailPlanItemSdkService.updateActivityDetailPurchasingOrderProcessStatus(activityDetailItemCodes, processStatus);
    }

    @Transactional
    public void handleChangeStatus(List<String> materialPurchasingCodes) {
        List<TpmMaterialPurchasingOrderDetail> detailList = this.tpmMaterialPurchasingOrderDetailRepository.findByCodeList(materialPurchasingCodes);
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        Map<String, List<TpmMaterialPurchasingOrderDetail>> groupBy = detailList.stream().collect(Collectors.groupingBy(TpmMaterialPurchasingOrderDetail::getCode));
        ArrayList<TpmMaterialPurchasingOrder> mainOrderList = new ArrayList<TpmMaterialPurchasingOrder>();
        groupBy.forEach((k, v) -> {
            TpmMaterialPurchasingOrder main = new TpmMaterialPurchasingOrder();
            main.setCode((String)k);
            if (v.stream().allMatch(e -> TpmMaterialPurchasingOrderEnums.OrderChangeStatus.NOT_CHANGED.getValue().equals(e.getActivityDetailChangeStatus()))) {
                main.setChangeStatus(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.NOT_CHANGED.getValue());
            }
            if (v.stream().anyMatch(e -> TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGEING.getValue().equals(e.getActivityDetailChangeStatus())) && v.stream().anyMatch(e -> TpmMaterialPurchasingOrderEnums.OrderChangeStatus.NOT_CHANGED.getValue().equals(e.getActivityDetailChangeStatus())) && v.stream().noneMatch(e -> TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGED.getValue().equals(e.getActivityDetailChangeStatus()))) {
                main.setChangeStatus(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGEING.getValue());
            }
            if (v.stream().anyMatch(e -> TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGED.getValue().equals(e.getActivityDetailChangeStatus())) && v.stream().anyMatch(e -> TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGEING.getValue().equals(e.getActivityDetailChangeStatus())) && v.stream().anyMatch(e -> TpmMaterialPurchasingOrderEnums.OrderChangeStatus.NOT_CHANGED.getValue().equals(e.getActivityDetailChangeStatus()))) {
                main.setChangeStatus(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.PART_CHANGED.getValue());
            }
            if (v.stream().anyMatch(e -> TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGED.getValue().equals(e.getActivityDetailChangeStatus())) && v.stream().noneMatch(e -> TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGEING.getValue().equals(e.getActivityDetailChangeStatus()))) {
                main.setChangeStatus(TpmMaterialPurchasingOrderEnums.OrderChangeStatus.CHANGED.getValue());
            }
            mainOrderList.add(main);
        });
        this.tpmMaterialPurchasingOrderRepository.updateChangeStatusByCodes(mainOrderList);
    }

    public List<TpmMaterialPurchasingOrderAuditFileVo> findAuditInfoByPurchaseCodes(Set<String> purchaseCodeList) {
        if (CollectionUtils.isEmpty(purchaseCodeList)) {
            return Lists.newArrayList();
        }
        List<TpmMaterialPurchasingOrderAuditFile> auditFileList = this.auditFileRepository.findByBusinessCodes(new ArrayList<String>(purchaseCodeList));
        if (CollectionUtils.isEmpty(auditFileList)) {
            return Lists.newArrayList();
        }
        Collection tpmMaterialPurchasingOrderAuditFileVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditFileList, TpmMaterialPurchasingOrderAuditFile.class, TpmMaterialPurchasingOrderAuditFileVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)tpmMaterialPurchasingOrderAuditFileVos;
    }

    public Page<TpmMaterialPurchasingOrderAuditFileVo> auditFindMaterialAuditInfo(Pageable pageable, List<String> materialPurchasingOrders) {
        if (CollectionUtils.isEmpty(materialPurchasingOrders)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        }
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        return this.auditFileRepository.auditFindMaterialAuditInfo(pageable, materialPurchasingOrders);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchDeleteMaterialPurchaseOrder(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<TpmMaterialPurchasingOrderVo> materialPurchasingOrderVoList = this.tpmMaterialPurchasingOrderRepository.findByIds(ids);
        for (TpmMaterialPurchasingOrderVo tpmMaterialPurchasingOrderVo : materialPurchasingOrderVoList) {
            Validate.isTrue((boolean)TpmMaterialPurchasingOrderEnums.OrderStatus.TO_SUBMIT_10.getValue().equals(tpmMaterialPurchasingOrderVo.getStatus()), (String)"\u91c7\u8d2d\u5355\u3010%s\u3011\u4e0d\u4e3a\u5f85\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{tpmMaterialPurchasingOrderVo.getCode()});
        }
        List<String> codeList = materialPurchasingOrderVoList.stream().map(TpmMaterialPurchasingOrderVo::getCode).collect(Collectors.toList());
        List<TpmMaterialPurchasingOrderDetail> detailList = this.tpmMaterialPurchasingOrderDetailRepository.findByCodeList(codeList);
        if (CollectionUtils.isNotEmpty(materialPurchasingOrderVoList)) {
            List<String> codes = materialPurchasingOrderVoList.stream().map(TpmMaterialPurchasingOrderVo::getCode).collect(Collectors.toList());
            this.tpmMaterialPurchasingOrderDetailRepository.deleteByCodes(codes);
            this.tpmMaterialPurchasingOrderRepository.deleteByIds(ids);
        }
        for (TpmMaterialPurchasingOrderVo orderVo : materialPurchasingOrderVoList) {
            Map<String, List<TpmMaterialPurchasingOrderDetail>> detailMap = detailList.stream().collect(Collectors.groupingBy(TpmMaterialPurchasingOrderDetail::getCode));
            List<TpmMaterialPurchasingOrderDetail> detailList1 = detailMap.get(orderVo.getCode());
            if (CollectionUtils.isEmpty(detailList1)) {
                return;
            }
            List activityDetailItemCodes = detailList1.stream().map(TpmMaterialPurchasingOrderDetail::getActivityDetailItemCode).collect(Collectors.toList());
            this.activityDetailPlanItemSdkService.updateActivityDetailPurchasingOrder(orderVo.getCode(), null, activityDetailItemCodes);
        }
    }
}

