package com.biz.crm.tpm.business.material.purchasing.order.sdk.dto;

import com.biz.crm.business.common.sdk.dto.FileDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 物料采购单-核销文件 dto
 *
 * @author zy
 * @create 2023/09/18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrderAuditFileDto", description = "TPM-物料采购单-核销文件")
public class TpmMaterialPurchasingOrderAuditFileDto extends FileDto {


    /**
     * 业务编码
     */
    @ApiModelProperty(name = "业务编码", notes = "业务编码")
    private String businessCode;

    /**
     * 业务名称
     */
    @ApiModelProperty(name = "业务名称", notes = "业务名称")
    private String businessName;

    /**
     * 类型编码
     */
    @ApiModelProperty(name = "类型编码", notes = "类型编码")
    private String typeCode;


}
