package com.biz.crm.tpm.business.material.purchasing.order.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 物料采购单-核销发票 dto
 *
 * @author zy
 * @create 2023-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrderAuditInvoiceDto", description = "TPM-物料采购单-主表")
public class TpmMaterialPurchasingOrderAuditInvoiceDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "物料采购单编码", notes = "核销code")
    private String code;

    @ApiModelProperty(name = "业态", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "发票类型", notes = "发票类型")
    private String invoiceType;

    @ApiModelProperty(name = "发票类型名称", notes = "发票类型名称")
    private String invoiceTypeName;

    @ApiModelProperty(name = "发票代码", notes = "发票代码")
    private String invoiceCode;

    @ApiModelProperty(name = "发票号码", notes = "发票号码")
    private String invoiceNumber;

    @ApiModelProperty("发票明细id")
    private String invoiceItemId;

    @ApiModelProperty(name = "开票日期", notes = "开票日期")
    private String invoiceDate;

    @ApiModelProperty(name = "校验码", notes = "校验码")
    private String verifyCode;

    @ApiModelProperty("购买方名称")
    private String buyerName;

    @ApiModelProperty(name = "购买方纳税人识别号", notes = "购买方纳税人识别号")
    private String buyerTaxpayerIdentifyNumber;

    @ApiModelProperty(name = "购买方地址、电话", notes = "购买方地址、电话")
    private String buyerAddressAndPhone;

    @ApiModelProperty(name = "购买方开户行及账户", notes = "购买方开户行及账户")
    private String buyerOpenAccountBankAndAccount;

    @ApiModelProperty(name = "销售方名称", notes = "销售方名称")
    private String sellerName;

    @ApiModelProperty(name = "销售方纳税人识别号", notes = "销售方纳税人识别号")
    private String sellerTaxpayerIdentifyNumber;

    @ApiModelProperty(name = "销售方地址、电话", notes = "销售方地址、电话")
    private String sellerAddressAndPhone;

    @ApiModelProperty(name = "销售方方开户行及账户", notes = "销售方方开户行及账户")
    private String sellerOpenAccountBankAndAccount;

    @ApiModelProperty(name = "发票金额（含税）", notes = "发票金额（含税）")
    private BigDecimal invoiceTaxAmount;

    @ApiModelProperty(name = "发票金额（未税）", notes = "发票金额（未税）")
    private BigDecimal invoiceAmount;

    @ApiModelProperty(name = "税额（元）", notes = "税额（元）")
    private BigDecimal taxAmount;

    @ApiModelProperty(name = "税率", notes = "税率")
    private String taxRate;

    @ApiModelProperty(name = "税费科目", notes = "税费科目")
    private String taxSubject;

    @ApiModelProperty(name = "税费科目名称", notes = "税费科目名称")
    private String taxSubjectName;

    @ApiModelProperty("进转出金额")
    private BigDecimal changeAmount;

    @ApiModelProperty(name = "活动明细编码", notes = "活动明细编码")
    private String activityDetailCode;

    @ApiModelProperty(name = "发票使用金额")
    private BigDecimal invoiceUseAmount;

    @ApiModelProperty(name = "使用金额税额")
    private BigDecimal useAmountTax;

    @ApiModelProperty(name = "使用金额未税")
    private BigDecimal useAmountNotTax;

    @ApiModelProperty(name = "税差")
    private BigDecimal taxRates;

    @ApiModelProperty("货物或应税劳务名称")
    private String goodsTaxableName;

    @ApiModelProperty("是否选中，0否1是")
    private String checked;
}
