package com.biz.crm.tpm.business.material.purchasing.order.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * 物料采购单-明细 dto
 *
 * @author duyiran
 * @create 2022-11-07 19:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrderDetailDto", description = "TPM-物料采购单-明细表")
public class TpmMaterialPurchasingOrderDetailDto extends TenantFlagOpDto {

    @ApiModelProperty("审批编号")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty(name = "审批状态", notes = "审批状态")
    private String detailStatus;

    /**
     * 采购单编码
     */
    @ApiModelProperty(name = "采购单编码", notes = "采购单编码")
    private String code;

    @ApiModelProperty("细案明细编码")
    private List<String> activityDetailItemList;

    /**
     * 采购单详情编码
     */
    @ApiModelProperty(name = "采购单详情编码", notes = "采购单详情编码")
    private String detailCode;

    /**
     * 采购单明细编码
     */
    @ApiModelProperty(name = "采购单明细编码", notes = "采购单明细编码")
    private String subCode;

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty(name = "活动细案明细编码", notes = "活动细案明细编码")
    private String activityDetailItemCode;

    /**
     * 活动细案编码
     */
    @ApiModelProperty(name = "活动细案编码", notes = "活动细案编码")
    private String activityDetailPlanCode;

    /**
     * 活动细案名称
     */
    @ApiModelProperty(name = "活动细案名称", notes = "活动细案名称")
    private String activityDetailPlanName;

    /**
     * 活动细案调整状态
     */
    @ApiModelProperty(name = "活动细案调整状态", notes = "活动细案调整状态")
    private String activityDetailChangeStatus;

    /**
     * 签收状态
     */
    @ApiModelProperty(name = "签收状态", notes = "签收状态")
    private String receivingStatus;

    /**
     * 销售部门
     */
    @ApiModelProperty(name = "销售部门" ,notes = "销售部门")
    private String salesOrgName;

    /**
     * 销售部门编码
     */
    @ApiModelProperty(name = "销售部门", notes = "销售部门编码")
    private String salesOrgCode;

    /**
     * 送货市场
     */
    @ApiModelProperty(name = "送货市场",notes = "送货市场")
    private String deliveryDealer;

    /**
     * 物料使用品类
     */
    @ApiModelProperty(name = "物料使用品类",notes = "物料使用品类")
    private String materialCategory;

    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    private String supplierCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty(name = "供应商名称", notes = "供应商名称")
    private String supplierName;

    /**
     * 物料编码
     */
    @ApiModelProperty(name = "物料编码", notes = "物料编码")
    private String materialCode;

    /**
     * 物料名称
     */
    @ApiModelProperty(name = "物料名称", notes = "物料名称")
    private String materialName;

    /**
     * 装箱数
     */
    @ApiModelProperty(name = "装箱数", notes = "装箱数")
    private BigDecimal packingBoxNumber;

    /**
     * 单位
     */
    @ApiModelProperty(name = "单位",notes = "单位")
    private String unit;

    /**
     * 物料基本工艺标准
     */
    @ApiModelProperty(name = "物料基本工艺标准",notes = "物料基本工艺标准")
    private String materialBaseStandard;

    /**
     * 采购数量
     */
    @ApiModelProperty(name = "采购数量",notes = "采购数量")
    private BigDecimal purchasingQuantity;

    /**
     * 金额
     */
    @ApiModelProperty(name = "金额", notes = "金额")
    private BigDecimal amount;

    /**
     * 发货单位
     */
    @ApiModelProperty(name = "发货单位",notes = "发货单位")
    private String deliveryCompany;

    /**
     * 微信号
     */
    @ApiModelProperty(name = "微信号",notes = "微信号")
    private String weixinNo;

    /**
     * 发货方联系人
     */
    @ApiModelProperty(name = "发货方联系人",notes = "发货方联系人")
    private String deliveryContacts;

    /**
     * 发货方联系电话
     */
    @ApiModelProperty(name = "发货方联系电话",notes = "发货方联系电话")
    private String deliveryPhone;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    /**
     * 收货地址
     */
    @ApiModelProperty(name = "收货地址", notes = "收货地址")
    private String recipientAddress;

    /**
     * 收货联系人
     */
    @ApiModelProperty(name = "收货联系人", notes = "收货联系人")
    private String recipientContacts;

    /**
     * 收货联系电话
     */
    @ApiModelProperty(name = "收货联系电话", notes = "收货联系电话")
    private String recipientPhone;

    /**
     * 发货时间
     */
    @ApiModelProperty(name = "发货时间", notes = "发货时间")
    private String deliveryDate;

    /**
     * 收货时间
     */
    @ApiModelProperty(name = "收货时间", notes = "收货时间")
    private String recipientDate;

    /**
     * 发货数量
     */
    @ApiModelProperty(name = "发货数量", notes = "发货数量")
    private BigDecimal deliveryQuantity;

    /**
     * 已发货数量
     */
    @ApiModelProperty(name = "已发货数量", notes = "已发货数量")
    private BigDecimal alreadyDeliveryQuantity;

    /**
     * 发货金额（已发货数量*金额）
     */
    @ApiModelProperty(name = "发货金额", notes = "发货金额")
    private BigDecimal deliveryAmount;

    /**
     * 签收数量
     */
    @ApiModelProperty(name = "签收数量", notes = "签收数量")
    private BigDecimal receivingQuantity;

    /**
     * 签收金额
     */
    @ApiModelProperty(name = "签收金额", notes = "签收金额")
    private BigDecimal receivingAmount;

    @ApiModelProperty("合同id")
    private String contractId;

    @ApiModelProperty("文档id")
    private String documentsId;

    @ApiModelProperty(name = "物料采购单文件列表(签收单)", notes = "物料采购单文件列表(签收单)")
    private List<TpmMaterialPurchasingOrderFileDto> fileList;

    @ApiModelProperty("是否选中，0否1是")
    private String checked;

    private String cacheKey;

    /**
     * 签收时间
     */
    @ApiModelProperty(name = "签收时间", notes = "签收时间")
    private String receivingDate;
}
