package com.biz.crm.tpm.business.material.purchasing.order.sdk.dto;

import com.biz.crm.business.common.sdk.dto.FileDto;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 物料采购单-明细文件 dto
 *
 * @author zy
 * @create 2023/09/18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrderFileDto", description = "TPM-物料采购单-明细文件")
public class TpmMaterialPurchasingOrderFileDto extends FileDto {


    /**
     * 业务编码
     */
    @ApiModelProperty(name = "业务编码", notes = "业务编码")
    private String businessCode;

    /**
     * 文件类型
     */
    @ApiModelProperty(name = "fileType",value = "文件类型",notes = "文件类型")
    private String fileType;

}
