package com.biz.crm.tpm.business.material.purchasing.order.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;


/**
 * 物料采购单-查询客户 dto
 *
 * @author duyiran
 * @create 2022-11-07 19:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrderfindCustomerDto", description = "TPM-物料采购单-查询客户")
public class TpmMaterialPurchasingOrderfindCustomerDto extends TenantFlagOpDto {

    /**
     * 编码
     */
    @ApiModelProperty(name = "编码", notes = "编码")
    private String code;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    /**
     * 收货地址
     */
    @ApiModelProperty(name = "收货地址", notes = "收货地址")
    private String recipientAddress;

    /**
     * 要修改的客户编码集合
     */
    @ApiModelProperty(name = "要修改的客户编码集合", notes = "要修改的客户编码集合")
    private List<String> customerCodeList;

}
