package com.biz.crm.tpm.business.material.purchasing.order.sdk.enums;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 第三方电子签章状态枚举
 *
 * @author liuyifan
 * @date 2023/02/27
 */
public enum ThirdReconciliationStatusEnum {
    //DRAFT：草稿，FILLING：拟定中，SIGNING：签署中，COMPLETE：已完成，REJECTED：已退回，RECALLED：已撤回，EXPIRED：已过期，TERMINATING：作废中，TERMINATED：已作废，DELETE：已删除，FINISHED：强制完成）

    WAIT("0000","DRAFT","待推送"),
    CONFIRMED("0001", "SIGNING","待客户确认"),
    COMPLETE("0002","COMPLETE","完成"),
    FAIL("0003","FINISHED","失败"),
    WITHDRAW("0004","RECALLED","撤回"),
    SCRAP("0005","TERMINATED","作废")
    ;



    @EnumValue
    @JsonValue
    private String code;
    private String thirdCode;
    private String des;

    private ThirdReconciliationStatusEnum(String code, String thirdCode, String des) {
        this.code = code;
        this.des = des;
        this.thirdCode = thirdCode;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }


    public String getThirdCode() {
        return this.thirdCode;
    }



    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        ThirdReconciliationStatusEnum[] var1 = values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            ThirdReconciliationStatusEnum calculationRulesEnum = var1[var3];
            codes.add(calculationRulesEnum.getCode());
        }

        return codes;
    }

    public static String findByThirdCode(String thirdCode) {
        ThirdReconciliationStatusEnum calculationRules = null;
        ThirdReconciliationStatusEnum[] var2 = values();
        int var3 = var2.length;

        for(int var4 = 0; var4 < var3; ++var4) {
            ThirdReconciliationStatusEnum calculationRulesEnum = var2[var4];
            if (calculationRulesEnum.thirdCode.equals(thirdCode)) {
                calculationRules = calculationRulesEnum;
            }
        }
        if (calculationRules == null){
            return StrUtil.EMPTY;
        }
        return calculationRules.code;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            ThirdReconciliationStatusEnum[] values = values();
            ThirdReconciliationStatusEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                ThirdReconciliationStatusEnum value = var2[var4];
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }

        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        } else {
            ThirdReconciliationStatusEnum[] values = values();
            ThirdReconciliationStatusEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                ThirdReconciliationStatusEnum value = var2[var4];
                if (value.getCode().equals(code)) {
                    return true;
                }
            }

            return false;
        }
    }
}
