package com.biz.crm.tpm.business.material.purchasing.order.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author duyiran
 * @create 2022-11-14 15:34
 */
public class TpmMaterialPurchasingOrderEnums {

    /**
     * 单据业务状态方式
     */
    @Getter
    @AllArgsConstructor
    public enum OrderStatus {
        TO_SUBMIT_10("10", "待提交"),
        WAIT_CONFIRM_20("20","待确认"),
        CONFIRM_30("30","已确认"),
        BACK_40("40","已撤回"),
        WAIT_EDIT("50", "待修改")
        ;

        private String value;
        private String desc;

    }

    /**
     * 单据业务调整状态方式
     */
    @Getter
    @AllArgsConstructor
    public enum OrderChangeStatus {
        CHANGEING("10", "调整中"),
        CHANGED("20", "已调整"),
        NOT_CHANGED("30", "未调整"),
        PART_CHANGED("40", "部分调整")
        ;

        private String value;
        private String desc;

    }

    /**
     * 单据来源
     */
    @Getter
    @AllArgsConstructor
    public enum OrderSource {
        ACTIVITYDETAIL("ActivityDetail", "活动细案"),
        SUBACTIVITYDETAIL("SubActivityDetail", "分子公司活动细案");

        private String value;
        private String desc;

    }

    /**
     * 采购类型
     */
    @Getter
    @AllArgsConstructor
    public enum IsTypeOfPurchaseNo {
        unifiedPurchasing("unifiedPurchasing", "总部统采"),
        customerSelfProcurement("customerSelfProcurement", "客户自采"),
        subsidiariesUnifiedPurchase("subsidiariesUnifiedPurchase", "分子公司统采");

        private String value;
        private String desc;

    }

    /**
     * 采购类型
     */
    @Getter
    @AllArgsConstructor
    public enum ReceiveStatus {
        WAIT_RECEIVE("10", "待出库"),
        RECEIVED("20", "已出库"),
        PORTIAL_RECEIVE("30", "部分出库"),
        DELIVERIED("40", "已签收"),
        PORTIAL_DELIVERIED("50", "部分签收"),
        ;

        private String value;
        private String desc;

    }

    /**
     * 文件类型
     */
    @Getter
    @AllArgsConstructor
    public enum FileType {
        CONFIRM("10", "确认表"),
        RECEIVE("20", "签收单"),
        ;

        private String value;
        private String desc;

    }

    /**
     * 文件类型
     */
    @Getter
    @AllArgsConstructor
    public enum AuditFileTypeCode {
        DELIVERY("10", "发货明细及结案表汇总"),
        CONTRACT("20", "合同"),
        CONFIRM("30", "订单确认表"),
        CHACK_PORT("40", "检验报告"),
        SIGN("50", "签收单"),
        INVOICE("60", "发票扫描件"),
        ;

        private String value;
        private String desc;

    }

}
