package com.biz.crm.tpm.business.material.purchasing.order.sdk.event.log;

import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.log.TpmMaterialPurchasingOrderLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author duyiran
 * @date 2022年10月26日 14:15
 */
public interface TpmMaterialPurchasingOrderLogEventListener extends NebulaEvent {
    /**
     * 创建预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onCreate(TpmMaterialPurchasingOrderLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onDelete(TpmMaterialPurchasingOrderLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onUpdate(TpmMaterialPurchasingOrderLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onEnable(TpmMaterialPurchasingOrderLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto dto
     * @author duyiran
     * @date 2022/10/24 17:10
     **/
    void onDisable(TpmMaterialPurchasingOrderLogEventDto dto);
}
