package com.biz.crm.tpm.business.material.purchasing.order.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDetailDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.dto.TpmMaterialPurchasingOrderfindCustomerDto;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.*;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;


/**
 * TPM-物料采购单(TpmMaterialPurchasingOrder)表服务接口
 *
 * @author duyiran
 * @since 2022-11-12 17:55:49
 */
public interface TpmMaterialPurchasingOrderService {

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      dto对象
     * @return
     */
    Page<TpmMaterialPurchasingOrderVo> findByConditions(Pageable pageable, TpmMaterialPurchasingOrderDto dto);

    /**
     * 保存活动细案的物料采购单
     *
     * @param tpmMaterialPurchasingOrderDtoList tpmMaterialPurchasingOrderDtoList
     */
    void saveBatch(List<TpmMaterialPurchasingOrderDto> tpmMaterialPurchasingOrderDtoList);

    /**
     * 分页查询数据（核销用）
     *
     * @param pageable 分页对象
     * @param dto      dto对象
     * @return
     */
    Page<TpmMaterialPurchasingOrderVo> findByConditionsForAuditPage(Pageable pageable, TpmMaterialPurchasingOrderDto dto);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    TpmMaterialPurchasingOrderVo findById(String id);

    /**
     * 新增数据
     *
     * @param dto dto对象
     * @return 新增结果
     */
    TpmMaterialPurchasingOrderVo create(TpmMaterialPurchasingOrderDto dto);

    /**
     * 修改新据
     *
     * @param dto dto对象
     * @return 修改结果
     */
    TpmMaterialPurchasingOrderVo update(TpmMaterialPurchasingOrderDto dto);

    /**
     * 采购单确认
     *
     * @param dto dto
     * @return 确认结果
     */
    void confirm(TpmMaterialPurchasingOrderDto dto);

    /**
     * 查询数据（后端用）
     *
     * @param dto dto对象
     * @return
     */
    List<TpmMaterialPurchasingOrderVo> findByConditionsForJava(TpmMaterialPurchasingOrderDto dto);

    /**
     * 分页查询当前采购单所有客户
     *
     * @param pageable 分页对象
     * @param dto      查询dto
     * @return 所有数据
     */
    Page<TpmMaterialPurchasingOrderFindCustomerVo> findCustomerByCode(Pageable pageable, TpmMaterialPurchasingOrderfindCustomerDto dto);

    /**
     * 修改客户地址
     *
     * @param dto dto
     */
    void editCustomerAddressById(TpmMaterialPurchasingOrderfindCustomerDto dto);

    /**
     * 完成出库
     *
     * @param dto dto
     */
    void finishOutStorage(TpmMaterialPurchasingOrderDto dto);

    /**
     * 分页查询当前采购单所有可发货明细
     *
     * @param pageable 分页对象
     * @param dto      查询dto
     * @return 所有数据
     */
    Page<TpmMaterialPurchasingOrderDetailVo> findOutStorageAbleDetailById(Pageable pageable, TpmMaterialPurchasingOrderDto dto);

    /**
     * 结案核销修改 已结案金额、是否完全结案状态
     */
    void audit(List<TpmMaterialPurchasingOrderDto> dto);



    /**
     * 保存活动细案的物料采购单
     *
     * @param tpmMaterialPurchasingOrderDtoList tpmMaterialPurchasingOrderDtoList
     */
    void updateBatch(List<TpmMaterialPurchasingOrderDetailDto> tpmMaterialPurchasingOrderDtoList);

    /**
     * 分页查询所有明细（核销用）
     *
     * @param pageable 分页对象
     * @param dto      查询dto
     * @return 所有数据
     */
    Page<TpmMaterialPurchasingOrderDetailVo> findDetailListByCodeForAuditPage(Pageable pageable, TpmMaterialPurchasingOrderDto dto);

    /**
     * 添加详情
     * @param dto
     */
    void addDetailList(TpmMaterialPurchasingOrderDto dto);

    /**
     * 根据编码更新审批状态
     * @param codes
     * @param status
     */
    void processBack(List<String> codes, String status);

    /**
     * 物料组编辑
     * @param dto
     */
    void materialGroupUpdate(TpmMaterialPurchasingOrderDto dto);

    /**
     * 供应商编辑
     * @param dto
     */
    void supplierUpdate(TpmMaterialPurchasingOrderDto dto);

    /**
     * 出库确认
     */
    void outConfirm(TpmMaterialPurchasingOrderDto dto);

    /**
     * 批量下载订单确认表
     * @param ids
     * @return
     */
    List<TpmMaterialPurchasingOrderFileVo> downloadOrderConfirmBatch(List<String> ids);

    /**
     * 出库单撤回
     */
    void outCancel(TpmMaterialPurchasingOrderDto dto);

    /**
     * 出库单催签
     */
    void outExpediting(TpmMaterialPurchasingOrderDto dto);

    /**
     * 批量下载签收单
     * @param ids
     * @return
     */
    List<TpmMaterialPurchasingOrderFileVo> downloadOutConfirmBatch(List<String> ids);

    /**
     * 根据详情id查询
     * @param id
     * @return
     */
    TpmMaterialPurchasingOrderDetailVo findDetailById(String id);

    /**
     * 上传签收单
     * @param dto
     */
    void uploadOutConfirm(TpmMaterialPurchasingOrderDetailDto dto);

    /**
     * 提交审批
     * @param dto
     */
    void submitProcess(TpmMaterialPurchasingOrderDto dto);

    /**
     * 上传核销资料
     * @param dto
     */
    void updateAuditFile(TpmMaterialPurchasingOrderDto dto);

    /**
     * 查询核销资料
     * @param id
     * @return
     */
    TpmMaterialPurchasingOrderVo getAuditFile(String id);

    /**
     * 供应商提交流程 回调
     * @param businessNoList
     * @param processStatus
     */
    void supplierProcessBack(List<String> businessNoList, String processStatus);

    /**
     * 针对本次修改的明细对应的采购单做一个状态计算
     * @param materialPurchasingCodes
     */
    void handleChangeStatus(List<String> materialPurchasingCodes);

    List<TpmMaterialPurchasingOrderAuditFileVo> findAuditInfoByPurchaseCodes(Set<String> purchaseCodeList);

    Page<TpmMaterialPurchasingOrderAuditFileVo> auditFindMaterialAuditInfo(Pageable pageable,List<String> materialPurchasingOrders);

    /**
     * 批量删除物料采购单
     * @param ids
     */
    void batchDeleteMaterialPurchaseOrder(List<String> ids);
}

