package com.biz.crm.tpm.business.material.purchasing.order.sdk.utils;


import cn.hutool.core.util.NumberUtil;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.tool.xml.ElementHandler;
import com.itextpdf.tool.xml.Writable;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.itextpdf.tool.xml.pipeline.WritableElement;

import java.io.*;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

/**
 * @author LiuYiFan
 */
public class PdfUtil {
    // 标准字体
    public static Font NORMALFONT;
    // 加粗字体
    public static Font BOLDFONT;
    //固定高
    public static float fixedHeight = 25f;
    //间距
    public static int spacing = 5;

    static {
        try {
            BaseFont bfChinese = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", BaseFont.NOT_EMBEDDED);
            NORMALFONT = new Font(bfChinese, 10, Font.NORMAL);
            BOLDFONT = new Font(bfChinese, 14, Font.BOLD);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static Document createDocument() {
        //生成pdf
        Document document = new Document();
        // 页面大小
        Rectangle rectangle = new Rectangle(PageSize.A4);
        // 页面背景颜色
        rectangle.setBackgroundColor(BaseColor.WHITE);
        document.setPageSize(rectangle);
        // 页边距 左，右，上，下
        document.setMargins(40, 40, 20, 20);
        return document;
    }


    /**
     * @param text 段落内容
     * @return
     */
    public static Paragraph createParagraph(String text, Font font) {
        Paragraph elements = new Paragraph(text, font);
        elements.setSpacingBefore(5);
        elements.setSpacingAfter(5);
        elements.setSpacingAfter(spacing);
        return elements;
    }


    public static Font createFont(int fontNumber, int fontSize, BaseColor fontColor) {
        //中文字体 ----不然中文会乱码
        BaseFont bf = null;
        try {
            bf = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", BaseFont.NOT_EMBEDDED);
            return new Font(bf, fontNumber, fontSize, fontColor);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new Font(bf, Font.DEFAULTSIZE, Font.NORMAL, BaseColor.BLACK);
    }

    /**
     * 隐藏表格边框线
     *
     * @param cell 单元格
     */
    public static void disableBorderSide(PdfPCell cell) {
        if (cell != null) {
            cell.disableBorderSide(1);
            cell.disableBorderSide(2);
            cell.disableBorderSide(4);
            cell.disableBorderSide(8);
        }
    }


    /**
     * 创建居中得单元格
     *
     * @return
     */
    public static PdfPCell createCenterPdfPCell() {
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setHorizontalAlignment(Element.ALIGN_CENTER);
        cell.setFixedHeight(fixedHeight);
        return cell;
    }

    /**
     * 创建指定文字得单元格
     *
     * @param text
     * @return
     */
    public static PdfPCell createCenterPdfPCell(String text, int rowSpan, int colSpan, Font font) {
        PdfPCell cell = new PdfPCell(new Paragraph(text, font));
        cell.setVerticalAlignment(Element.ALIGN_CENTER);
        cell.setHorizontalAlignment(Element.ALIGN_CENTER);
        cell.setFixedHeight(fixedHeight);
        cell.setRowspan(rowSpan);
        cell.setColspan(colSpan);
        return cell;
    }

    /**
     * @param len 表格列数
     * @return
     */
    public static PdfPTable createPdfPTable(int len) {
        PdfPTable pdfPTable = new PdfPTable(len);
        pdfPTable.setSpacingBefore(2);
        pdfPTable.setHorizontalAlignment(Element.ALIGN_CENTER);
        return pdfPTable;
    }

    /**
     * @param size 单个表格占比
     * @return
     */
    public static PdfPTable createPdfPTable(List<String> size) {
        //构建表单
        //  构建表单 - 获取自适应占比
        List<Float> floatList = new ArrayList<>();
        for (String s : size) {
            BigDecimal rate = NumberUtil.div(new BigDecimal(s.length()), new BigDecimal(3), 1, RoundingMode.HALF_UP);
            floatList.add(rate.floatValue());
        }

        float[] floatArray = new float[floatList.size()];
        int i = 0;
        for (Float f : floatList) {
            floatArray[i++] = (f != null ? f : Float.NaN); // Or whatever default you want.
        }
        PdfPTable pdfPTable = new PdfPTable(floatArray);
        pdfPTable.setSpacingBefore(2);
        pdfPTable.setHorizontalAlignment(Element.ALIGN_CENTER);
        pdfPTable.setWidthPercentage(94f);
        return pdfPTable;
    }

    /**
     方法中传入的参数分别为
     filePath:为生成的file文件地址，地址后要以\（File.separator）结尾，
     fileName：为生成的file文件名称
     **/
    public static File fileToBytes(byte[] bytes, String filePath, String fileName) {
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {

            file = new File(filePath + fileName);
            if (!file.getParentFile().exists()){
                //文件夹不存在 生成
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }


    /**
     * 解析html段落
     *
     * @param str str
     * @return {@link Paragraph}
     * @throws IOException ioexception
     */
    public static Paragraph parseHtmlToParagraph(String str) throws IOException {
        StringReader body = new StringReader(str);
        final Paragraph para = new Paragraph();

        XMLWorkerHelper.getInstance().parseXHtml(new ElementHandler() {
            @Override
            public void add(Writable w) {
                if (w instanceof WritableElement) {
                    List<Element> elements = ((WritableElement) w).elements();
                    for (Element e : elements) {
                        para.add(e);
                    }
                }
            }
        }, body);

        return para;
    }

}

