package com.biz.crm.tpm.business.material.purchasing.order.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 查询客户 vo
 *
 * @author duyiran
 * @create 2022-11-07 19:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrderFindCustomerVo", description = "TPM-物料采购单-查询客户")
public class TpmMaterialPurchasingOrderFindCustomerVo extends TenantFlagOpVo {

    /**
     * 编码
     */
    @ApiModelProperty(name = "编码", notes = "编码")
    private String code;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    /**
     * 收货地址
     */
    @ApiModelProperty(name = "收货地址", notes = "收货地址")
    private String recipientAddress;

}
