package com.biz.crm.tpm.business.material.purchasing.order.sdk.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author: zhouyang
 * @date: 2023/09/22
 * @description: 物料采购单明细供应商导出
 */
@Data
@CrmExcelExport
public class TpmMaterialPurchasingOrderMaterialGroupExportsVo extends CrmExcelVo {

    /**
     * 主键
     */
    @CrmExcelColumn("主键")
    private String id;

    /**
     * 物料编码
     */
    @CrmExcelColumn("物料编码")
    private String materialCode;

    @ApiModelProperty(name = "物料名称", notes = "物料名称")
    @CrmExcelColumn("物料名称")
    private String materialName;

    /**
     * 销售部门
     */
    @CrmExcelColumn("销售部门")
    private String salesOrgName;

    /**
     * 送货市场
     */
    @CrmExcelColumn("送货市场")
    private String deliveryDealer;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 收货地址
     */
    @CrmExcelColumn("收货地址")
    private String recipientAddress;

    /**
     * 收货联系人
     */
    @CrmExcelColumn("收货联系人")
    private String recipientContacts;

    /**
     * 收货联系电话
     */
    @CrmExcelColumn("收货联系电话")
    private String recipientPhone;

    @ApiModelProperty(name = "采购数量",notes = "采购数量")
    @CrmExcelColumn("采购数量")
    private BigDecimal purchasingQuantity;

    /**
     * 发货时间
     */
    @CrmExcelColumn("发货时间")
    private String deliveryDateStr;

    /**
     * 收货时间
     */
    @CrmExcelColumn("收货时间")
    private String recipientDateStr;

    /**
     * 发货数量
     */
    @CrmExcelColumn("发货数量")
    private BigDecimal deliveryQuantity;

    /**
     * 签收数量
     */
    @CrmExcelColumn("签收数量")
    private BigDecimal receivingQuantity;

    /**
     * 签收状态
     */
    @CrmExcelColumn("签收状态")
    private String receivingStatus;

    /**
     * 采购单详情编码
     */
    @CrmExcelColumn("采购单详情编码")
    private String detailCode;

    /**
     * 物料使用品类
     */
    @CrmExcelColumn("物料使用品类")
    private String materialCategory;

    /**
     * 装箱数
     */
    @CrmExcelColumn("装箱数")
    private BigDecimal packingBoxNumber;

    /**
     * 单位
     */
    @CrmExcelColumn("单位")
    private String unit;

    /**
     * 物料基本工艺标准
     */
    @CrmExcelColumn("物料基本工艺标准")
    private String materialBaseStandard;

    /**
     * 发货单位
     */
    @CrmExcelColumn("发货单位")
    private String deliveryCompany;

    /**
     * 微信号
     */
    @CrmExcelColumn("微信号")
    private String weixinNo;

    /**
     * 发货方联系人
     */
    @CrmExcelColumn("发货方联系人")
    private String deliveryContacts;

    /**
     * 发货方联系电话
     */
    @CrmExcelColumn("发货方联系电话")
    private String deliveryPhone;

    /**
     * 活动细案明细编码
     */
    @ExcelIgnore
    private String activityDetailItemCode;

    /**
     * 活动细案调整状态
     */
    @ExcelIgnore
    private String activityDetailChangeStatus;

    /**
     * 金额
     */
    @ExcelIgnore
    private BigDecimal amount;

    @ExcelIgnore
    private String deliveryDate;

    @ExcelIgnore
    private String recipientDate;

    @ExcelIgnore
    private String createName;

    @ExcelIgnore
    private String  createTimeStr;

    @ExcelIgnore
    private Date createTime;

    @ExcelIgnore
    private String modifyName;

    @ExcelIgnore
    private String modifyTimeStr;

    @ExcelIgnore
    private Date modifyTime;

}
