package com.biz.crm.tpm.business.material.purchasing.order.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * vo
 *
 * @author duyiran
 * @create 2022-11-07 19:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmMaterialPurchasingOrderVo", description = "TPM-物料采购单")
public class TpmMaterialPurchasingOrderVo extends TenantFlagOpVo {

    @ApiModelProperty("审批编号")
    private String processNo;

    /**
     * 编码
     */
    @ApiModelProperty(name = "编码", notes = "编码")
    private String code;

    /**
     * 状态[数据字典:tpm_material_purchasing_order_status]
     */
    @ApiModelProperty(name = "状态[数据字典:tpm_material_purchasing_order_status]", notes = "状态[数据字典:tpm_material_purchasing_order_status]")
    private String status;

    /**
     * 调整状态
     */
    @ApiModelProperty(name = "调整状态", notes = "调整状态")
    private String changeStatus;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 供应商编码
     */
    @ApiModelProperty(name = "供应商编码", notes = "供应商编码")
    private String supplierCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty(name = "供应商名称", notes = "供应商名称")
    private String supplierName;

    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    private String materialCode;

    /**
     * 物料名称
     */
    @ApiModelProperty("物料名称")
    private String materialName;

    /**
     * 合同单价
     */
    @ApiModelProperty("合同单价")
    private BigDecimal contractPrice;

    /**
     * 采购单数量
     */
    @ApiModelProperty(name = "采购单数量", notes = "采购单数量")
    private BigDecimal quantity;

    /**
     * 采购单金额（元）
     */
    @ApiModelProperty(name = "采购单金额（元）", notes = "采购单金额（元）")
    private BigDecimal amount;

    /**
     * 发货数量
     */
    @ApiModelProperty(name = "发货数量", notes = "发货数量")
    private BigDecimal deliveryQuantity;

    /**
     * 发货金额（元）
     */
    @ApiModelProperty(name = "发货金额（元）", notes = "发货金额（元）")
    private BigDecimal deliveryAmount;

    /**
     * 签收数量
     */
    @ApiModelProperty(name = "签收数量", notes = "签收数量")
    private BigDecimal receivingQuantity;

    /**
     * 签收金额（元）
     */
    @ApiModelProperty(name = "签收金额（元）", notes = "签收金额（元）")
    private BigDecimal receivingAmount;

    /**
     * 创建人组织
     */
    @ApiModelProperty("创建人组织")
    private String createUserOrg;

    /**
     * 供应商组织
     */
    @ApiModelProperty("供应商组织")
    private String supplierOrg;

    /**
     * 确认时间
     */
    @ApiModelProperty(name = "确认时间", notes = "确认时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date confirmDate;

    /**
     * 到货时间要求
     */
    @ApiModelProperty("到货时间要求")
    private String deliveryDateAsk;

    /**
     * 追样/签收时间
     */
    @ApiModelProperty("追样/签收时间")
    private String nodeReceiveDate;

    /**
     * 模具完成时间
     */
    @ApiModelProperty("模具完成时间")
    private String nodeMoldDate;

    /**
     * 大货样送达时间
     */
    @ApiModelProperty("大货样送达时间")
    private String nodeSendedDate;

    /**
     * 日产能时间
     */
    @ApiModelProperty("日产能时间")
    private String nodeCapacityDate;

    /**
     * 开始发货时间
     */
    @ApiModelProperty("开始发货时间")
    private String nodeStartDeliveryDate;

    /**
     * 结案材料提交时间
     */
    @ApiModelProperty("结案材料提交时间")
    private String nodeEndCaseDate;

    /**
     * 联系电话
     */
    @ApiModelProperty(name = "联系电话", notes = "联系电话")
    private String phone;

    /**
     * 物料基本工艺标准
     */
    @ApiModelProperty(name = "物料基本工艺标准",notes = "物料基本工艺标准")
    private String materialBaseStandard;

    @ApiModelProperty("是否完全结案")
    private String wholeAudit;

    @ApiModelProperty("已结案金额")
    private BigDecimal alreadyAuditAmount;

    @ApiModelProperty("提交时间")
    private String submitTime;

    @ApiModelProperty(name = "物料采购单明细列表", notes = "物料采购单明细列表")
    private List<TpmMaterialPurchasingOrderDetailVo> detailList;

    @ApiModelProperty(name = "物料采购单核销文件列表", notes = "物料采购单核销文件列表")
    private List<TpmMaterialPurchasingOrderAuditFileVo> auditFileList;

    @ApiModelProperty(name = "物料采购单核销发票", notes = "物料采购单核销发票")
    private List<TpmMaterialPurchasingOrderAuditInvoiceVo> auditInvoiceList;

    @ApiModelProperty("物料组编辑")
    private String materialGroupEdit;

    @ApiModelProperty("供应商编辑")
    private String supplierEdit;

}
