/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.material.purchasing.order.sdk.utils;

import cn.hutool.core.util.NumberUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.tool.xml.ElementHandler;
import com.itextpdf.tool.xml.Writable;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.itextpdf.tool.xml.pipeline.WritableElement;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class PdfUtil {
    public static Font NORMALFONT;
    public static Font BOLDFONT;
    public static float fixedHeight;
    public static int spacing;

    public static Document createDocument() {
        Document document = new Document();
        Rectangle rectangle = new Rectangle(PageSize.A4);
        rectangle.setBackgroundColor(BaseColor.WHITE);
        document.setPageSize(rectangle);
        document.setMargins(40.0f, 40.0f, 20.0f, 20.0f);
        return document;
    }

    public static Paragraph createParagraph(String text, Font font) {
        Paragraph elements = new Paragraph(text, font);
        elements.setSpacingBefore(5.0f);
        elements.setSpacingAfter(5.0f);
        elements.setSpacingAfter((float)spacing);
        return elements;
    }

    public static Font createFont(int fontNumber, int fontSize, BaseColor fontColor) {
        BaseFont bf = null;
        try {
            bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            return new Font(bf, (float)fontNumber, fontSize, fontColor);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Font(bf, 12.0f, 0, BaseColor.BLACK);
        }
    }

    public static void disableBorderSide(PdfPCell cell) {
        if (cell != null) {
            cell.disableBorderSide(1);
            cell.disableBorderSide(2);
            cell.disableBorderSide(4);
            cell.disableBorderSide(8);
        }
    }

    public static PdfPCell createCenterPdfPCell() {
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(5);
        cell.setHorizontalAlignment(1);
        cell.setFixedHeight(fixedHeight);
        return cell;
    }

    public static PdfPCell createCenterPdfPCell(String text, int rowSpan, int colSpan, Font font) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(text, font));
        cell.setVerticalAlignment(1);
        cell.setHorizontalAlignment(1);
        cell.setFixedHeight(fixedHeight);
        cell.setRowspan(rowSpan);
        cell.setColspan(colSpan);
        return cell;
    }

    public static PdfPTable createPdfPTable(int len) {
        PdfPTable pdfPTable = new PdfPTable(len);
        pdfPTable.setSpacingBefore(2.0f);
        pdfPTable.setHorizontalAlignment(1);
        return pdfPTable;
    }

    public static PdfPTable createPdfPTable(List<String> size) {
        ArrayList<Float> floatList = new ArrayList<Float>();
        for (String s : size) {
            BigDecimal rate = NumberUtil.div((BigDecimal)new BigDecimal(s.length()), (BigDecimal)new BigDecimal(3), (int)1, (RoundingMode)RoundingMode.HALF_UP);
            floatList.add(Float.valueOf(rate.floatValue()));
        }
        float[] floatArray = new float[floatList.size()];
        int i = 0;
        for (Float f : floatList) {
            floatArray[i++] = f != null ? f.floatValue() : Float.NaN;
        }
        PdfPTable pdfPTable = new PdfPTable(floatArray);
        pdfPTable.setSpacingBefore(2.0f);
        pdfPTable.setHorizontalAlignment(1);
        pdfPTable.setWidthPercentage(94.0f);
        return pdfPTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File fileToBytes(byte[] bytes, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            file = new File(filePath + fileName);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    public static Paragraph parseHtmlToParagraph(String str) throws IOException {
        StringReader body = new StringReader(str);
        final Paragraph para = new Paragraph();
        XMLWorkerHelper.getInstance().parseXHtml(new ElementHandler(){

            public void add(Writable w) {
                if (w instanceof WritableElement) {
                    List elements = ((WritableElement)w).elements();
                    for (Element e : elements) {
                        para.add(e);
                    }
                }
            }
        }, (Reader)body);
        return para;
    }

    static {
        fixedHeight = 25.0f;
        spacing = 5;
        try {
            BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            NORMALFONT = new Font(bfChinese, 10.0f, 0);
            BOLDFONT = new Font(bfChinese, 14.0f, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

