package com.biz.crm.tpm.business.month.budget.local.builder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.BudgetTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemControlConditionVo;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.local.calculate.BudgetCalculateStrategy;
import com.biz.crm.tpm.business.month.budget.local.calculate.dto.SalesDataDto;
import com.biz.crm.tpm.business.month.budget.local.calculate.vo.SalesDataVo;
import com.biz.crm.tpm.business.month.budget.local.helper.MonthBudgetHelper;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description 建造实际销量计算对象
 * @Author YangWei
 * @Date 2023/2/17 下午5:32
 */
@Slf4j
public class MonthBudgetActualSalesBuilder {
    /**
     * 月度预算Id
     */
    private List<String> monthBudgetIds;

    /**
     * 月度预算实际销量计算对象
     * key 月度预算编码
     */
    private Map<String, MonthBudgetActualSalesVo> monthBudgetActualSalesMap;

    /**
     * 计算策略
     */
    private List<BudgetCalculateStrategy> budgetCalculateStrategies;

    /**
     * 月度预算助手
     */
    private MonthBudgetHelper helper;

    /**
     * 月度预算集合
     */
    private List<MonthBudgetVo> monthBudgetVos;

    /**
     * 管控维度
     */
    private Map<String, List<DimensionControlsVo>> dimensionControlMap;

    /**
     * 管控维度
     */
    private Map<String, List<DimensionControlsVo>> dimensionControlMap2;

    /**
     * 构建
     */
    public MonthBudgetActualSalesBuilder(List<String> monthBudgetIds, List<BudgetCalculateStrategy> budgetCalculateStrategies
        , MonthBudgetHelper helper) {
        this.monthBudgetIds = monthBudgetIds;
        this.budgetCalculateStrategies = budgetCalculateStrategies;
        this.helper = helper;
    }

    /**
     * 初始化
     */
    public static MonthBudgetActualSalesBuilder init(List<String> monthBudgetIds
        , List<BudgetCalculateStrategy> budgetCalculateStrategies
        , MonthBudgetHelper helper) {
        log.info("实际销量计算对象,初始化");
        return new MonthBudgetActualSalesBuilder(monthBudgetIds, budgetCalculateStrategies, helper);
    }

    /**
     * 月度预算基础信息
     * @return
     */
    public MonthBudgetActualSalesBuilder basic(){
        log.info("实际销量计算对象,基础信息");
        this.monthBudgetActualSalesMap = Maps.newHashMap();
        //根据id查询月度预算集合
        this.monthBudgetVos = this.helper.findByIds(this.monthBudgetIds);
        //获取预算项目配置
        List<String> budgetItemCodes = this.monthBudgetVos.stream().map(MonthBudgetVo::getBudgetItemCode).distinct().collect(Collectors.toList());
        //key budgetItemCode
        Map<String, BudgetItemVo> budgetItemVoMap = this.helper.findBudgetItemByCodes(budgetItemCodes);
        // 查询预算管控配置，执行手动滚动
        //key
        this.dimensionControlMap = this.helper.findDimensionControl();
        this.dimensionControlMap2 = this.helper.findDimensionControlNoSalesOrg();



        this.monthBudgetVos.forEach(monthBudgetVo -> {
            //月度预算
            monthBudgetVo.setBudgetType(BudgetTypeEnum.MONTH_BUDGET.getCode());
            MonthBudgetActualSalesVo actualSalesVo = new MonthBudgetActualSalesVo();
            actualSalesVo.setId(monthBudgetVo.getId());
            actualSalesVo.setMonthBudgetCode(monthBudgetVo.getMonthBudgetCode());
            actualSalesVo.setYearBudgetCode(monthBudgetVo.getYearBudgetCode());
            actualSalesVo.setYearMonthLy(monthBudgetVo.getYearMonthLy());
            actualSalesVo.setFirstReplyAmount(monthBudgetVo.getFirstReplyAmount());
            actualSalesVo.setBudgetTotalPoint(monthBudgetVo.getBudgetTotalPoint());
            actualSalesVo.setBudgetType(monthBudgetVo.getBudgetType());
            actualSalesVo.setBusinessUnitCode(monthBudgetVo.getBusinessUnitCode());
            actualSalesVo.setBusinessFormatCode(monthBudgetVo.getBusinessFormatCode());
            actualSalesVo.setCalAmount(monthBudgetVo.getCalAmount());
            actualSalesVo.setBudgetIntensityDenominator(monthBudgetVo.getBudgetIntensityDenominator());
            actualSalesVo.setBudgetIntensityNumerator(monthBudgetVo.getBudgetIntensityNumerator());
            actualSalesVo.setSalesOrgCode(monthBudgetVo.getSalesOrgCode());
            actualSalesVo.setOrgCode(monthBudgetVo.getOrgCode());
            //获取预算项目管控条件
            String budgetItemCode = monthBudgetVo.getBudgetItemCode();
            BudgetItemVo budgetItemVo = budgetItemVoMap.get(budgetItemCode);
            BudgetItemControlConditionVo conditionVo = this.builderControl(monthBudgetVo, budgetItemVo);
            if(!ObjectUtils.isEmpty(conditionVo)){
                actualSalesVo.setControlTypeCode(conditionVo.getControlTypeCode());
                actualSalesVo.setDepartmentBelongCode(conditionVo.getDepartmentBelongCode());
                actualSalesVo.setFeeBelongCode(conditionVo.getFeeBelongCode());
            }else{
                return;
            }
            //查询预算计算配置
            BudgetCalConfigVo budgetCalConfigVo = this.helper.findMonthBudgetCalConfigByDto(monthBudgetVo, conditionVo.getControlTypeCode());
            log.info("月度预算["+monthBudgetVo.getMonthBudgetCode()+"]预算计算配置"+ JSON.toJSONString(budgetCalConfigVo));
            actualSalesVo.setBudgetCalConfigVo(budgetCalConfigVo);
            List<DimensionControlsVo> dimensionControlsVos = null;
            if (FeeBelongEnum.HEAD.getCode().equals(monthBudgetVo.getFeeBelongCode())) {
                String dimensionControlKey = monthBudgetVo.getBusinessFormatCode() + monthBudgetVo.getBusinessUnitCode();
                dimensionControlsVos = dimensionControlMap2.get(dimensionControlKey);
            } else {
                String dimensionControlKey = monthBudgetVo.getBusinessFormatCode() + monthBudgetVo.getBusinessUnitCode() + monthBudgetVo.getSalesOrgCode();
                dimensionControlsVos = dimensionControlMap.get(dimensionControlKey);
            }
            if (!CollectionUtils.isEmpty(dimensionControlsVos)) {
                log.error("通过业态业务单元销售组织筛选出来的管控配置={}", JSONObject.toJSONString(dimensionControlsVos));
                DimensionControlsVo dimensionControlsVo = this.helper.matchDimensionControl(dimensionControlsVos, monthBudgetVo.getBudgetItemCode());
                log.error("获取到的滚动管控配置={}", JSONObject.toJSONString(dimensionControlsVo));
                if (null != dimensionControlsVo) {
                    actualSalesVo.setRollingType(dimensionControlsVo.getRollingType());
                    actualSalesVo.setRolling(dimensionControlsVo.getIfRolling());
                }
            }
//            //管控维度
//            String controlKey = monthBudgetVo.getBusinessFormatCode() + monthBudgetVo.getBusinessUnitCode() + monthBudgetVo.getSalesOrgCode();
//            if (this.dimensionControlMap.containsKey(controlKey)) {
//                List<DimensionControlsVo> dimensionControlsList = this.dimensionControlMap.get(controlKey);
//                DimensionControlsVo dimensionControlsVo = this.helper.matchDimensionControl(dimensionControlsList, monthBudgetVo.getBudgetItemCode());
//                log.error("获取到的滚动管控配置={}", JSONObject.toJSONString(dimensionControlsVo));
//                actualSalesVo.setRollingType(dimensionControlsVo.getRollingType());
//                actualSalesVo.setRolling(dimensionControlsVo.getIfRolling());
//                dimensionControlsList.forEach(dimensionControlsVo -> {
//                    if (!CollectionUtils.isEmpty(dimensionControlsVo.getBudgetItemCodeList())
//                        && dimensionControlsVo.getBudgetItemCodeList().contains(monthBudgetVo.getBudgetItemCode())) {
//                        actualSalesVo.setRollingType(dimensionControlsVo.getRollingType());
//                        actualSalesVo.setRolling(dimensionControlsVo.getIfRolling());
//                    }
//                });
//            }
            this.monthBudgetActualSalesMap.put(monthBudgetVo.getMonthBudgetCode(), actualSalesVo);
        });
        return this;
    }

    /**
     * 销售数据
     * @param
     * @return {@link MonthBudgetActualSalesBuilder}
     */
    public MonthBudgetActualSalesBuilder salesData(){
        log.info("实际销量计算对象,查询销售数据,monthBudgetVos.size:{},budgetCalculateStrategies.size:{}",this.monthBudgetVos.size(),this.budgetCalculateStrategies.size());
        //循环查询
        this.monthBudgetVos.forEach(monthBudgetVo -> {
            String monthBudgetCode = monthBudgetVo.getMonthBudgetCode();
            MonthBudgetActualSalesVo actualSalesVo = this.monthBudgetActualSalesMap.get(monthBudgetCode);
            if(ObjectUtils.isEmpty(actualSalesVo)){
                return;
            }
            BusinessUnitEnum businessUnitEnum = BusinessUnitEnum.codeToEnum(monthBudgetVo.getBusinessUnitCode());
            //小业务单元的走主体的逻辑
            if (BusinessUnitEnum.isDefaultBusinessUnit(monthBudgetVo.getBusinessUnitCode())){
                businessUnitEnum = BusinessUnitEnum.HEADQUARTERS;
            }
            BusinessUnitEnum finalBusinessUnitEnum = businessUnitEnum;
            this.budgetCalculateStrategies.forEach(strategy -> {
                if(finalBusinessUnitEnum.getCode().equals(strategy.getBusinessUnit())){
                    //构建查询参数
                    SalesDataDto salesDataDto = strategy.buildDto(monthBudgetVo, actualSalesVo);
                    if (null != salesDataDto) {
                        //查询销售数据
                        log.info("月度预算[" + monthBudgetCode + "]日销售数据查询:" + JSON.toJSONString(salesDataDto));
                        Map<String, List<SalesDataVo>> salesData = strategy.findSalesData(salesDataDto);
                        //汇总数据
                        strategy.summarySalesData(actualSalesVo, salesData, salesDataDto, monthBudgetVo);
                    }
                }
            });
        });
        return this;
    }

    /**
     * 获取预算项目管控条件
     * @param monthBudgetVo
     * @param budgetItemVo
     * @return {@link BudgetItemControlConditionVo}
     */
    private BudgetItemControlConditionVo builderControl(MonthBudgetVo monthBudgetVo, BudgetItemVo budgetItemVo) {
        if(org.springframework.util.ObjectUtils.isEmpty(budgetItemVo)){
            return null;
        }else{
            List<BudgetItemControlConditionVo> controlConditionDtoList = budgetItemVo.getControlConditionDtoList();
            if(CollectionUtils.isEmpty(controlConditionDtoList)){
                return null;
            }else{
                List<BudgetItemControlConditionVo> conditionVos = budgetItemVo.getControlConditionDtoList().stream()
                    .filter(controlVo -> monthBudgetVo.getBusinessFormatCode().equals(controlVo.getBusinessFormatCode())
                        && monthBudgetVo.getBusinessUnitCode().equals(controlVo.getBusinessUnitCode()))
                    .collect(Collectors.toList());
                if(CollectionUtils.isEmpty(conditionVos)){
                    return null;
                }
                return conditionVos.get(0);
            }
        }
    }

    /**
     * 返回信息
     * @return
     */
    public Map<String, MonthBudgetActualSalesVo> builder() {
        return this.monthBudgetActualSalesMap;
    }
}