package com.biz.crm.tpm.business.month.budget.local.calculate;

import com.biz.crm.tpm.business.month.budget.local.calculate.dto.SalesDataDto;
import com.biz.crm.tpm.business.month.budget.local.calculate.vo.SalesDataVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetActualSalesVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;

import java.util.List;
import java.util.Map;

/**
 * @Description 预算计算策略
 * @Author YangWei
 * @Date Created in 2023/2/18 上午12:15
 */
public interface BudgetCalculateStrategy {

    /**
     * 获取类型
     * @param
     * @return {@link String}
     */
    String getBusinessUnit();

    /**
     * 构建查询销售数据参数
     * @param monthBudgetVo
     * @param actualSalesVo
     * @return {@link SalesDataDto}
     */
    SalesDataDto buildDto(MonthBudgetVo monthBudgetVo, MonthBudgetActualSalesVo actualSalesVo);

    /**
     * 查询销售数据
     * @param dto
     * @return {@link Map}<{@link String}, {@link List}<{@link SalesDataVo}>>
     */
    Map<String, List<SalesDataVo>> findSalesData(SalesDataDto dto);

    /**
     * 汇总得到实际销量
     */
    void summarySalesData(MonthBudgetActualSalesVo actualSalesVo, Map<String, List<SalesDataVo>> salesDataMap,SalesDataDto salesDataDto, MonthBudgetVo monthBudgetVo);

    /**
     * 计算数据
     * @param actualSalesVo
     * @param currMonthBudget
     */
    void calculation(MonthBudgetActualSalesVo actualSalesVo, MonthBudgetVo currMonthBudget);
}