package com.biz.crm.tpm.business.month.budget.local.calculate.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Description 查询销售数据参数
 * @Author YangWei
 * @Date 2023/2/18 上午12:38
 */
@Getter
@Setter
public class SalesDataDto extends TenantFlagOpDto {

    @ApiModelProperty("业态编码")
    private String businessFormatCode;

    @ApiModelProperty("业态名称")
    private String businessFormatName;

    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("年月日")
    private String yearMonthDay;

    @ApiModelProperty("销售机构编码")
    private String salesOrganizationCode;

    @ApiModelProperty("销售机构名称")
    private String salesOrganizationName;

    @ApiModelProperty("销售部门编码")
    private String salesOrgCode;

    @ApiModelProperty("销售部门名称")
    private String salesOrgName;

    @ApiModelProperty("销售组编码")
    private String salesGroupCode;

    @ApiModelProperty("销售组名称")
    private String salesGroupName;

    /**
     * 一级渠道编码
     */
    @ApiModelProperty(name = "一级渠道编码", notes = "")
    private String firstChannelCode;

    /**
     * 一级渠道名称
     */
    @ApiModelProperty(name = "一级渠道名称", notes = "")
    private String firstChannelName;


    /**
     * 二级渠道编码
     */
    @ApiModelProperty(name = "二级渠道编码", notes = "")
    private String secondChannelCode;

    /**
     * 二级渠道名称
     */
    @ApiModelProperty(name = "二级渠道名称", notes = "")
    private String secondChannelName;


    /**
     * 系统
     */
    @ApiModelProperty(name = "systemName",value = "系统",notes = "系统")
    private String systemName;
    /**
     * 系统编码
     */
    @ApiModelProperty(name = "systemCode",value = "系统编码",notes = "系统编码")
    private String systemCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户编码")
    private List<String> customerCodeList;
    private List<String> cusSalesOrgCodeList;//限制客户销售组织，客户销售组织变动情况

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户分类编码")
    private String customerClassifyCode;

    @ApiModelProperty("客户分类名称")
    private String customerClassifyName;

    @ApiModelProperty("门店编码")
    private String terminalCode;


    @ApiModelProperty("门店名称")
    private String terminalName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String productItemName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("新品/老品")
    private String newAndOldProduct;

    /*********************冗余******************************/
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;

    @ApiModelProperty("开始时间/日期")
    private String startTimeOrDate;

    @ApiModelProperty("结束时间/日期")
    private String endTimeOrDate;

    /**
     * 非包含产品编码
     */
    private List<String> excludeProductCodeList;

    /**
     * 非包含客户编码
     */
    private List<String> excludeCustomerCodeList;

    /**
     * 非包含终端编码
     */
    private List<String> excludeTerminalCodeList;

    /**
     * id
     */
    @ApiModelProperty("主键id")
    private String spId;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    private String salesDate;

    /**
     * 销售组织
     */
    @ApiModelProperty("销售组织")
    private String salesOrg;

    /**
     * 销售大区
     */
    @ApiModelProperty("销售大区(销售区域)")
    private String region;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品项
     */
    @ApiModelProperty("品项")
    private String categoryCode;

    /**
     * 品类划分
     */
    @ApiModelProperty("品类划分")
    private String classify;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String materialName;

    /**
     * 产品类型（新品、主品等）
     */
    @ApiModelProperty("产品类型（新品、主品等）")
    private String productType;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String materialCode;

    /**
     * 运达方（送达方）
     */
    @ApiModelProperty(" 运达方（送达方）")
    private String shipToparty;

    /**
     * 送达方名称(门店名称)
     */
    @ApiModelProperty("送达方名称(门店名称)")
    private String shipTopartyName;

    /**
     * 售达方名称出
     */
    @ApiModelProperty("系统（售达方）")
    private String soldTopartName;

    /**
     * 系统（售达方）
     */
    @ApiModelProperty("系统（售达方）")
    private String soldToparty;

    /**
     * 零售商
     */
    @ApiModelProperty(" 零售商")
    private String retailer;

    /**
     * 出库数量(收货订单数量)
     */
    @ApiModelProperty(" 出库数量(收货订单数量)")
    private BigDecimal warehsOutQty;

    /**
     * 出库折扣
     */
    @ApiModelProperty("出库折扣")
    private BigDecimal actualDiscount;

    /**
     * 折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("折前金额(订单含返点常规金额)")
    private BigDecimal orderRuleAmtInRebate;

    /**
     * 折后实际销额
     */
    @ApiModelProperty("折后实际销额")
    private BigDecimal warehsOutDiscountAmt;

    /**
     * 月累出库数量(收货订单数量)
     */
    @ApiModelProperty("月累出库数量(收货订单数量)")
    private BigDecimal warehsOutQtyIncM;

    /**
     * 月累出库折扣
     */
    @ApiModelProperty("月累出库折扣")
    private BigDecimal actualDiscountIncM;

    /**
     * 月累折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("月累折前金额(订单含返点常规金额)")
    private BigDecimal orderRuleAmtInRebateIncM;

    /**
     * 月累折后实际销额
     */
    @ApiModelProperty("月累折后实际销额")
    private BigDecimal warehsOutDiscountAmtIncM;

    /**
     * 年累出库数量(收货订单数量)
     */
    @ApiModelProperty("年累出库数量(收货订单数量)")
    private BigDecimal warehsOutQtyIncY;

    /**
     * 年累出库折扣
     */
    @ApiModelProperty("年累出库折扣")
    private BigDecimal actualDiscountIncY;

    /**
     * 年累折前金额(订单含返点常规金额)
     */
    @ApiModelProperty("年累折前金额(订单含返点常规金额)")
    private BigDecimal orderRuleAmtInRebateIncY;

    /**
     * 年累折后实际销额
     */
    @ApiModelProperty("年累折后实际销额")
    private BigDecimal warehsOutDiscountAmtIncY;

    @ApiModelProperty("销售 年 yyyy")
    private String yearCol;

    @ApiModelProperty("销售 月份 yyyyMM")
    private String salesMonth;

    /**
     * 包含产品编码
     */
    private List<String> includeProductCodeList;

    /**
     * 包含的销售机构编码
     */
    private List<String> salesInstitutionCodes;
}