package com.biz.crm.tpm.business.month.budget.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthBudgetConstant;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author huojia
 * @date 2022年11月16日 16:49
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = RocketMqUtil.ORDER + "${rocketmq.topic}" + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = MonthBudgetConstant.CAL_SALES_REPLAY_DIFF_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMqUtil.ORDER + MonthBudgetConstant.CAL_SALES_REPLAY_DIFF_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费， 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.ORDERLY)
public class MonthBudgetDiffConsumer extends AbstractRocketMqConsumer {

    @Resource
    private MonthBudgetService monthBudgetService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("=====>    月度预算计算上月滚动金额消息接收成功    <=====");
        List<String> ids = JSON.parseArray(message.getMsgBody(), String.class);
        monthBudgetService.calActualReplayDiff(ids);
        return "消费成功";
    }
}
