package com.biz.crm.tpm.business.month.budget.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.month.budget.local.service.SubComMonthBudgetDetailService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetAdjustDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetOperateDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.SubComMonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetChangeVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetDetailVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetMainAdjustVo;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author huojia
 * @date 2022年10月31日 20:40
 */
@RestController
@RequestMapping("/v1/month/budget/subsidiary")
@Slf4j
@Api(tags = "分子公司月度预算")
public class SubComMonthBudgetController {

    @Autowired(required = false)
    private SubComMonthBudgetService subComMonthBudgetService;

    @Autowired(required = false)
    private SubComMonthBudgetDetailService subComMonthBudgetDetailService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<SubComMonthBudgetVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "subComMonthBudgetDto", value = "分子公司月度预算信息") SubComMonthBudgetDto dto) {
        try {
            Page<SubComMonthBudgetVo> page = this.subComMonthBudgetService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询分子公司月度预算明细所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询分子公司月度预算明细所有数据")
    @GetMapping("/detail/findByConditions")
    public Result<Page<SubComMonthBudgetDetailVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                    @ApiParam(name = "subComMonthBudgetDetailDto", value = "分子公司月度预算明细信息") SubComMonthBudgetDetailDto dto) {
        try {
            Page<SubComMonthBudgetDetailVo> page = this.subComMonthBudgetDetailService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("detail")
    public Result<SubComMonthBudgetVo> detail(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
        try {
            SubComMonthBudgetVo subComMonthBudgetVo = this.subComMonthBudgetService.findById(id);
            return Result.ok(subComMonthBudgetVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<SubComMonthBudgetVo> create(@ApiParam(name = "subComMonthBudgetDto", value = "TPM-分子公司月度预算") @RequestBody SubComMonthBudgetDto dto) {
        try {
            SubComMonthBudgetVo result = this.subComMonthBudgetService.create(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param dto 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<SubComMonthBudgetVo> update(@ApiParam(name = "subComMonthBudgetAdjustDto", value = "TPM-分子公司月度预算") @RequestBody SubComMonthBudgetDto dto) {
        try {
            SubComMonthBudgetVo result = this.subComMonthBudgetService.update(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键集合
     * @return
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping()
    public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
        try {
            this.subComMonthBudgetService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 通过预算项目编码查询数据
     *
     * @param budgetItemCodeList 预算项目编码
     * @return 单条数据
     */
    @ApiOperation(value = "通过预算项目编码查询数据")
    @PostMapping("listByBudgetItemCodeList")
    public Result<List<SubComMonthBudgetVo>> listByBudgetItemCodeList(@RequestBody List<String> budgetItemCodeList) {
        try {
            List<SubComMonthBudgetVo> result = this.subComMonthBudgetService.listByBudgetItemCodeList(budgetItemCodeList);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据预算编码查询分子公司月度预算
     *
     * @param budgetCodeList 预算编码
     * @return 单条数据
     */
    @ApiOperation(value = "根据预算编码查询分子公司月度预算")
    @PostMapping("listByBudgetCodeList")
    public Result<List<SubComMonthBudgetVo>> listByBudgetCodeList(@RequestBody List<String> budgetCodeList) {
        try {
            List<SubComMonthBudgetVo> result = this.subComMonthBudgetService.listByBudgetCodeList(budgetCodeList);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分子公司活动规划生成对应分子公司月度预算
     *
     * @param subComMonthBudgetDtoList 预算项目编码
     * @return 单条数据
     */
    @ApiOperation(value = "分子公司活动规划生成对应分子公司月度预算")
    @PostMapping("designMonthBudget")
    public Result designMonthBudget(@RequestBody List<SubComMonthBudgetDto> subComMonthBudgetDtoList) {
        try {
            this.subComMonthBudgetService.designMonthBudget(subComMonthBudgetDtoList);
            return Result.ok("分子公司活动规划生成对应分子公司月度预算成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 调整
     *
     * @param dto 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "调整")
    @PostMapping("adjust")
    public Result adjust(@ApiParam(name = "subComMonthBudgetAdjustDto", value = "TPM-分子公司月度预算") @RequestBody SubComMonthBudgetAdjustDto dto) {
        try {
            this.subComMonthBudgetService.adjust(dto);
            return Result.ok("调整成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 审批中查看 调整明细
     *
     * @param processNo 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "审批中查看调整明细（bpm使用）")
    @GetMapping("adjustQuery")
    public Result<SubComMonthBudgetMainAdjustVo> adjustQuery(@RequestParam("processNo") @ApiParam(name = "processNo", value = "流程编码") String processNo) {
        try {
            SubComMonthBudgetMainAdjustVo monthBudgetMainAdjustVo = this.subComMonthBudgetService.adjustQuery(processNo);
            return Result.ok(monthBudgetMainAdjustVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 审批中查看 变更明细
     *
     * @param processNo 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "审批中查看变更明细（bpm使用）")
    @GetMapping("changeQuery")
    public Result<SubComMonthBudgetChangeVo> changeQuery(@RequestParam("processNo") @ApiParam(name = "processNo", value = "流程编码") String processNo) {
        try {
            SubComMonthBudgetChangeVo monthBudgetChangeVo = this.subComMonthBudgetService.changeQuery(processNo);
            return Result.ok(monthBudgetChangeVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 变更
     *
     * @param dto 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "变更")
    @PostMapping("change")
    public Result change(@ApiParam(name = "subComMonthBudgetOperateDto", value = "TPM-分子公司月度预算") @RequestBody SubComMonthBudgetOperateDto dto) {
        try {
            this.subComMonthBudgetService.change(dto);
            return Result.ok("变更成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 冻结
     *
     * @param dto 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "冻结")
    @PostMapping("freeze")
    public Result freeze(@ApiParam(name = "subComMonthBudgetOperateDto", value = "TPM-分子公司月度预算") @RequestBody SubComMonthBudgetOperateDto dto) {
        try {
            this.subComMonthBudgetService.unOrFreeze(dto, BudgetOperationTypeEnum.FREEZE.getCode());
            return Result.ok("冻结成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 解冻
     *
     * @param dto 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "解冻")
    @PostMapping("unfreeze")
    public Result unfreeze(@ApiParam(name = "subComMonthBudgetOperateDto", value = "TPM-分子公司月度预算") @RequestBody SubComMonthBudgetOperateDto dto) {
        try {
            this.subComMonthBudgetService.unOrFreeze(dto, BudgetOperationTypeEnum.UNFREEZE.getCode());
            return Result.ok("解冻成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分子公司月度预算手动滚动
     *
     * @param ids
     * @return com.biz.crm.business.common.sdk.model.Result
     * @author huojia
     * @date 2022/11/23 20:01
     **/
    @ApiOperation(value = "手动执行滚动")
    @PostMapping("manualRolling")
    public Result manualRolling(@ApiParam(name = "ids", value = "TPM-月度预算ids") @RequestBody List<String> ids) {
        try {
            this.subComMonthBudgetService.manualRolling(ids);
            return Result.ok("手动执行滚动成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
