package com.biz.crm.tpm.business.month.budget.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月27日 18:59
 */
@ApiModel(value = "MonthBudgetDetailEntity", description = "TPM-月度预算明细")
@TableName("tpm_month_budget_detail")
@Getter
@Setter
@Entity(name = "tpm_month_budget_detail")
@Table(name = "tpm_month_budget_detail", indexes = {
        @Index(name = "tpm_month_budget_detail_index1", columnList = "year_budget_code"),
        @Index(name = "tpm_month_budget_detail_index2", columnList = "month_budget_code"),
        @Index(name = "tpm_month_budget_detail_index3", columnList = "operation_type"),
        @Index(name = "tpm_month_budget_detail_index4", columnList = "business_code"),
        @Index(name = "tpm_month_budget_detail_index5", columnList = "create_time,id"),
        @Index(name = "tpm_month_budget_detail_index6", columnList = "process_no"),
        @Index(name = "tpm_month_budget_detail_index7", columnList = "create_time"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_month_budget_detail", comment = "TPM-月度预算明细")
public class MonthBudgetDetailEntity extends TenantFlagOpEntity {

    /**
     * 审批编码
     */
    @ApiModelProperty(name = "审批编码", notes = "")
    @Column(name = "process_no", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '审批编码 '")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty(name = "审批状态", notes = "")
    @Column(name = "process_status", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '审批状态 '")
    private String processStatus;

    /**
     * 年度预算编码
     */
    @ApiModelProperty(name = "年度预算编码", notes = "")
    @Column(name = "year_budget_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年度预算编码 '")
    private String yearBudgetCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    @Column(name = "month_budget_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算编码 '")
    private String monthBudgetCode;

    /**
     * 业务编码
     */
    @ApiModelProperty(value = "业务编码", notes = "")
    @Column(name = "business_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务编码 '")
    private String businessCode;

    /**
     * 操作类型[数据字典:tpm_budget_operation_type]
     */
    @ApiModelProperty(value = "操作类型[数据字典:tpm_budget_operation_type]", notes = "")
    @Column(name = "operation_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '操作类型[数据字典:tpm_budget_operation_type] '")
    private String operationType;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称 '")
    private String salesOrgName;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码", notes = "")
    @Column(name = "channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码 '")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty(value = "渠道名称", notes = "")
    @Column(name = "channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '渠道名称 '")
    private String channelName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码", notes = "")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码 '")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称", notes = "")
    @Column(name = "customer_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称 '")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码", notes = "")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码 '")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称", notes = "")
    @Column(name = "terminal_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '门店名称 '")
    private String terminalName;

    /**
     * 期初金额
     */
    @ApiModelProperty(value = "期初金额", notes = "")
    @Column(name = "initial_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '期初金额 '")
    private BigDecimal initialAmount;

    /**
     * 操作前金额
     */
    @ApiModelProperty(value = "操作前金额", notes = "")
    @Column(name = "before_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '操作前金额 '")
    private BigDecimal beforeAmount;

    /**
     * 当前操作金额
     */
    @ApiModelProperty(value = "当前操作金额", notes = "")
    @Column(name = "cur_operation_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '当前操作金额 '")
    private BigDecimal curOperationAmount;

    /**
     * 操作后余额
     */
    @ApiModelProperty(value = "操作后余额", notes = "")
    @Column(name = "balance_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '操作后余额 '")
    private BigDecimal balanceAmount;

    /**
     * 调出说明
     */
    @ApiModelProperty(value = "调出说明", notes = "")
    @Column(name = "operation_remarks", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '调出说明 '")
    private String operationRemarks;

    /**
     * 已结案金额
     */
    @Column(name = "already_end_case_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '已结案金额'")
    private BigDecimal alreadyEndCaseAmount;

    /**
     * 方案退预算发生年月
     */
    @ApiModelProperty("方案退预算发生年月")
    @Column(name = "plan_return_budget_year_and_month", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '方案退预算发生年月'")
    private String planReturnBudgetYearAndMonth;

    @ApiModelProperty("核销明细码")
    @Column(name = "audit_code", length = 256, columnDefinition = "VARCHAR(32) COMMENT '核销明细码'")
    private String auditCode;

    @ApiModelProperty("是否驳回")
    @Column(name = "reject", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否驳回'")
    private String reject;

    @ApiModelProperty("是否修改结案金额")
    @Column(name = "change_audit_amount", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否修改结案金额'")
    private String changeAuditAmount;

    @ApiModelProperty("是否修改批复结案差")
    @Column(name = "change_approved_audit_diff", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否修改批复结案差'")
    private String changeApprovedAuditDiff;

    @ApiModelProperty("是否修改调整金额")
    @Column(name = "change_adjust_amount", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否修改调整金额'")
    private String changeAdjustAmount;

    @ApiModelProperty("是否修改累计可用余额")
    @Column(name = "change_accumulated_available_balance", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否修改累计可用余额'")
    private String changeAccumulatedAvailableBalance;

    @ApiModelProperty("是否修改冻结后可用金额")
    @Column(name = "change_after_freeze_amount", length = 2, columnDefinition = "VARCHAR(2) COMMENT '是否修改冻结后可用金额'")
    private String changeAfterFreezeAmount;
}
