package com.biz.crm.tpm.business.month.budget.local.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author huojia
 * @date 2022年10月27日 9:53
 */
@ApiModel(value = "MonthBudgetEntity", description = "TPM-月度预算")
@TableName("tpm_month_budget")
@Getter
@Setter
@Entity(name = "tpm_month_budget")
@Table(name = "tpm_month_budget", indexes = {
        @Index(name = "tpm_month_budget_index1", columnList = "year_budget_code"),
        @Index(name = "tpm_month_budget_index2", columnList = "month_budget_code"),
        @Index(name = "tpm_month_budget_index3", columnList = "budget_item_code"),
        @Index(name = "tpm_month_budget_index4", columnList = "year_month_ly"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_month_budget", comment = "TPM-月度预算")
public class MonthBudgetEntity extends TenantFlagOpEntity {

    /**
     * 年度预算编码
     */
    @ApiModelProperty(value = "年度预算编码", notes = "")
    @Column(name = "year_budget_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年度预算编码 '")
    private String yearBudgetCode;

    /**
     * 月度预算编码
     */
    @ApiModelProperty(value = "月度预算编码", notes = "")
    @Column(name = "month_budget_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '月度预算编码 '")
    private String monthBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    @Column(name = "year_month_ly", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月'")
    private String yearMonthLy;

    @ApiModelProperty(value = "年月", notes = "")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @JSONField(format = "yyyy-MM")
    @Column(name = "year_month_date", nullable = true, columnDefinition = " datetime COMMENT '年月'")
    private Date yearMonthDate;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]", notes = "")
    @Column(name = "group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分组[数据字典:tpm_group_code] '")
    private String groupCode;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;

    /**
     * 组织层级
     */
    @ApiModelProperty(value = "组织层级", notes = "")
    @Column(name = "org_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织层级 '")
    private String orgLevelCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]", notes = "")
    @Column(name = "budget_item_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目层级[数据字典:tpm_budget_item_level] '")
    private String budgetItemLevelCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    @Column(name = "fee_belong_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用归口[数据字典:tpm_fee_belong] '")
    private String feeBelongCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称 '")
    private String salesOrgName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(value = "销售组织层级", notes = "")
    @Column(name = "sales_org_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织层级 '")
    private String salesOrgLevelCode;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "")
    @Column(name = "customer_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码 '")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "")
    @Column(name = "customer_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户渠道名称 '")
    private String customerChannelName;

    /**
     * 客户渠道层级
     */
    @ApiModelProperty(value = "客户渠道层级", notes = "")
    @Column(name = "customer_channel_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道层级 '")
    private String customerChannelLevelCode;

    /**
     * 门店渠道层级
     */
    @ApiModelProperty(value = "门店渠道层级", notes = "")
    @Column(name = "terminal_channel_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店渠道层级 '")
    private String terminalChannelLevelCode;

    /**
     * 门店渠道编码
     */
    @ApiModelProperty(value = "门店渠道编码", notes = "")
    @Column(name = "terminal_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店渠道编码 '")
    private String terminalChannelCode;

    /**
     * 门店渠道名称
     */
    @ApiModelProperty(value = "门店渠道名称", notes = "")
    @Column(name = "terminal_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店渠道名称 '")
    private String terminalChannelName;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码", notes = "")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码 '")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称", notes = "")
    @Column(name = "system_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '系统名称 '")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码", notes = "")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码 '")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称", notes = "")
    @Column(name = "customer_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称 '")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码", notes = "")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码 '")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称", notes = "")
    @Column(name = "terminal_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '门店名称 '")
    private String terminalName;

    /**
     * 区域编码
     */
    @ApiModelProperty(name = "区域编码", notes = "")
    @Column(name = "region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码 '")
    private String regionCode;

    /**
     * 区域名称
     */
    @ApiModelProperty(name = "区域名称", notes = "")
    @Column(name = "region_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '区域名称 '")
    private String regionName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码 '")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码", notes = "")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码 '")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称", notes = "")
    @Column(name = "product_category_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称 '")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码", notes = "")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码 '")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称", notes = "")
    @Column(name = "product_item_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品项名称 '")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码 '")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    @Column(name = "product_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品名称 '")
    private String productName;

    /**
     * 预算点数
     */
    @ApiModelProperty(value = "预算点数", notes = "")
    @Column(name = "budget_total_point", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算点数 '")
    private BigDecimal budgetTotalPoint;

    /**
     * 总目标量
     */
    @ApiModelProperty(name = "总目标量", notes = "")
    @Column(name = "total_goal_quantity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '总目标量 '")
    private BigDecimal totalGoalQuantity;

    /**
     * 年度力度
     */
    @ApiModelProperty(name = "年度力度", notes = "")
    @Column(name = "budget_intensity", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年度力度 '")
    private String budgetIntensity;

    /**
     * 年度力度-分子
     */
    @ApiModelProperty(name = "年度力度-分子", notes = "")
    @Column(name = "budget_intensity_numerator", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '年度力度-分子 '")
    private BigDecimal budgetIntensityNumerator;

    /**
     * 年度力度-分母
     */
    @ApiModelProperty(name = "年度力度-分母", notes = "")
    @Column(name = "budget_intensity_denominator", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '年度力度-分母 '")
    private BigDecimal budgetIntensityDenominator;

    /**
     * 年初分解金额（期初金额）
     */
    @ApiModelProperty(value = "年初分解金额（期初金额）", notes = "")
    @Column(name = "init_resolve_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '年初分解金额（期初金额） '")
    private BigDecimal initResolveAmount;

    /**
     * 审批中金额
     */
    @ApiModelProperty(value = "审批中金额", notes = "")
    @Column(name = "approving_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '审批中金额 '")
    private BigDecimal approvingAmount;

    /**
     * 月度分解金额
     */
    @ApiModelProperty(value = "月度分解金额", notes = "")
    @Column(name = "first_reply_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '月度分解金额 '")
    private BigDecimal firstReplyAmount;

    /**
     * 计算数据
     */
    @ApiModelProperty(value = "计算数据", notes = "")
    @Column(name = "cal_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '计算数据 '")
    private BigDecimal calAmount;

    /**
     * 首次回复预算金额与年初分解金额（期初金额）的差异
     */
    @ApiModelProperty(value = "首次回复预算金额与年初分解金额（期初金额）的差异", notes = "")
    @Column(name = "first_reply_resolve_diff_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '首次回复预算金额与年初分解金额（期初金额）的差异 '")
    private BigDecimal firstReplyResolveDiffAmount;

    /**
     * 上月滚动金额
     */
    @ApiModelProperty(value = "上月滚动金额", notes = "")
    @Column(name = "last_month_rolling_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '上月滚动金额 '")
    private BigDecimal lastMonthRollingAmount;

    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额", notes = "")
    @Column(name = "adjust_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '调整金额 '")
    private BigDecimal adjustAmount;

    /**
     * 上次实销与回复差异
     */
    @ApiModelProperty(value = "上次实销与回复差异", notes = "")
    @Column(name = "last_actual_sales_replay_diff_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '上次实销与回复差异 '")
    private BigDecimal lastActualSalesReplayDiffAmount;

    /**
     * 冻结金额
     */
    @ApiModelProperty(value = "冻结金额", notes = "")
    @Column(name = "freeze_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '冻结金额 '")
    private BigDecimal freezeAmount;

    /**
     * 冻结后可用金额
     */
    @ApiModelProperty(value = "冻结后可用金额", notes = "")
    @Column(name = "after_freeze_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '冻结后可用金额 '")
    private BigDecimal afterFreezeAmount;

    /**
     * 批复金额
     */
    @ApiModelProperty(value = "批复金额", notes = "")
    @Column(name = "approved_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '批复金额 '")
    private BigDecimal approvedAmount;

    /**
     * 预核销金额
     */
    @ApiModelProperty(value = "预核销金额", notes = "")
    @Column(name = "pre_audit_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预核销金额 '")
    private BigDecimal preAuditAmount;

    /**
     * 预估超额
     */
    @ApiModelProperty(value = "预估超额", notes = "")
    @Column(name = "estimated_excess_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预估超额 '")
    private BigDecimal estimatedExcessAmount;

    /**
     * 累计可用余额
     */
    @ApiModelProperty(value = "累计可用余额", notes = "")
    @Column(name = "accumulated_available_balance", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '累计可用余额 '")
    private BigDecimal accumulatedAvailableBalance;

    @ApiModelProperty("操作前金额")
    @Transient
    @TableField(exist = false)
    private BigDecimal oldAccumulatedAvailableBalance;

    /**
     * 可用费率
     */
    @ApiModelProperty(value = "可用费率", notes = "")
    @Column(name = "available_ratio", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '可用费率 '")
    private BigDecimal availableRatio;

    /**
     * 月度滚动金额
     */
    @ApiModelProperty(value = "月度滚动金额", notes = "")
    @Column(name = "month_rolling_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '月度滚动金额 '")
    private BigDecimal monthRollingAmount;

    /**
     * 月度结余金额
     */
    @ApiModelProperty(value = "月度结余金额", notes = "")
    @Column(name = "month_balance_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '月度结余金额 '")
    private BigDecimal monthBalanceAmount;

    /**
     * 过程回复预算金额
     */
    @ApiModelProperty(value = "过程回复预算金额", notes = "")
    @Column(name = "process_reply_budget_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '过程回复预算金额 '")
    private BigDecimal processReplyBudgetAmount;

    /**
     * 过程回复预算与年初分解预算的差异
     */
    @ApiModelProperty(value = "过程回复预算与年初分解预算的差异", notes = "")
    @Column(name = "process_reply_resolve_diff_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '过程回复预算与年初分解预算的差异 '")
    private BigDecimal processReplyResolveDiffAmount;

    /**
     * 过程参考可用余额
     */
    @ApiModelProperty(value = "过程参考可用余额", notes = "")
    @Column(name = "process_reference_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '过程参考可用余额 '")
    private BigDecimal processReferenceAmount;

    /**
     * 预算偏差
     */
    @ApiModelProperty(value = "预算偏差", notes = "")
    @Column(name = "process_offset_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算偏差 '")
    private BigDecimal processOffsetAmount;

    /**
     * 已使用策略金额
     */
    @ApiModelProperty(value = "已使用策略金额", notes = "")
    @Column(name = "used_strategy_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '已使用策略金额 '")
    private BigDecimal usedStrategyAmount;

    /**
     * 预算管控可用余额（注：现目前是根据预算管控配置表中 对应的月度预算统计出来）
     * 目前只有正向写入:预算管控配置新增后写入对应逻辑的余额
     * （不包括，月度预算本身修改）
     *  预算管控多次控制到一条数据只保留最后一条 后续人员会优化
     */
    @ApiModelProperty(value = "预算管控可用余额", notes = "")
    @Column(name = "control_balance_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '已使用策略金额 '")
    private BigDecimal controlBalanceAmount;

    /**
     * 预算计算编码
     */
    @ApiModelProperty(name = "预算计算编码", notes = "")
    @Column(name = "budget_cal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算计算编码 '")
    private String budgetCalCode;

    /**
     * 计算结果
     */
    @ApiModelProperty(name = "计算结果", notes = "")
    @Column(name = "computed_result", nullable = true, length = 125, columnDefinition = "VARCHAR(125) COMMENT '计算结果 '")
    private String computedResult;

    /**
     * 计费实销量
     */
    @ApiModelProperty(value = "计费实销量", notes = "")
    @Column(name = "bill_actual_sales", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '计费实销量 '")
    private BigDecimal billActualSales;

    /**
     * 实销金额
     */
    @ApiModelProperty(value = "实销金额", notes = "")
    @Column(name = "actual_sales", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实销金额 '")
    private BigDecimal actualSales;

    /**
     * 实际费用
     */
    @ApiModelProperty(value = "实际费用", notes = "")
    @Column(name = "actual_costs", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际费用 '")
    private BigDecimal actualCosts;

    @ApiModelProperty(value = "实销回复差", notes = "")
    @Column(name = "actual_reply_diff", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实销回复差 '")
    private BigDecimal ActualReplyDiff;

    @ApiModelProperty("是否滚动")
    @Column(name = "if_rolling", nullable = true, length = 2, columnDefinition = "varchar(64) COMMENT '是否滚动'")
    private String ifRolling;

    /**
     * 结案金额
     */
    @ApiModelProperty("结案金额")
    @Column(name = "audit_amount",  columnDefinition = "decimal(24,6) COMMENT '结案金额'")
    private BigDecimal auditAmount;
    /**
     * 批复结案差
     */
    @ApiModelProperty("批复结案差")
    @Column(name = "approved_audit_diff",  columnDefinition = "decimal(24,6) COMMENT '批复结案差'")
    private BigDecimal approvedAuditDiff;

    /**
     * 年度累计可用金额
     */
    @ApiModelProperty("年度累计可用金额")
    @Column(name = "year_total_available_amount",  columnDefinition = "decimal(24,6) COMMENT '年度累计可用金额'")
    private BigDecimal yearTotalAvailableAmount;

    /****************************冗余******************************/
    /**
     * 已结案金额
     */
    @Transient
    @TableField( exist = false)
    private BigDecimal alreadyEndCaseAmount;

    /**
     * 方案退预算发生年月
     */
    @Transient
    @TableField( exist = false)
    private String planReturnBudgetYearAndMonth;

    @Transient
    @TableField( exist = false)
    private String auditCode;

    /**
     * 明细备注
     */
    @Transient
    @TableField(exist = false)
    private String logRemark;

    @ApiModelProperty("是否修改结案金额")
    @Transient
    @TableField(exist = false)
    private String changeAuditAmount;

    @ApiModelProperty("是否修改批复结案差")
    @Transient
    @TableField(exist = false)
    private String changeApprovedAuditDiff;

    @ApiModelProperty("是否修改调整金额")
    @Transient
    @TableField(exist = false)
    private String changeAdjustAmount;

    @ApiModelProperty("是否修改累计可用余额")
    @Transient
    @TableField(exist = false)
    private String changeAccumulatedAvailableBalance;

    @ApiModelProperty("是否修改冻结后可用金额")
    @Transient
    @TableField(exist = false)
    private String changeAfterFreezeAmount;
}
