package com.biz.crm.tpm.business.month.budget.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月27日 9:53
 */
@ApiModel(value = "SubComMonthBudgetEntity", description = "TPM-分子公司月度预算")
@TableName("tpm_sub_com_month_budget")
@Getter
@Setter
@Entity(name = "tpm_sub_com_month_budget")
@Table(name = "tpm_sub_com_month_budget", indexes = {
        @Index(name = "tpm_sub_com_month_budget_index1", columnList = "month_budget_code"),
        @Index(name = "tpm_sub_com_month_budget_index2", columnList = "year_month_ly"),
        @Index(name = "tpm_sub_com_month_budget_index3", columnList = "budget_item_code"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_sub_com_month_budget", comment = "TPM-分子公司月度预算")
public class SubComMonthBudgetEntity extends TenantFlagOpEntity {

    /**
     * 分子公司月度预算编码
     */
    @ApiModelProperty(value = "分子公司月度预算编码", notes = "")
    @Column(name = "month_budget_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分子公司月度预算编码 '")
    private String monthBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    @Column(name = "year_month_ly", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月 '")
    private String yearMonthLy;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]", notes = "")
    @Column(name = "group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分组[数据字典:tpm_group_code] '")
    private String groupCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]", notes = "")
    @Column(name = "budget_item_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目层级[数据字典:tpm_budget_item_level] '")
    private String budgetItemLevelCode;

    /**
     * 费用来源[数据字典:tpm_fee_source]
     */
    @ApiModelProperty(name = "费用来源[数据字典:tpm_fee_source]", notes = "")
    @Column(name = "fee_source_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用来源[数据字典:tpm_fee_source] '")
    private String feeSourceCode;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;

    /**
     * 组织层级
     */
    @ApiModelProperty(value = "组织层级", notes = "")
    @Column(name = "org_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织层级 '")
    private String orgLevelCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;


    /**
     * 所属销售机构erp编码
     */
    @ApiModelProperty("所属销售机构erp编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构erp编码'")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    /**
     * 销售大区编码
     */
    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionCode;

    /**
     * 销售大区erp编码
     */
    @ApiModelProperty("所属销售大区erp编码")
    @Column(name = "sales_region_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区erp编码 '")
    private String salesRegionErpCode;

    /**
     * 销售大区名称
     */
    @ApiModelProperty("所属销售大区名称")
    @Column(name = "sales_region_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属销售大区名称 '")
    private String salesRegionName;

    /**
     * 所属销售组织(组)编码
     */
    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;


    /**
     * 所属销售组织(组)erp编码
     */
    @ApiModelProperty("所属销售组织(组)erp编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)erp编码'")
    private String salesOrgErpCode;

    /**
     * 所属销售组织(组)名称
     */
    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售组织(组)名称'")
    private String salesOrgName;

    /**
     * 渠道层级
     */
    @ApiModelProperty(value = "渠道层级", notes = "")
    @Column(name = "channel_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道层级 '")
    private String channelLevelCode;

    /**
     * 渠道编码
     */
    @ApiModelProperty(value = "渠道编码", notes = "")
    @Column(name = "channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码 '")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty(value = "渠道名称", notes = "")
    @Column(name = "channel_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '渠道名称 '")
    private String channelName;

    /**
     * 系统编码
     */
    @ApiModelProperty(value = "系统编码", notes = "")
    @Column(name = "system_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码 '")
    private String systemCode;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称", notes = "")
    @Column(name = "system_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '系统名称 '")
    private String systemName;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码", notes = "")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码 '")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称", notes = "")
    @Column(name = "customer_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '客户名称 '")
    private String customerName;

    /**
     * 门店编码
     */
    @ApiModelProperty(value = "门店编码", notes = "")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码 '")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称", notes = "")
    @Column(name = "terminal_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '门店名称 '")
    private String terminalName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码 '")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码", notes = "")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码 '")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称", notes = "")
    @Column(name = "product_category_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称 '")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码", notes = "")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码 '")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称", notes = "")
    @Column(name = "product_item_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品项名称 '")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(value = "产品编码", notes = "")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码 '")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(value = "产品名称", notes = "")
    @Column(name = "product_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '产品名称 '")
    private String productName;

    /**
     * 预算点数
     */
    @ApiModelProperty(value = "预算点数", notes = "")
    @Column(name = "budget_total_point", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算点数 '")
    private BigDecimal budgetTotalPoint;

    /**
     * 预算金额
     */
    @ApiModelProperty(value = "预算金额", notes = "")
    @Column(name = "budget_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算金额 '")
    private BigDecimal budgetAmount;

    /**
     * 上月滚动金额
     */
    @ApiModelProperty(value = "上月滚动金额", notes = "")
    @Column(name = "last_month_rolling_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '上月滚动金额 '")
    private BigDecimal lastMonthRollingAmount;

    /**
     * 调整金额
     */
    @ApiModelProperty(value = "调整金额", notes = "")
    @Column(name = "adjust_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '调整金额 '")
    private BigDecimal adjustAmount;

    /**
     * 冻结金额
     */
    @ApiModelProperty(value = "冻结金额", notes = "")
    @Column(name = "freeze_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '冻结金额 '")
    private BigDecimal freezeAmount;

    /**
     * 审批中金额
     */
    @ApiModelProperty(value = "审批中金额", notes = "")
    @Column(name = "approving_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '审批中金额 '")
    private BigDecimal approvingAmount;

    /**
     * 批复金额
     */
    @ApiModelProperty(value = "批复金额", notes = "")
    @Column(name = "approved_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '批复金额 '")
    private BigDecimal approvedAmount;

    /**
     * 向上结案差
     */
    @ApiModelProperty(value = "向上结案差", notes = "")
    @Column(name = "up_audit_diff_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '向上结案差 '")
    private BigDecimal upAuditDiffAmount;

    /**
     * 本期结余金额
     */
    @ApiModelProperty(value = "本期结余金额", notes = "")
    @Column(name = "current_balance_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '本期结余金额 '")
    private BigDecimal currentBalanceAmount;

    @ApiModelProperty("数据来源")
    @Column(name = "data_source",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '数据来源'")
    private String dataSource;
}
