package com.biz.crm.tpm.business.month.budget.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月27日 18:59
 */
@ApiModel(value = "SubComMonthBudgetPlanBudgetEntity", description = "TPM-分子公司月度预算方案、细案预算明细")
@TableName("tpm_sub_com_month_budget_plan_budget")
@Getter
@Setter
@Entity(name = "tpm_sub_com_month_budget_plan_budget")
@Table(name = "tpm_sub_com_month_budget_plan_budget", indexes = {@Index(name = "tpm_sub_com_month_budget_plan_budget_index1", columnList = "month_budget_code")})
@org.hibernate.annotations.Table(appliesTo = "tpm_sub_com_month_budget_plan_budget", comment = "TPM-分子公司月度预算方案、细案预算明细")
public class SubComMonthBudgetPlanBudgetEntity extends TenantFlagOpEntity {

    /**
     * 分子公司预算编码
     */
    @ApiModelProperty(value = "分子公司预算编码", notes = "")
    @Column(name = "month_budget_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分子公司预算编码 '")
    private String monthBudgetCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 活动规划编码
     */
    @ApiModelProperty(name = "活动规划编码", notes = "")
    @Column(name = "activity_design_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动规划编码 '")
    private String activityDesignCode;

    /**
     * 活动规划名称
     */
    @ApiModelProperty(name = "活动规划名称", notes = "")
    @Column(name = "activity_design_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动规划名称 '")
    private String activityDesignName;

    /**
     * 活动规划明细编码
     */
    @ApiModelProperty(name = "活动规划明细编码", notes = "")
    @Column(name = "activity_design_detail_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动规划明细编码 '")
    private String activityDesignDetailCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    @Column(name = "year_month_ly", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月 '")
    private String yearMonthLy;

    /**
     * 活动方案、活动细案编码
     */
    @ApiModelProperty(value = "活动方案、活动细案编码", notes = "")
    @Column(name = "plan_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动方案、活动细案编码 '")
    private String planCode;

    /**
     * 活动方案、活动细案名称
     */
    @ApiModelProperty(value = "活动方案、活动细案名称", notes = "")
    @Column(name = "plan_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动方案、活动细案名称 '")
    private String planName;

    /**
     * 活动方案、活动细案明细编码
     */
    @ApiModelProperty(value = "活动方案、活动细案明细编码", notes = "")
    @Column(name = "plan_detail_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动方案、活动细案明细编码 '")
    private String planDetailCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    /**
     * 预算金额
     */
    @ApiModelProperty(value = "预算金额", notes = "")
    @Column(name = "budget_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算金额 '")
    private BigDecimal budgetAmount;
}
