package com.biz.crm.tpm.business.month.budget.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @CLASS_DESCRIBE: 垂直区域费用预警
 * @AUTHOR: create by zkey on 2023-11-03
 */
@ApiModel(value = "VerticalAreaFeeWarningEntity", description = "TPM-垂直区域费用预警")
@TableName("tpm_vertical_area_fee_warning")
@Getter
@Setter
@Entity(name = "tpm_vertical_area_fee_warning")
@Table(name = "tpm_vertical_area_fee_warning", indexes = {
        @Index(name = "tpm_vertical_area_fee_warning_index1", columnList = "year_month_ly"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_vertical_area_fee_warning", comment = "TPM-垂直区域费用预警")
public class VerticalAreaFeeWarningEntity extends TenantOpEntity {

    @ApiModelProperty(value = "年月", notes = "")
    @Column(name = "year_month_ly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月'")
    private String yearMonthLy;

    @ApiModelProperty(value = "年", notes = "")
    @Column(name = "year_str", length = 16, columnDefinition = "VARCHAR(16) COMMENT '年'")
    private String yearStr;

    @ApiModelProperty(value = "月", notes = "")
    @Column(name = "month_str", length = 16, columnDefinition = "VARCHAR(16) COMMENT '月'")
    private String monthStr;

    @ApiModelProperty(name = "区域编码", notes = "")
    @Column(name = "region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码 '")
    private String regionCode;

    @ApiModelProperty(value = "系统编码", notes = "")
    @Column(name = "system_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码 '")
    private String systemCode;

    @ApiModelProperty(value = "系统名称", notes = "")
    @Column(name = "system_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '系统名称 '")
    private String systemName;

    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    @Column(name = "fee_belong_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用归口[数据字典:tpm_fee_belong]'")
    private String feeBelongCode;

    @ApiModelProperty(value = "预算额", notes = "")
    @Column(name = "init_resolve_amount", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT '预算额'")
    private BigDecimal initResolveAmount;

    @ApiModelProperty(value = "预算销量", notes = "")
    @Column(name = "budget_sales", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT '预算销量'")
    private BigDecimal budgetSales;

    @ApiModelProperty(value = "预计折后销售额", notes = "")
    @Column(name = "estimated_discount_sales", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT '预计折后销售额'")
    private BigDecimal estimatedDiscountSales;

    @ApiModelProperty(value = "预算点数", notes = "")
    @Column(name = "budget_points", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT ' 预算点数'")
    private BigDecimal budgetPoints;

    @ApiModelProperty(value = "预计费用额", notes = "")
    @Column(name = "estimated_fee_amount", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT '预计费用额'")
    private BigDecimal estimatedFeeAmount;

    @ApiModelProperty(value = "累计预算额", notes = "")
    @Column(name = "accumulate_budget_amount", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT '累计预算额'")
    private BigDecimal accumulateBudgetAmount;

    @ApiModelProperty(value = "累计预算销量", notes = "")
    @Column(name = "accumulate_budget_sales", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT '累计预算销量'")
    private BigDecimal accumulateBudgetSales;

    @ApiModelProperty(value = "累计预算点数", notes = "")
    @Column(name = "accumulate_budget_points", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT '累计预算点数'")
    private BigDecimal accumulateBudgetPoints;

    @ApiModelProperty(value = "累计已使用费用额", notes = "")
    @Column(name = "accumulate_use_amount", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT '累计已使用费用额'")
    private BigDecimal accumulateUseAmount;

    @ApiModelProperty(value = "累计折后销售额", notes = "")
    @Column(name = "accumulate_discount_amount", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT '累计折后销售额'")
    private BigDecimal accumulateDiscountAmount;

    @ApiModelProperty(value = "累计预计剩余费用额", notes = "")
    @Column(name = "accumulate_residue_amount", length = 20, columnDefinition = "DECIMAL(30,6) COMMENT '累计预计剩余费用额'")
    private BigDecimal accumulateResidueAmount;
}
