package com.biz.crm.tpm.business.month.budget.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @CLASS_DESCRIBE: 垂直预警面板
 * @AUTHOR: create by zkey on 2023-11-03
 */
@ApiModel(value = "VerticalAreaFeeWarningPanelEntity", description = "TPM-垂直预警面板")
@TableName("tpm_vertical_area_fee_warning_panel")
@Getter
@Setter
@Entity(name = "tpm_vertical_area_fee_warning_panel")
@Table(name = "tpm_vertical_area_fee_warning_panel", indexes = {
        @Index(name = "tpm_vertical_area_fee_warning_panel_index1", columnList = "year_month_ly"),
        @Index(name = "tpm_vertical_area_fee_warning_panel_index2", columnList = "union_key"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_vertical_area_fee_warning_panel", comment = "TPM-垂直预警面板")
public class VerticalWarningPanelEntity extends TenantOpEntity {

    @ApiModelProperty(value = "年月")
    @Column(name = "year_month_ly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月'")
    private String yearMonthLy;

    @ApiModelProperty(value = "去年")
    @Column(name = "last_year", length = 16, columnDefinition = "VARCHAR(16) COMMENT '去年'")
    private String lastYear;

    @ApiModelProperty(value = "联合键")
    @Column(name = "union_key", columnDefinition = "VARCHAR(255) COMMENT '联合键'")
    private String unionKey;

    @ApiModelProperty(name = "区域编码")
    @Column(name = "region_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区域编码 '")
    private String regionCode;

    @ApiModelProperty(value = "系统编码")
    @Column(name = "system_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统编码 '")
    private String systemCode;

    @ApiModelProperty(value = "系统名称")
    @Column(name = "system_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '系统名称 '")
    private String systemName;

    @ApiModelProperty("销量达成率")
    @Column(name = "sales_achievement_rate", columnDefinition = "decimal(20,4) COMMENT '销量达成率'")
    private BigDecimal salesAchievementRate;

    @ApiModelProperty("POS费用率")
    @Column(name = "pos_fee_rate", columnDefinition = "decimal(20,4) COMMENT 'POS费用率'")
    private BigDecimal posFeeRate;

    @ApiModelProperty("折后实际销额")
    @Column(name = "discount_sales_amount", columnDefinition = "decimal(30,6) COMMENT '折后实际销额'")
    private BigDecimal discountSalesAmount;

    @ApiModelProperty("销售任务折后金额")
    @Column(name = "sales_discount_amount", columnDefinition = "decimal(30,6) COMMENT '销售任务折后金额'")
    private BigDecimal salesDiscountAmount;

    @ApiModelProperty("预算已使用金额")
    @Column(name = "budget_use_amount", columnDefinition = "decimal(30,6) COMMENT '预算已使用金额'")
    private BigDecimal budgetUseAmount;

    @ApiModelProperty("年初分解金额")
    @Column(name = "init_resolve_amount", columnDefinition = "decimal(30,6) COMMENT '年初分解金额'")
    private BigDecimal initResolveAmount;

    @ApiModelProperty(value = "预算项目编码")
    @Column(name = "budget_item_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码 '")
    private String budgetItemCode;

    @ApiModelProperty(value = "预算项目名称")
    @Column(name = "budget_item_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '预算项目名称 '")
    private String budgetItemName;

    @ApiModelProperty("当前率")
    @Column(name = "current_rate", columnDefinition = "decimal(30,6) COMMENT '当前率'")
    private BigDecimal currentRate;

    @ApiModelProperty("VS预算")
    @Column(name = "vs_budget", columnDefinition = "decimal(30,6) COMMENT 'VS预算'")
    private BigDecimal vsBudget;

    @ApiModelProperty("VS同期")
    @Column(name = "vs_tq", columnDefinition = "decimal(30,6) COMMENT 'VS预算'")
    private BigDecimal vsTq;
}
