package com.biz.crm.tpm.business.month.budget.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.month.budget.local.mapper.SubComMonthBudgetDetailExportMapper;
import com.biz.crm.tpm.business.month.budget.sdk.constant.MonthBudgetConstant;
import com.biz.crm.tpm.business.month.budget.sdk.dto.SubComMonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.SubComMonthBudgetDetailExportVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/2/3 11:20
 * @description:
 */
@Component
public class SubComMonthBudgetDetailExportProcess implements ExportProcess<SubComMonthBudgetDetailExportVo> {

    @Autowired(required = false)
    private SubComMonthBudgetDetailExportMapper exportMapper;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;


    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }


    @Override
    public Integer getTotal(Map<String, Object> params) {
        SubComMonthBudgetDetailDto dto = this.convertParams(params);
        Page<SubComMonthBudgetDetailExportVo> pageResult = this.exportMapper.findExportByConditions(new Page<>(0, 1), dto);
        Integer total = (int) pageResult.getTotal();
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    private SubComMonthBudgetDetailDto convertParams(Map<String, Object> params) {
        return JSON.parseObject(JSON.toJSONString(params), SubComMonthBudgetDetailDto.class);
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        SubComMonthBudgetDetailDto dto = this.convertParams(params);
        Page<SubComMonthBudgetDetailExportVo> pageable = new Page<>(vo.getPageNo() + 1, this.getPageSize());
        Page<SubComMonthBudgetDetailExportVo> page = this.exportMapper.findExportByConditions(pageable, dto);
        return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
    }

    @Override
    public Class<SubComMonthBudgetDetailExportVo> findCrmExcelVoClass() {
        return SubComMonthBudgetDetailExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "TPM_SUB_COM_MONTH_BUDGET_DETAIL_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "分子公司月度预算明细导出";
    }

    /**
     * 调整数据
     *
     * @param data 待调整数据
     * @return 调整后数据
     */
    private List<SubComMonthBudgetDetailExportVo> adjustData(List<SubComMonthBudgetDetailExportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<>(0);
        }
        Map<String, String> mapDict = this.dictToolkitService.findMapByDictTypeCode(MonthBudgetConstant.DICT_TPM_BUDGET_OPERATION_TYPE);
        for (SubComMonthBudgetDetailExportVo datum : data) {
            datum.setOperationType(mapDict.getOrDefault(datum.getOperationType(), datum.getOperationType()));
            if (StringUtils.isNotBlank(datum.getBusinessUnitCode())) {
                BusinessUnitEnum unitEnum = BusinessUnitEnum.codeToEnum(datum.getBusinessUnitCode());
                if (null != unitEnum) {
                    datum.setBusinessUnitCode(unitEnum.getDesc());
                }
            }
        }
        return data;
    }
}
