package com.biz.crm.tpm.business.month.budget.local.filter;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class MonthBudgetConditionByOrg extends MonthBudgetConditionFilter{

    @Autowired
    private OrgVoService orgVoService;

    @Autowired
    private LoginUserService loginUserService;

    /**
     * 根据组织构建dto查询条件
     *
     * @param dto dto
     */
    @Override
    protected void buildByOrganization(MonthBudgetDto dto) {
        //获取当前组织级下级
        FacturerUserDetails loginDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
        if (loginDetails != null){
            List<OrgVo> children = orgVoService.findAllChildrenByOrgCode(loginDetails.getOrgCode());
            if (CollectionUtil.isNotEmpty(children)){
                Set<String> orgCodes = children.stream().map(OrgVo::getOrgCode).filter(Objects::nonNull).collect(Collectors.toSet());
                orgCodes.add(loginDetails.getOrgCode());
                dto.setOrgCodes(orgCodes);
            }
        }
    }
}
