package com.biz.crm.tpm.business.month.budget.local.filter;

import cn.hutool.core.util.StrUtil;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetGroupEnum;

public abstract class MonthBudgetConditionFilter {

    /**
     * 获取分组
     *
     * @param businessFormatCode
     *            业态
     * @param businessUnitCode
     *            业务单元
     */
    protected MonthBudgetGroupEnum getGroup(String businessFormatCode, String businessUnitCode) {
        if (StrUtil.isBlank(businessFormatCode) || StrUtil.isBlank(businessUnitCode)) {
            return null;
        }
        if (BusinessFormatEnum.NORMAL.getCode().equals(businessFormatCode)
            && BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode)) {
            return MonthBudgetGroupEnum.organization;
        }
        return null;
    }

    /**
     * 构建dto参数
     *
     * @param monthBudgetDto
     *            月预算dto
     */
    public void buildDto(MonthBudgetDto monthBudgetDto) {
        MonthBudgetGroupEnum budgetGroupEnum =
            this.getGroup(monthBudgetDto.getBusinessFormatCode(), monthBudgetDto.getBusinessUnitCode());
//        MonthBudgetGroupEnum budgetGroupEnum =  MonthBudgetGroupEnum.getEnumByCode(monthBudgetDto.getGroupCode());
        if (budgetGroupEnum == null) {
            return;
        }
        switch (budgetGroupEnum) {
            case system:
                this.buildBySystem(monthBudgetDto);
                break;
            case customer:
                this.buildByCustomer(monthBudgetDto);
                break;
            case organization:
                this.buildByOrganization(monthBudgetDto);
                break;
            case channel:
                this.buildByChannel(monthBudgetDto);
                break;
            case terminal:
                this.buildByTerminal(monthBudgetDto);
                break;
            default:
                break;
        }
    }

    /**
     * 构建零售商
     *
     * @param dto
     *            dto
     */
    protected void buildBySystem(MonthBudgetDto dto) {}

    /**
     * 建立客户
     *
     * @param dto
     *            dto
     */
    protected void buildByCustomer(MonthBudgetDto dto) {}

    /**
     * 建立部门
     *
     * @param dto
     *            dto
     */
    protected void buildByOrganization(MonthBudgetDto dto) {}

    /**
     * 建立渠道
     *
     * @param dto
     *            dto
     */
    protected void buildByChannel(MonthBudgetDto dto) {}

    /**
     * 建立门店
     *
     * @param dto
     *            dto
     */
    protected void buildByTerminal(MonthBudgetDto dto) {}

}
