package com.biz.crm.tpm.business.month.budget.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.month.budget.local.entity.MonthBudgetDetailEntity;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author huojia
 * @date 2022年10月27日 20:11
 */
public interface MonthBudgetDetailMapper extends BaseMapper<MonthBudgetDetailEntity> {

    /**
     * 分页查询所有预算明细
     *
     * @param page
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetDetailVo>
     * @author huojia
     * @date 2022/10/27 21:24
     **/
    Page<MonthBudgetDetailVo> findByConditions(Page<MonthBudgetDetailVo> page, @Param("dto") MonthBudgetDetailDto dto);

    /**
     * 根据月度预算Ids查询明细
     * @param ids
     * @return {@link List}<{@link MonthBudgetDetailVo}>
     */
    List<MonthBudgetDetailVo> findByMainIds(@Param("ids") List<String> ids, @Param("operationType") String operationType);

    void updateStatusByBusiness(@Param("list") List<MonthBudgetDetailVo> monthBudgetDetailVos);
}
